/*
 * #%L
 * IsisFish
 * 
 * $Id: Docable.java 3420 2011-06-17 13:55:14Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Ifremer, Code Lutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.util;

/**
 * This is the contract to be realize by any class which wanted to have a @Doc support.
 *
 * @author chemit
 * @see Doc
 * @version $Revision: 3420 $
 * 
 * Last update : $Date: 2011-06-17 15:55:14 +0200 (ven., 17 juin 2011) $
 * By : $Author: chatellier $
 */
public interface Docable {

    /**
     * Field documentation (if any).
     * 
     * @param fieldName name of the field to use
     * @return the @Doc of the field, or null if none
     */
    Doc getFieldDoc(String fieldName);

    /**
     * Class documentation (if any).
     * 
     * @return the description of the class, or null if none
     */
    String getDescription();
}
