/*
 * #%L
 * IsisFish
 * 
 * $Id: ErrorHelper.java 3460 2011-10-06 20:08:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Ifremer, CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.util;

import static org.nuiton.i18n.I18n._;

import java.awt.Component;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import javax.swing.JOptionPane;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.MultiPartEmail;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.error.ErrorReporter;

import fr.ifremer.isisfish.IsisConfig;
import fr.ifremer.isisfish.IsisFish;

/**
 * Error helper.
 * 
 * @author chatellier
 * @version $Revision: 3460 $
 * 
 * Last update : $Date: 2011-10-06 22:08:09 +0200 (jeu., 06 oct. 2011) $
 * By : $Author$
 */
public class ErrorHelper implements ErrorReporter {

    /**
     * Display a user friendly error frame.
     * 
     * @param parent parent component
     * @param message message for user
     * @param cause exception cause
     */
    public static void showErrorDialog(Component parent, String message,
            Throwable cause) {
        JXErrorPane pane = new JXErrorPane();
        ErrorInfo info = new ErrorInfo(_("isisfish.error.errorpane.title"),
                _("isisfish.error.errorpane.htmlmessage", message), null, null,
                cause, null, null);
        pane.setErrorInfo(info);
        if (cause != null) {
            pane.setErrorReporter(new ErrorHelper());
        }
        JXErrorPane.showDialog(parent, pane);
    }

    /**
     * Display a user friendly error frame.
     * 
     * @param message message for user
     */
    public static void showErrorDialog(String message) {
        showErrorDialog(message, null);
    }

    /**
     * Display a user friendly error frame.
     * 
     * @param message message for user
     * @param cause exception cause
     */
    public static void showErrorDialog(String message, Throwable cause) {
        showErrorDialog(null, message, cause);
    }

    /*
     * @see org.jdesktop.swingx.error.ErrorReporter#reportError(org.jdesktop.swingx.error.ErrorInfo)
     */
    @Override
    public void reportError(ErrorInfo errorInfo) throws NullPointerException {

        MultiPartEmail email = new MultiPartEmail();
        try {
            String emailTo = "support@codelutin.com";

            // smtp
            email.setHostName("smtp");
            // to
            email.addTo(emailTo, "Support");
            
            // from
            email.setFrom("no-reply@isis-fish.org", "Isis-Fish");
            // subject
            email.setSubject("Project error notification : Isis-Fish");
            // add reply-to for spam
            email.addReplyTo("no-reply@isis-fish.org");
            
            // message description
            String message = formatMessage("Project", "Isis-Fish " + IsisConfig.getVersion());
            message += formatMessage("Date", new Date().toString());
            message += formatMessage("Title", errorInfo.getTitle());
            message += formatMessage("Description", errorInfo.getBasicErrorMessage().replaceAll("<[^>]+>", ""));

            // message configuration
            message += formatMessage("Configuration", null);
            List<String> propertiesNames = new ArrayList<String>(IsisFish.config.getOptions().stringPropertyNames());
            Collections.sort(propertiesNames);
            for (String propertyName : propertiesNames) {
                // security, don't send string containing password :
                if (!propertyName.contains("pass")) {
                    message += "\t" + propertyName + " : " + IsisFish.config.getOptions().getProperty(propertyName) + "\n";
                }
            }

            // message exception
            StringWriter out = new StringWriter();
            PrintWriter writer = new PrintWriter(out);
            errorInfo.getErrorException().printStackTrace(writer);
            message += formatMessage("Exception", out.toString());

            // TODO i18n files are iso encoded :(
            email.setContent(message, "text/plain; charset=ISO-8859-9");

            // send mail
            email.send();
            
            JOptionPane.showMessageDialog(null, "A report message has been sent to " + emailTo);
        } catch (EmailException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }
    
    protected String formatMessage(String category, String content) {
        String formatted = category + " :\n";
        if (StringUtils.isNotEmpty(content)) {
            formatted += "\t" + content + "\n";
        }
        return formatted;
    }
}
