/*
 * #%L
 * IsisFish
 * 
 * $Id: SensitivityAnalysisComboModel.java 3436 2011-07-07 14:33:45Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Ifremer, Code Lutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.models.sensitivityanalysis;

import java.util.List;

import javax.swing.DefaultComboBoxModel;

/**
 * Model pour la liste des calculateurs de sensibilite.
 *
 * @author chatellier
 * @version $Revision: 3436 $
 * 
 * Last update : $Date: 2011-07-07 16:33:45 +0200 (jeu., 07 juil. 2011) $
 * By : $Author: chatellier $
 */
public class SensitivityAnalysisComboModel extends DefaultComboBoxModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4070846632975105788L;

    /** SensitivityAnalysis names. */
    protected List<String> sensitivityAnalysisNames;

    /**
     * Empty constructor.
     */
    public SensitivityAnalysisComboModel() {
        this(null);
    }

    /**
     * Constructor with calculator list.
     * 
     * @param sensitivityAnalysisNames sensitivity analysis Names
     */
    public SensitivityAnalysisComboModel(List<String> sensitivityAnalysisNames) {
        setSensitivityCalculatorNames(sensitivityAnalysisNames);
    }

    /**
     * Get sensitivity analysis plan names.
     * 
     * @return the sensitivity analysis plan names
     */
    public List<String> getSensitivityAnalysisNames() {
        return sensitivityAnalysisNames;
    }

    /**
     * Set sensitivity analysis names.
     * 
     * @param sensitivityAnalysisNames the names to set
     */
    public void setSensitivityCalculatorNames(List<String> sensitivityAnalysisNames) {
        this.sensitivityAnalysisNames = sensitivityAnalysisNames;

        // default first selected
        /* disable default selection
        if (!sensitivityAnalysisNames.isEmpty()) {
            setSelectedItem(sensitivityAnalysisNames.get(0));
        }*/
    }

    /*
     * @see javax.swing.ListModel#getElementAt(int)
     */
    @Override
    public Object getElementAt(int index) {
        return sensitivityAnalysisNames.get(index);
    }

    /*
     * @see javax.swing.ListModel#getSize()
     */
    @Override
    public int getSize() {
        int size = 0;

        if (sensitivityAnalysisNames != null) {
            size = sensitivityAnalysisNames.size();
        }
        return size;
    }
}
