/*
 * #%L
 * IsisFish
 * 
 * $Id: StringComboModel.java 3312 2011-05-02 15:07:45Z chatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/isis-fish/tags/isis-fish-4.0.0.0/src/main/java/fr/ifremer/isisfish/ui/models/common/StringComboModel.java $
 * %%
 * Copyright (C) 2011 Ifremer, CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.models.common;

import java.util.List;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

/**
 * Model pour pour la representation d'une liste de {@link String}.
 * Utilisation dans les {@link JComboBox}.
 *
 * @author chatellier
 * @version $Revision: 3312 $
 * 
 * Last update : $Date: 2011-05-02 17:07:45 +0200 (lun., 02 mai 2011) $
 * By : $Author: chatellier $
 */
public class StringComboModel extends DefaultComboBoxModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4070846632975105788L;

    /** {@link String} list. */
    protected List<String> stringList;

    /**
     * Empty constructor.
     */
    public StringComboModel() {
        this(null);
    }

    /**
     * Constructor with export list.
     * 
     * @param stringList {@link String} list
     */
    public StringComboModel(List<String> stringList) {
        setStringList(stringList);
    }

    /**
     * Get {@link String} list.
     * 
     * @return {@link String} list
     */
    public List<String> getStringList() {
        return stringList;
    }

    /**
     * Set {@link String} list.
     * 
     * @param stringList {@link String} list to set
     */
    public void setStringList(List<String> stringList) {
        this.stringList = stringList;
        // reset selected
        setSelectedItem(null);
    }

    /*
     * @see javax.swing.ListModel#getElementAt(int)
     */
    @Override
    public Object getElementAt(int index) {
        return stringList.get(index);
    }

    /*
     * @see javax.swing.ListModel#getSize()
     */
    @Override
    public int getSize() {
        int size = 0;

        if (stringList != null) {
            size = stringList.size();
        }
        return size;
    }
}
