/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.entities.Species;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class SpeciesStructuredUI extends InputContentUI<fr.ifremer.isisfish.entities.Species> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_FIELD_SPECIES_DYNAMIC_AGE_ENABLED = "fieldSpeciesDynamicAge.enabled";
    public static final String BINDING_FIELD_SPECIES_DYNAMIC_AGE_SELECTED = "fieldSpeciesDynamicAge.selected";
    public static final String BINDING_FIELD_SPECIES_DYNAMIC_LENGTH_ENABLED = "fieldSpeciesDynamicLength.enabled";
    public static final String BINDING_FIELD_SPECIES_DYNAMIC_LENGTH_SELECTED = "fieldSpeciesDynamicLength.selected";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TQRR+rZRSUEGIFSImiMSoMVu8eClREFItqT9CJSH24rQ7bYdsZ8eZWVkuxj/BP0HvXky8eTIePHvwYvwXjPHg1fhmt91tdYUGe9g2M+/73ve9/V5ff4OMknB+l/i+JT2uWYdam2s7O/fru7ShN6hqSCa0KyH8pNKQrsGEHZ0rDRdqFQMvdOGFdbcjXE55H7pYgXGl9x2q2pRqDecGEQ2lCtXouugLT/ZYI1FJrC9/fE+/sJ+/SgP4AtVl0crCYajYyUgF0szWMI2dnpKCQ3gLZUjGW6j3hDlbd4hS90iHPoFnkK3AqCASyTQsDm854AjwvtAwtVTmwtPrLtdYvl1e1rDclBZrStqh+K2YajLVtjxmMVNoVQVtMKpQl9fQnqT2dlmIgG9Uw0idEq5hKYkB6ZlGZI+hH+Xa+2jbOPQttYeGrc0HhFMnrskuPSR1h6K82YGBhtXBnamcjAD5JqOO3e21sc9JhzXWWjTA97XZIjZzb3lau9wApyP8XAK+QnlLt03BmcHiSRWN47Z0PZzrYoJKk+OwVVCE5iScHajD4Flx8OJkpGqQkR4eo/za31ndwqswpbN/pNQQBre/8jOf3319W+pFcwx7n04s7dssjIyQrqDSvDd0GebS08wp3CWiWIOcog6uZbB28wnCqt1rFIf9Thm4ZeDWHaLaSJHJfnn/If/40zFIl2DccYldIqa+DDndljgF17F9cXM1UHR8bwyfU0abhol6PEiMzgrjDuN0gWjcF7yiN3ycxnzCNCJJ9dzHnzPVN6u9iaRQ4dw/y+OpZB7BaNgtWNfuJiau54RQ1LPdeOOSdjBlvvOiG/XF4HkxyXKWchNz/IM4uWITTRbqjNuYK7RqMFcCD+bX1aEpx8L3RwMX147OM6Kpr83t5aNymONLBzDMDcWwfICP4Riu/zdD8RAXvwEbmM6R4wYAAA==";
    private static final Log log = LogFactory.getLog(SpeciesStructuredUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Species bean;
    protected JRadioButton fieldSpeciesDynamicAge;
    protected JRadioButton fieldSpeciesDynamicLength;
    protected JAXXButtonGroup structuredGroup;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SpeciesStructuredUI $InputContentUI0 = this;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void dynamicChanged() {
            if (getBean() != null) {
                getBean().setAgeGroupType(fieldSpeciesDynamicAge.isSelected());
            }
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SpeciesStructuredUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SpeciesStructuredUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SpeciesStructuredUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SpeciesStructuredUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SpeciesStructuredUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SpeciesStructuredUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SpeciesStructuredUI() {
        $initialize();
    }

    public SpeciesStructuredUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doItemStateChanged__on__fieldSpeciesDynamicAge(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dynamicChanged();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Species getBean() {
        return bean;
    }

    public JRadioButton getFieldSpeciesDynamicAge() {
        return fieldSpeciesDynamicAge;
    }

    public JRadioButton getFieldSpeciesDynamicLength() {
        return fieldSpeciesDynamicLength;
    }

    public JAXXButtonGroup getStructuredGroup() {
        return structuredGroup;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Species bean) {
        Species oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void addChildrenToFieldSpeciesDynamicAge() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = structuredGroup; fieldSpeciesDynamicAge.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fieldSpeciesDynamicAge); }
    }

    protected void addChildrenToFieldSpeciesDynamicLength() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = structuredGroup; fieldSpeciesDynamicLength.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fieldSpeciesDynamicLength); }
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createFieldSpeciesDynamicAge() {
        $objectMap.put("fieldSpeciesDynamicAge", fieldSpeciesDynamicAge = new JRadioButton());
        
        fieldSpeciesDynamicAge.setName("fieldSpeciesDynamicAge");
        fieldSpeciesDynamicAge.setText(_("isisfish.species.age"));
        fieldSpeciesDynamicAge.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fieldSpeciesDynamicAge"));
    }

    protected void createFieldSpeciesDynamicLength() {
        $objectMap.put("fieldSpeciesDynamicLength", fieldSpeciesDynamicLength = new JRadioButton());
        
        fieldSpeciesDynamicLength.setName("fieldSpeciesDynamicLength");
        fieldSpeciesDynamicLength.setText(_("isisfish.species.length"));
    }

    protected void createStructuredGroup() {
        $objectMap.put("structuredGroup", structuredGroup = new JAXXButtonGroup());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add(fieldSpeciesDynamicAge, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(fieldSpeciesDynamicLength, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToFieldSpeciesDynamicAge();
        addChildrenToFieldSpeciesDynamicLength();
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createFieldSpeciesDynamicAge();
        createFieldSpeciesDynamicLength();
        createStructuredGroup();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SPECIES_DYNAMIC_AGE_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldSpeciesDynamicAge.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SPECIES_DYNAMIC_AGE_SELECTED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    fieldSpeciesDynamicAge.setSelected(getBean().getAgeGroupType());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SPECIES_DYNAMIC_LENGTH_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldSpeciesDynamicLength.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SPECIES_DYNAMIC_LENGTH_SELECTED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    fieldSpeciesDynamicLength.setSelected(!getBean().getAgeGroupType());
                }
            }
        });
    }

}