/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.entities.SetOfVessels;
import java.awt.LayoutManager;
import javax.swing.JTabbedPane;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class SetOfVesselsUI extends InputContentUI<fr.ifremer.isisfish.entities.SetOfVessels> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EFFORT_DESCRIPTION_UI_ACTIVE = "effortDescriptionUI.active";
    public static final String BINDING_EFFORT_DESCRIPTION_UI_BEAN = "effortDescriptionUI.bean";
    public static final String BINDING_EFFORT_PARAMETERS_UI_ACTIVE = "effortParametersUI.active";
    public static final String BINDING_EFFORT_PARAMETERS_UI_BEAN = "effortParametersUI.bean";
    public static final String BINDING_SET_OF_VESSELS_BASICS_UI_ACTIVE = "setOfVesselsBasicsUI.active";
    public static final String BINDING_SET_OF_VESSELS_BASICS_UI_BEAN = "setOfVesselsBasicsUI.bean";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUQU8TQRR+rbRYUMGiCIoJKhc12QLxYMQoihJLqhArhtiL0+4sHbKdHWdmYbkYf4I/Qe9eTLx5Mh48e/Bi/AvGePBqfLNtt11Yaw097DTvve+b77157735Dhkl4dwWCQJL+lyzBrVWbm1srFa3aE3foaommdCehOYvlYZ0BYbtyK40XKiUDLzQgheWvIbwOOVd6IUSDCm961JVp1RrOBtH1JQqlCP3QiB82WaNRCWxvvr5I/3SfvE6DRAIVDeEqUz/C9XJZKAEaWZryONN26TgEr6JMiTjm6j3qLEtuUSpB6RBn8FzGCxBVhCJZBrO959yyBHiA6FhdKbIha+XPK4xfL04q+GyIy3mSNqgeCqmHKbqls8sZgKtMtWrzmOqFHXVelGIkCqrYaBKCddwMQmMzEwzqmLgbqhn72LaJsPAUjuYsLWyRjh1OzEjqgv6iFQ1nIqFo6lKbQMygJEId6Ibd5soVkPVGub6zrGNMXz5iHaMOo4no/IyjxvW2Z6sd/dD4qT5JukakfjCmspQ6bX/4+wGx9lzM1ijInc8fOLTsaZslrDlFfsBc8YwneCYbzsknIkx4gBZnQHqdHiqAhnpo1nDRGX/zD1EV3PaJvZMmyEMvb/Hx768//ZuuT1iWbz7ZGJo14bA1hfSE1SaJsReas6Xr5lbuE/EQgVy+NK4XsL1MZUgrNxyozi877iBWwZu3SOqjhSZwa8fPo4//XwI0ssw5HrEXiYmvgg5XZdYBc+1A3FzMVR0ZOcwfkeNNg1ZjGPbWKNj122iyXSVcRtf40aARZhKKEKkpJr79Gus/HaxXYgUCpv8a3inGJknkGXcZZyG26a1SBK3y7BQ1Le9zsJIWiEpc46LVndcCr9WUqbhgjDeucA3x3wo2vy70ieHMc/2YJjsi+HqgRl6aZg6sAbD8AdcrpbjBwcAAA==";
    private static final Log log = LogFactory.getLog(SetOfVesselsUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected SetOfVessels bean;
    protected EffortDescriptionUI effortDescriptionUI;
    protected EffortDescriptionParametersUI effortParametersUI;
    protected SetOfVesselsBasicsUI setOfVesselsBasicsUI;
    protected JTabbedPane setOfVesselsTab;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SetOfVesselsUI $InputContentUI0 = this;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;
    private TabInfo $TabInfo2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
        setButtonTitle(_("isisfish.input.continueStrategies"));
        setNextPath(n_("isisfish.input.tree.strategies"));
    
        // install change listener
        // (depends on sensitivity can't be done on constructor)
        installChangeListener(setOfVesselsTab);
    }
    
    /*public void refresh() {
        getSaveVerifier().addCurrentPanel(setOfVesselsBasicsUI, effortDescriptionUI, effortParametersUI);
    }*/
    
    @Override
    public void setLayer(boolean active) {
        super.setLayer(active);
        setOfVesselsBasicsUI.setLayer(active);
        effortDescriptionUI.setLayer(active);
        effortParametersUI.setLayer(active);
    }
    
    @Override
    public void resetChangeModel() {
        setOfVesselsBasicsUI.resetChangeModel();
        effortDescriptionUI.resetChangeModel();
        effortParametersUI.resetChangeModel();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SetOfVesselsUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SetOfVesselsUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SetOfVesselsUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SetOfVesselsUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SetOfVesselsUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SetOfVesselsUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SetOfVesselsUI() {
        $initialize();
    }

    public SetOfVesselsUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public SetOfVessels getBean() {
        return bean;
    }

    public EffortDescriptionUI getEffortDescriptionUI() {
        return effortDescriptionUI;
    }

    public EffortDescriptionParametersUI getEffortParametersUI() {
        return effortParametersUI;
    }

    public SetOfVesselsBasicsUI getSetOfVesselsBasicsUI() {
        return setOfVesselsBasicsUI;
    }

    public JTabbedPane getSetOfVesselsTab() {
        return setOfVesselsTab;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(SetOfVessels bean) {
        SetOfVessels oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    protected TabInfo get$TabInfo2() {
        return $TabInfo2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(setOfVesselsTab);
    }

    protected void addChildrenToSetOfVesselsTab() {
        if (!allComponentsCreated) {
            return;
        }
        setOfVesselsTab.add(setOfVesselsBasicsUI);
        setOfVesselsTab.add(effortDescriptionUI);
        setOfVesselsTab.add(effortParametersUI);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener(setOfVesselsTab, 0));
        setOfVesselsTab.setTitleAt(0, _("isisfish.setOfVessels.title"));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener(setOfVesselsTab, 1));
        setOfVesselsTab.setTitleAt(1, _("isisfish.effortDescription.title"));
        $TabInfo2.addPropertyChangeListener(new TabInfoPropertyChangeListener(setOfVesselsTab, 2));
        setOfVesselsTab.setTitleAt(2, _("isisfish.effortDescription.parametersTitle"));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createEffortDescriptionUI() {
        $objectMap.put("effortDescriptionUI", effortDescriptionUI = new EffortDescriptionUI(this));
        
        effortDescriptionUI.setName("effortDescriptionUI");
    }

    protected void createEffortParametersUI() {
        $objectMap.put("effortParametersUI", effortParametersUI = new EffortDescriptionParametersUI(this));
        
        effortParametersUI.setName("effortParametersUI");
    }

    protected void createSetOfVesselsBasicsUI() {
        $objectMap.put("setOfVesselsBasicsUI", setOfVesselsBasicsUI = new SetOfVesselsBasicsUI(this));
        
        setOfVesselsBasicsUI.setName("setOfVesselsBasicsUI");
    }

    protected void createSetOfVesselsTab() {
        $objectMap.put("setOfVesselsTab", setOfVesselsTab = new JTabbedPane());
        
        setOfVesselsTab.setName("setOfVesselsTab");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        addChildrenToSetOfVesselsTab();
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createSetOfVesselsTab();
        createSetOfVesselsBasicsUI();
        createEffortDescriptionUI();
        createEffortParametersUI();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        
        $TabInfo0.setTitle(_("isisfish.setOfVessels.title"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        
        $TabInfo1.setTitle(_("isisfish.effortDescription.title"));
        // inline creation of $TabInfo2
        $objectMap.put("$TabInfo2", $TabInfo2 = new TabInfo());
        
        $TabInfo2.setTitle(_("isisfish.effortDescription.parametersTitle"));
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SET_OF_VESSELS_BASICS_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                setOfVesselsBasicsUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SET_OF_VESSELS_BASICS_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                setOfVesselsBasicsUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EFFORT_DESCRIPTION_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                effortDescriptionUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EFFORT_DESCRIPTION_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                effortDescriptionUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EFFORT_PARAMETERS_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                effortParametersUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EFFORT_PARAMETERS_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                effortParametersUI.setBean(getBean());
            }
        });
    }

}