/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.entities.Gear;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTabbedPane;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class GearUI extends InputContentUI<fr.ifremer.isisfish.entities.Gear> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_GEAR_TAB_UI_ACTIVE = "gearTabUI.active";
    public static final String BINDING_GEAR_TAB_UI_BEAN = "gearTabUI.bean";
    public static final String BINDING_SELECTIVITY_UI_ACTIVE = "selectivityUI.active";
    public static final String BINDING_SELECTIVITY_UI_BEAN = "selectivityUI.bean";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1TO28TQRAeGz/ihJCQCJNAIiUQkHidQZRGEGRkcGQewliKcMOeb21vdN5bdveSc4P4CfwE6GmQ6KgQBTUFDeIvIERBi5g9v8kRx8WtNfN9334zO/P2BySVhPUdEgSW9LlmbWpt3d7efmjv0Lq+Q1VdMqE9Cd1fLA7xGsw4g7jScLZWNvRcj54reG3hccpH2PkyTCvdcalqUao1rI4z6krlKoN0PhC+7KsOTEWpvv71M/7KefkmDhAIdDeFpaxNYg0rSZQhzhwNC3jTLsm5hDfRhmS8iX5nTazgEqUekDZ9Di8gXYaUIBLFNJw5fMmhRsgPhIb5jRIXvi54XCO8WrqK/WtIizUkbVM8FVMNplqWzyxmgNZdSmS1JEQokdKQsCnhGtajSKjINKMqJI1SPKeDZZqKAkvtYYHW1iPCqTvEpJtIeUJsDSfHYBiyqWPABjg3wGd6+GpJw/mJBYRAw1wYCMwq6uKEsV2mO0bk4oEilVHwuFBmA9VLvOFhK0+NPX63hF5W7CdcM4FVTEg4PUbEebSG8zgcmFgNktLHsIal2v4Rfoyp7vAu/TO8RjDM/skufv3w/X2xP7EJvPtEJHRk4XCShPQEleZtNcx1x9XXzM3dJyJfg0y3l+E2rkQYq/TSaA7vO27olqFb94hqoUQy/e3jp+yzL0cgXoRp1yNOkRh8CTK6JbELnusE4tZm6Ojo3hR+5403DSliXgV7dOyGQzRZsxl3sOk3A2zCSkQTBk7szOffi5V3m/1GxNDY8n/hw2Ykn0KKcZdxGi5vby8jl3VGKOo73nD/ojYyZs6s6E3HufB7IarScO9M9nLgm+NKaNr8yx1Sw4QvHaCwfCiF6xMU/gJv4EiL0gUAAA==";
    private static final Log log = LogFactory.getLog(GearUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Gear bean;
    protected JTabbedPane gearTab;
    protected GearTabUI gearTabUI;
    protected SelectivityUI selectivityUI;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private GearUI $InputContentUI0 = this;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
        setButtonTitle(_("isisfish.input.continueMetiers"));
        setNextPath(n_("isisfish.input.tree.metiers"));
        
        addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
    
                }
                if (evt.getNewValue() != null) {
                    //getVerifier().addCurrentPanel(gearTabUI, selectivityUI);
                }
            }
        });
        
        // install change listener
        // (depends on sensitivity can't be done on constructor)
        installChangeListener(gearTab);
    }
    
    /*public void refresh() {
        //getVerifier().addCurrentPanel(gearTabUI, selectivityUI);
    }*/
    
    @Override
    public void setLayer(boolean active) {
        super.setLayer(active);
        gearTabUI.setLayer(active);
        selectivityUI.setLayer(active);
    }
    
    @Override
    public void resetChangeModel() {
        gearTabUI.resetChangeModel();
        selectivityUI.resetChangeModel();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public GearUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public GearUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public GearUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public GearUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public GearUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public GearUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public GearUI() {
        $initialize();
    }

    public GearUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Gear getBean() {
        return bean;
    }

    public JTabbedPane getGearTab() {
        return gearTab;
    }

    public GearTabUI getGearTabUI() {
        return gearTabUI;
    }

    public SelectivityUI getSelectivityUI() {
        return selectivityUI;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Gear bean) {
        Gear oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(gearTab, BorderLayout.CENTER);
    }

    protected void addChildrenToGearTab() {
        if (!allComponentsCreated) {
            return;
        }
        gearTab.add(gearTabUI);
        gearTab.add(selectivityUI);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener(gearTab, 0));
        gearTab.setTitleAt(0, _("isisfish.gear.title"));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener(gearTab, 1));
        gearTab.setTitleAt(1, _("isisfish.selectivity.title"));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createGearTab() {
        $objectMap.put("gearTab", gearTab = new JTabbedPane());
        
        gearTab.setName("gearTab");
    }

    protected void createGearTabUI() {
        $objectMap.put("gearTabUI", gearTabUI = new GearTabUI(this));
        
        gearTabUI.setName("gearTabUI");
    }

    protected void createSelectivityUI() {
        $objectMap.put("selectivityUI", selectivityUI = new SelectivityUI(this));
        
        selectivityUI.setName("selectivityUI");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        addChildrenToGearTab();
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createGearTab();
        createGearTabUI();
        createSelectivityUI();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        
        $TabInfo0.setTitle(_("isisfish.gear.title"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        
        $TabInfo1.setTitle(_("isisfish.selectivity.title"));
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_TAB_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                gearTabUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_TAB_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                gearTabUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECTIVITY_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                selectivityUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECTIVITY_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                selectivityUI.setBean(getBean());
            }
        });
    }

}