/*
 * #%L
 * IsisFish
 * 
 * $Id: ThreadFilter.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2002 - 2010 Ifremer, Code Lutin, Benjamin Poussin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.logging;

/**
 * this class is Log4J filter to accept only incoming log events from a unique thread.
 * it retains all logEvent coming from other threads (compare with given thread name).
 * 
 * @author chemit
 */
public class ThreadFilter extends org.apache.log4j.spi.Filter {

    /** the name of the only thread to accept */
    protected String threadName;

    public ThreadFilter(String threadName) {
        this.threadName=threadName;
    }

    public int decide(org.apache.log4j.spi.LoggingEvent event) {
        // only accept event coming from a specific thread
        return event.getThreadName().equals(threadName) ? ACCEPT : DENY;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }
}
