/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.IsisFishDAOHelper.IsisFishEntityEnum;
import fr.ifremer.isisfish.types.Month;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class StrategyMonthInfoDAOAbstract<E extends StrategyMonthInfo> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)StrategyMonthInfo.class;
    }

    @Override
    public IsisFishEntityEnum getTopiaEntityEnum() {
        return IsisFishEntityEnum.StrategyMonthInfo;
    }

    public E findByMonth(Month v) throws TopiaException {
        E result = findByProperty(StrategyMonthInfo.PROPERTY_MONTH, v);
        return result;
    }

    public List<E> findAllByMonth(Month v) throws TopiaException {
        List<E> result = findAllByProperty(StrategyMonthInfo.PROPERTY_MONTH, v);
        return result;
    }

    public E findByMinInactivityDays(double v) throws TopiaException {
        E result = findByProperty(StrategyMonthInfo.PROPERTY_MIN_INACTIVITY_DAYS, v);
        return result;
    }

    public List<E> findAllByMinInactivityDays(double v) throws TopiaException {
        List<E> result = findAllByProperty(StrategyMonthInfo.PROPERTY_MIN_INACTIVITY_DAYS, v);
        return result;
    }

    public E findByNumberOfTrips(double v) throws TopiaException {
        E result = findByProperty(StrategyMonthInfo.PROPERTY_NUMBER_OF_TRIPS, v);
        return result;
    }

    public List<E> findAllByNumberOfTrips(double v) throws TopiaException {
        List<E> result = findAllByProperty(StrategyMonthInfo.PROPERTY_NUMBER_OF_TRIPS, v);
        return result;
    }

    public E findByProportionMetier(MatrixND v) throws TopiaException {
        E result = findByProperty(StrategyMonthInfo.PROPERTY_PROPORTION_METIER, v);
        return result;
    }

    public List<E> findAllByProportionMetier(MatrixND v) throws TopiaException {
        List<E> result = findAllByProperty(StrategyMonthInfo.PROPERTY_PROPORTION_METIER, v);
        return result;
    }

    public E findByTripType(TripType v) throws TopiaException {
        E result = findByProperty(StrategyMonthInfo.PROPERTY_TRIP_TYPE, v);
        return result;
    }

    public List<E> findAllByTripType(TripType v) throws TopiaException {
        List<E> result = findAllByProperty(StrategyMonthInfo.PROPERTY_TRIP_TYPE, v);
        return result;
    }

    public E findByStrategy(Strategy v) throws TopiaException {
        E result = findByProperty(StrategyMonthInfo.PROPERTY_STRATEGY, v);
        return result;
    }

    public List<E> findAllByStrategy(Strategy v) throws TopiaException {
        List<E> result = findAllByProperty(StrategyMonthInfo.PROPERTY_STRATEGY, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Strategy.class) {
            StrategyDAO dao = (StrategyDAO)
                getContext().getDAO(Strategy.class);
            tmp = dao.findAllContainsStrategyMonthInfo(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Strategy.class, entity);
        if (!list.isEmpty()) {
            result.put(Strategy.class, list);
        }

        return result;
    }

} //StrategyMonthInfoDAOAbstract<E extends StrategyMonthInfo>
