/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.Month;
import java.util.List;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.persistence.TopiaEntityContextable;

public interface Strategy extends TopiaEntityContextable {

    String PROPERTY_NAME = "name";

    String PROPERTY_PROPORTION_SET_OF_VESSELS = "proportionSetOfVessels";

    String PROPERTY_COMMENT = "comment";

    String PROPERTY_INACTIVITY_EQUATION_USED = "inactivityEquationUsed";

    String PROPERTY_INACTIVITY_EQUATION = "inactivityEquation";

    String PROPERTY_SET_OF_VESSELS = "setOfVessels";

    String PROPERTY_STRATEGY_MONTH_INFO = "strategyMonthInfo";

    void setName(String name);

    String getName();

    void setProportionSetOfVessels(double proportionSetOfVessels);

    double getProportionSetOfVessels();

    void setComment(String comment);

    String getComment();

    void setInactivityEquationUsed(boolean inactivityEquationUsed);

    boolean isInactivityEquationUsed();

    boolean getInactivityEquationUsed();

    void setInactivityEquation(Equation inactivityEquation);

    Equation getInactivityEquation();

    void setSetOfVessels(SetOfVessels setOfVessels);

    SetOfVessels getSetOfVessels();

    void addStrategyMonthInfo(StrategyMonthInfo strategyMonthInfo);

    void addAllStrategyMonthInfo(List<StrategyMonthInfo> strategyMonthInfo);

    void setStrategyMonthInfo(List<StrategyMonthInfo> strategyMonthInfo);

    void removeStrategyMonthInfo(StrategyMonthInfo strategyMonthInfo);

    void clearStrategyMonthInfo();

    List<StrategyMonthInfo> getStrategyMonthInfo();

    StrategyMonthInfo getStrategyMonthInfoByTopiaId(String topiaId);

    int sizeStrategyMonthInfo();

    boolean isStrategyMonthInfoEmpty();

    FisheryRegion getFisheryRegion();

    StrategyMonthInfo getStrategyMonthInfo(Month month);

    double getInactivityDays(Month month);

    MatrixND getProportionMetier();

    void setProportionMetier(MatrixND strategyProportionMetier);

} //Strategy
