/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.IsisFishDAOHelper.IsisFishEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class MetierSeasonInfoDAOAbstract<E extends MetierSeasonInfo> extends SeasonDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)MetierSeasonInfo.class;
    }

    @Override
    public IsisFishEntityEnum getTopiaEntityEnum() {
        return IsisFishEntityEnum.MetierSeasonInfo;
    }

    public E findBySeasonZoneComment(String v) throws TopiaException {
        E result = findByProperty(MetierSeasonInfo.PROPERTY_SEASON_ZONE_COMMENT, v);
        return result;
    }

    public List<E> findAllBySeasonZoneComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(MetierSeasonInfo.PROPERTY_SEASON_ZONE_COMMENT, v);
        return result;
    }

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty(MetierSeasonInfo.PROPERTY_COMMENT, v);
        return result;
    }

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(MetierSeasonInfo.PROPERTY_COMMENT, v);
        return result;
    }

    public E findByMetier(Metier v) throws TopiaException {
        E result = findByProperty(MetierSeasonInfo.PROPERTY_METIER, v);
        return result;
    }

    public List<E> findAllByMetier(Metier v) throws TopiaException {
        List<E> result = findAllByProperty(MetierSeasonInfo.PROPERTY_METIER, v);
        return result;
    }

    public E findContainsZone(Zone v) throws TopiaException {
        E result = findContains(MetierSeasonInfo.PROPERTY_ZONE, v);
        return result;
    }

    public List<E> findAllContainsZone(Zone v) throws TopiaException {
        List<E> result = findAllContains(MetierSeasonInfo.PROPERTY_ZONE, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Metier.class) {
            MetierDAO dao = (MetierDAO)
                getContext().getDAO(Metier.class);
            tmp = dao.findAllContainsMetierSeasonInfo(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Metier.class, entity);
        if (!list.isEmpty()) {
            result.put(Metier.class, list);
        }

        return result;
    }

} //MetierSeasonInfoDAOAbstract<E extends MetierSeasonInfo>
