/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.Month;
import java.util.List;
import org.nuiton.topia.persistence.TopiaEntityContextable;

public interface Metier extends TopiaEntityContextable {

    String PROPERTY_NAME = "name";

    String PROPERTY_GEAR_PARAMETER_VALUE = "gearParameterValue";

    String PROPERTY_COMMENT = "comment";

    String PROPERTY_CAPTURABLE_SPECIES_COMMENT = "capturableSpeciesComment";

    String PROPERTY_GEAR = "gear";

    String PROPERTY_SET_OF_VESSELS_EFFORT_DESCRIPTION = "setOfVesselsEffortDescription";

    String PROPERTY_METIER_SEASON_INFO = "metierSeasonInfo";

    void setName(String name);

    String getName();

    void setGearParameterValue(String gearParameterValue);

    String getGearParameterValue();

    void setComment(String comment);

    String getComment();

    void setCapturableSpeciesComment(String capturableSpeciesComment);

    String getCapturableSpeciesComment();

    void setGear(Gear gear);

    Gear getGear();

    void addMetierSeasonInfo(MetierSeasonInfo metierSeasonInfo);

    void addAllMetierSeasonInfo(List<MetierSeasonInfo> metierSeasonInfo);

    void setMetierSeasonInfo(List<MetierSeasonInfo> metierSeasonInfo);

    void removeMetierSeasonInfo(MetierSeasonInfo metierSeasonInfo);

    void clearMetierSeasonInfo();

    List<MetierSeasonInfo> getMetierSeasonInfo();

    MetierSeasonInfo getMetierSeasonInfoByTopiaId(String topiaId);

    int sizeMetierSeasonInfo();

    boolean isMetierSeasonInfoEmpty();

    FisheryRegion getFisheryRegion();

    MetierSeasonInfo getMetierSeasonInfo(Month month);

    double getGearParameterValueAsDouble();

} //Metier
