/*
 * Decompiled with CFR 0.152.
 */
package sensitivityanalysis;

import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.sensitivity.AbstractSensitivityAnalysis;
import fr.ifremer.isisfish.simulator.sensitivity.DesignPlan;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.Scenario;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityException;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityScenarios;
import fr.ifremer.isisfish.util.Doc;
import java.io.File;
import java.util.List;
import org.nuiton.j2r.REngine;
import org.nuiton.j2r.RException;
import org.nuiton.j2r.types.RDataFrame;

public class Fast
extends AbstractSensitivityAnalysis {
    @Doc(value="an integer giving the sample size, i.e. the length of the discretization of the s-space (see Cukier et al.). (default=20)")
    public int param_n = 20;
    @Doc(value="an integer specifying the interference parameter, i.e. the number of harmonics to sum in the Fourier series decomposition (see Cukier et al.). (default=6)")
    public int param_M = 6;
    @Doc(value="True to be able to modify the code sent to R")
    public boolean param_modifR = false;

    public boolean canManageCardinality() {
        return true;
    }

    public SensitivityScenarios compute(DesignPlan plan, File outputDirectory) throws SensitivityException {
        this.setIsisFactorsR(plan, outputDirectory);
        int factorNumber = plan.getFactors().size();
        List factors = plan.getFactors();
        SensitivityScenarios thisExperiment = new SensitivityScenarios();
        List thisExperimentScenarios = thisExperiment.getScenarios();
        this.checkAllFactorContinuous(factors);
        String rInstruction = "isis.methodAnalyse<-fast99(model=NULL,factors=%s, n=%s, M=%s, q = \"qunif\", q.arg=list(min=0,max=1))";
        String rCall = String.format(rInstruction, factors.size(), this.param_n, this.param_M);
        if (this.param_modifR) {
            rCall = this.editRInstruction(rCall);
        }
        try {
            REngine engine = this.openEngine(outputDirectory);
            engine.voidEval("library(sensitivity)");
            engine.voidEval(rCall);
            rInstruction = "factornames<-c(";
            int i = 0;
            while (i < factorNumber) {
                String factorName = ((Factor)factors.get(i)).getName();
                rInstruction = i != factorNumber - 1 ? String.valueOf(rInstruction) + "\"" + factorName + "\"," : String.valueOf(rInstruction) + "\"" + factorName + "\"";
                ++i;
            }
            rInstruction = String.valueOf(rInstruction) + ")";
            engine.voidEval(rInstruction);
            RDataFrame dataFrame = (RDataFrame)engine.eval("isis.methodAnalyse$X");
            dataFrame.setVariable("isis.methodAnalyse$X");
            int nbExperiments = (Integer)engine.eval("dim(isis.methodAnalyse$X)[1]");
            engine.voidEval(this.getIsisFactorDistribution(factors));
            engine.voidEval("call<-isis.methodAnalyse$call");
            engine.voidEval("isis.methodExp<-list(\"isis.factors\"=isis.factors,\"isis.factor.distribution\"=isis.factor.distribution,\"call\"=call)");
            engine.voidEval("attr(isis.methodExp,\"nomModel\")<-\"isis-fish-externe-R\"");
            engine.voidEval("isis.simule<-data.frame(isis.methodAnalyse$X)");
            engine.voidEval("attr(isis.simule,\"nomModel\")<-\"isis-fish-externe-R\"");
            engine.voidEval("names(isis.simule)<-isis.factors[[1]]");
            int j = 0;
            while (j < nbExperiments) {
                Scenario experimentScenario = new Scenario();
                int i2 = 0;
                while (i2 < factorNumber) {
                    Factor factor = (Factor)plan.getFactors().get(i2);
                    factor.setValueForIdentifier(dataFrame.get(i2, j));
                    experimentScenario.addFactor(factor);
                    ++i2;
                }
                thisExperimentScenarios.add(experimentScenario);
                thisExperiment.setScenarios(thisExperimentScenarios);
                ++j;
            }
            this.closeEngine(engine, outputDirectory);
        }
        catch (RException eee) {
            throw new SensitivityException("Can't generate scenarios", (Throwable)eee);
        }
        return thisExperiment;
    }

    public void analyzeResult(List<SimulationStorage> simulationStorages, File outputDirectory) throws SensitivityException {
        String simulationName = outputDirectory.getName().replaceAll("-", "");
        try {
            REngine engine = this.openEngine(outputDirectory);
            engine.setwd(outputDirectory);
            engine.voidEval("library(sensitivity)");
            SimulationParameter param = simulationStorages.get(0).getParameter();
            int sensitivityNumber = param.getSensitivityExport().size();
            int k = 0;
            while (k < sensitivityNumber) {
                SensitivityExport sensitivityExport = (SensitivityExport)param.getSensitivityExport().get(k);
                String rInstruction = this.createImportInstruction(sensitivityExport, simulationStorages);
                engine.voidEval(rInstruction);
                engine.voidEval("isis.simule<-data.frame(isis.simule," + sensitivityExport.getExportFilename() + ")");
                ++k;
            }
            engine.voidEval("attr(isis.simule,\"nomModel\")<-\"isis-fish-externe-R\"");
            engine.voidEval("attr(isis.simule,\"call\")<-isis.methodExp$call");
            k = 0;
            while (k < sensitivityNumber) {
                String name = ((SensitivityExport)param.getSensitivityExport().get(k)).getExportFilename();
                engine.voidEval("tell(isis.methodAnalyse,y=" + name + ")");
                engine.voidEval("names(isis.methodAnalyse$V)<-isis.factor.distribution$NomFacteur");
                engine.voidEval("names(isis.methodAnalyse$X)<-isis.factor.distribution$NomFacteur");
                engine.voidEval("names(isis.methodAnalyse$D1)<-isis.factor.distribution$NomFacteur");
                engine.voidEval("names(isis.methodAnalyse$Dt)<-isis.factor.distribution$NomFacteur");
                String exportMethodAnalyse = String.format("%s.isis.methodAnalyse", String.valueOf(simulationName) + "." + name);
                engine.voidEval(String.valueOf(exportMethodAnalyse) + "<-list(" + "\"isis.factors\"=isis.factors," + "\"isis.factor.distribution\"=isis.factor.distribution," + "\"isis.simule\"=isis.simule," + "call_method=\"tell(isis.methodAnalyse,y=" + name + ")" + "\"," + "\"analysis_result\"=isis.methodAnalyse)");
                engine.voidEval("attr(" + exportMethodAnalyse + ",\"nomModel\")<-" + "\"isis-fish-externe-R\")");
                engine.voidEval("dfresults<-data.frame(isis.methodAnalyse$X,isis.methodAnalyse$y)");
                engine.setwd(outputDirectory);
                engine.voidEval("write.csv(isis.methodAnalyse$V,\"" + name + "_V.csv\")");
                engine.voidEval("write.csv(isis.methodAnalyse$D1,\"" + name + "_D1.csv\")");
                engine.voidEval("write.csv(isis.methodAnalyse$Dt,\"" + name + "_Dt.csv\")");
                engine.voidEval("resultsnames<-c(isis.factor.distribution$NomFacteur,\"Result\")");
                engine.voidEval("names(dfresults)<-isis.factor.distribution$NomFacteur");
                engine.voidEval("write.csv(dfresults,\"" + name + "_Results.csv\")");
                ++k;
            }
            this.closeEngine(engine, outputDirectory);
        }
        catch (Exception e) {
            throw new SensitivityException("Can't evaluate results", (Throwable)e);
        }
    }

    public String getDescription() {
        return "Implementation of FAST method using R (needs the sensitivity package to work)";
    }
}

