/*
 * Decompiled with CFR 0.152.
 */
package rules;

import fr.ifremer.isisfish.datastore.ResultStorage;
import fr.ifremer.isisfish.entities.EffortDescription;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.StrategyMonthInfo;
import fr.ifremer.isisfish.entities.TargetSpecies;
import fr.ifremer.isisfish.rule.AbstractRule;
import fr.ifremer.isisfish.simulator.MetierMonitor;
import fr.ifremer.isisfish.simulator.PopulationMonitor;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.util.Doc;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;
import scripts.ResultName;
import scripts.RuleUtil;
import scripts.SiMatrix;

public class TACpoids
extends AbstractRule {
    private static Log log = LogFactory.getLog(TACpoids.class);
    @Doc(value="Affected species")
    public Species param_species = null;
    @Doc(value="Debin date")
    public TimeStep param_beginStep = new TimeStep(0);
    @Doc(value="End date")
    public TimeStep param_endStep = new TimeStep(90);
    @Doc(value="Proportion de survie")
    public double param_propSurvie = 0.0;
    @Doc(value="Proportionnal TAC")
    public double param_propTac = 0.0;
    @Doc(value="TAC in tons")
    public double param_tacInTons = 900.0;
    protected boolean affectation = false;
    protected String[] necessaryResult = new String[0];

    public String[] getNecessaryResult() {
        return this.necessaryResult;
    }

    public String getDescription() {
        return "TAC weight in tons.\nIf you want survival discard use propSurvie other than 0.\nIf you wish TAC computed as a proportion of the biomass use propTac other than 0.";
    }

    public void init(SimulationContext context) throws Exception {
    }

    public boolean condition(SimulationContext context, TimeStep step, Metier metier) throws Exception {
        log.info((Object)"test si TAC atteint");
        this.param_species = (Species)context.getDB().findByTopiaId(this.param_species.getTopiaId());
        if (this.param_propTac > 0.0 && step.getMonth().equals((Object)Month.JANUARY)) {
            PopulationMonitor popMon = context.getPopulationMonitor();
            this.param_tacInTons = popMon.getBiomass(this.param_species) * this.param_propTac;
        }
        boolean result = false;
        if (step.before(this.param_beginStep)) {
            result = false;
        } else if (step.after(this.param_endStep)) {
            result = false;
        } else {
            TargetSpecies ts = metier.getMetierSeasonInfo(step.getMonth()).getSpeciesTargetSpecies(this.param_species);
            if (ts != null) {
                double catchTons = RuleUtil.getTotalCatchTons(context, this.param_species, step);
                log.info((Object)("[TAC] catchTons = " + catchTons + " >= param_tacInTons:" + this.param_tacInTons));
                if (catchTons >= this.param_tacInTons) {
                    result = true;
                }
            }
        }
        return result;
    }

    public void preAction(SimulationContext context, TimeStep step, Metier metier) throws Exception {
        this.affectation = false;
        log.info((Object)("[TAC] preAction for: " + metier));
        log.info((Object)(" TAC atteint [TAC] preAction for: " + metier));
        TargetSpecies ts = metier.getMetierSeasonInfo(step.getMonth()).getSpeciesTargetSpecies(this.param_species);
        if (ts != null && ts.getPrimaryCatch()) {
            context.getMetierMonitor().addforbiddenMetier(metier);
            SiMatrix siMatrix = SiMatrix.getSiMatrix(context);
            HashSet<Strategy> strs = new HashSet<Strategy>();
            for (Strategy str : siMatrix.getStrategies(step)) {
                double prop = str.getStrategyMonthInfo(step.getMonth()).getProportionMetier(metier);
                if (prop == 0.0) continue;
                strs.add(str);
            }
            for (Strategy str : strs) {
                StrategyMonthInfo smi = str.getStrategyMonthInfo(step.getMonth());
                HashSet<Metier> possibleMetierCase1 = new HashSet<Metier>();
                HashSet<Metier> possibleMetierCase2 = new HashSet<Metier>();
                HashSet<Metier> possibleMetierCase3 = new HashSet<Metier>();
                for (EffortDescription effort : str.getSetOfVessels().getPossibleMetiers()) {
                    Metier newMetier = effort.getPossibleMetiers();
                    if (metier.getName().equalsIgnoreCase("nonActiviy") || metier.getName().equalsIgnoreCase("nonActivie") || metier.getName().equalsIgnoreCase("non Activite") || context.getMetierMonitor().getForbiddenMetier().contains(newMetier)) continue;
                    possibleMetierCase3.add(newMetier);
                    if (smi.getProportionMetier(newMetier) == 0.0) continue;
                    possibleMetierCase2.add(newMetier);
                    if (!metier.getGear().equals(newMetier.getGear())) continue;
                    possibleMetierCase1.add(newMetier);
                }
                HashSet<Metier> possibleMetier = null;
                if (possibleMetierCase1.size() != 0) {
                    log.info((Object)"[TAC] Use case 1");
                    possibleMetier = possibleMetierCase1;
                } else if (possibleMetierCase2.size() != 0) {
                    log.info((Object)"[TAC] Use case 2");
                    possibleMetier = possibleMetierCase2;
                } else if (possibleMetierCase3.size() != 0) {
                    log.info((Object)"[TAC] Use case 3");
                    possibleMetier = possibleMetierCase3;
                }
                if (possibleMetier != null) {
                    double somme = 0.0;
                    for (Metier met : possibleMetier) {
                        somme += smi.getProportionMetier(met);
                    }
                    for (Metier met : possibleMetier) {
                        double newProportion = smi.getProportionMetier(met) + smi.getProportionMetier(metier) * smi.getProportionMetier(met) / somme;
                        smi.setProportionMetier(met, newProportion);
                    }
                    smi.setProportionMetier(metier, 0.0);
                    log.info((Object)"[TAC] il y a des metiers possibles");
                    continue;
                }
                log.info((Object)"[TAC] Use no activity");
                MetierMonitor metierMon = context.getMetierMonitor();
                MatrixND mat = metierMon.getOrCreateNoActivity(step, ResultName.MATRIX_NO_ACTIVITY, siMatrix.getStrategies(step), siMatrix.getMetiers(step));
                mat.setValue((Object)str, (Object)metier, smi.getProportionMetier(metier));
                smi.getProportionMetier().setValue((Object)metier, 0.0);
            }
        }
    }

    public void postAction(SimulationContext context, TimeStep step, Metier metier) throws Exception {
        ResultStorage resultmanager = context.getSimulationStorage().getResultStorage();
        log.info((Object)("[TAC] postAction for: " + metier));
        TargetSpecies ts = metier.getMetierSeasonInfo(step.getMonth()).getSpeciesTargetSpecies(this.param_species);
        if (ts != null && !this.affectation) {
            PopulationMonitor popMon = context.getPopulationMonitor();
            log.info((Object)("popMon biomass" + popMon.getBiomass(this.param_species)));
            for (Population pop : this.param_species.getPopulation()) {
                if (!pop.getName().equals("Population_new")) {
                    log.info((Object)("pop : " + pop.getName()));
                    MatrixND discard = popMon.getDiscard(step, pop);
                    log.info((Object)("discard : " + discard));
                    if (discard != null) {
                        discard.mults(0.0);
                    }
                    log.info((Object)("catch = " + popMon.getCatch(pop)));
                    discard = popMon.getCatch(pop).copy();
                    discard.setName(ResultName.MATRIX_DISCARDS_PER_STR_MET_PER_ZONE_POP);
                    popMon.addDiscard(step, pop, discard);
                    log.info((Object)("[TAC] add discard for " + pop + ": " + discard));
                    resultmanager.addResult(step, pop, discard);
                    if (this.param_propSurvie > 0.0) {
                        MatrixND eff = popMon.getN(pop);
                        MatrixIterator i = discard.iterator();
                        while (i.next()) {
                            Object[] coord = i.getSemanticsCoordinates();
                            eff.setValue(coord[2], coord[3], eff.getValue(coord[2], coord[3]) + i.getValue() * this.param_propSurvie);
                        }
                    }
                }
                this.affectation = true;
            }
        }
    }
}

