/*
 * Decompiled with CFR 0.152.
 */
package rules;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.EffortDescription;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.MetierSeasonInfo;
import fr.ifremer.isisfish.entities.MetierSeasonInfoDAO;
import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.StrategyMonthInfo;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.entities.ZoneDAO;
import fr.ifremer.isisfish.rule.AbstractRule;
import fr.ifremer.isisfish.simulator.MetierMonitor;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.util.Doc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;
import scripts.ResultName;
import scripts.SiMatrix;

public class CantonnementPreSimu
extends AbstractRule {
    private static Log log = LogFactory.getLog(CantonnementPreSimu.class);
    @Doc(value="Zone de fermature")
    public Zone param_zone = null;
    @Doc(value="Engin concern\u00e9s")
    public Gear param_gear = null;
    @Doc(value="Begin month")
    public Month param_beginMonth = Month.JANUARY;
    @Doc(value="End month")
    public Month param_endMonth = Month.DECEMBER;
    protected Map<Month, MatrixND> tableNonActivite = new HashMap<Month, MatrixND>();
    protected boolean affectNonActivite = false;
    protected String[] necessaryResult = new String[]{ResultName.MATRIX_NO_ACTIVITY};

    public String[] getNecessaryResult() {
        return this.necessaryResult;
    }

    public String getDescription() throws Exception {
        return "Cantonnement: can be used to Cantonnement with gear if you put gear in parameter";
    }

    private void reportNonActivite(SimulationContext context, List<Strategy> listestrategies, List<Metier> metiers, Metier metier, List<Month> chomageMonth) {
        for (Strategy strategy : listestrategies) {
            SetOfVessels SetOfBateau = strategy.getSetOfVessels();
            EffortDescription effort = SetOfBateau.getPossibleMetiers(metier);
            if (effort == null) continue;
            for (Month month : chomageMonth) {
                StrategyMonthInfo InfoMois = strategy.getStrategyMonthInfo(month);
                log.info((Object)"debut reportNonActivite");
                MatrixND matNonActiviteMois = this.tableNonActivite.get(month);
                if (matNonActiviteMois == null) {
                    matNonActiviteMois = MatrixFactory.getInstance().create(ResultName.MATRIX_NO_ACTIVITY, new List[]{listestrategies, metiers}, new String[]{"Strategies", "Metiers"});
                    this.tableNonActivite.put(month, matNonActiviteMois);
                }
                matNonActiviteMois.setValue((Object)strategy, (Object)metier, InfoMois.getProportionMetier(metier));
                log.info((Object)"fin reportNonActivite");
                InfoMois.setProportionMetier(metier, 0.0);
                MetierMonitor metierMon = context.getMetierMonitor();
                metierMon.isLimited(metier, month);
                metierMon.addforbiddenMetier(metier, month);
            }
        }
    }

    public void init(SimulationContext context) throws Exception {
        SiMatrix siMatrix = SiMatrix.getSiMatrix(context);
        ZoneDAO zoneDao = IsisFishDAOHelper.getZoneDAO((TopiaContext)context.getDB());
        MetierSeasonInfoDAO metierSeasonInfoDao = IsisFishDAOHelper.getMetierSeasonInfoDAO((TopiaContext)context.getDB());
        List SaisonFermee = Month.getMonths((Month)this.param_beginMonth, (Month)this.param_endMonth);
        List maillefermee = this.param_zone.getCell();
        FisheryRegion region = RegionStorage.getFisheryRegion((TopiaContext)context.getDB());
        List listestrategies = region.getStrategy();
        List metiers = region.getMetier();
        for (Metier metier : metiers) {
            log.info((Object)("metier examin\u00e9 " + metier.getName()));
            if (this.param_gear != null && !metier.getGear().equals(this.param_gear)) {
                log.info((Object)"l engin du m\u00e9tier n est pas concern\u00e9");
                continue;
            }
            log.info((Object)"l engin du m\u00e9tier est bien concern\u00e9");
            List saisons = metier.getMetierSeasonInfo();
            for (MetierSeasonInfo saisonmetier : saisons) {
                MetierSeasonInfo NouvelInfoSaison;
                ArrayList<Month> chomageMonth;
                boolean ToutFerme;
                int inter = siMatrix.nbCellInter(saisonmetier.getZone(), this.param_zone);
                if (inter == 0) continue;
                List<Cell> MailleMetier = siMatrix.getCells(saisonmetier.getZone());
                ArrayList<Cell> newCellMetier = new ArrayList<Cell>(MailleMetier);
                newCellMetier.removeAll(maillefermee);
                List saison = saisonmetier.getMonths();
                if (!saison.containsAll(SaisonFermee)) continue;
                log.info((Object)("il y a bien intersection entre la zone m\u00e9tier et le cantonnement pour la saison " + saison.toString()));
                boolean DebInclus = saison.contains(this.param_beginMonth);
                boolean FinInclus = saison.contains(this.param_endMonth);
                Zone secteurResult = (Zone)zoneDao.create(new Object[0]);
                secteurResult.setName("MetaCantonnement-" + metier.getName() + "-" + saison.toString());
                secteurResult.setComment("Secteur cr\u00e9\u00e9 durant la simulation.");
                secteurResult.addAllCell(newCellMetier);
                if (newCellMetier.size() != 0) {
                    ToutFerme = false;
                } else {
                    log.info((Object)"Toute la zone metier est ferme");
                    ToutFerme = true;
                }
                if (SaisonFermee.containsAll(saison)) {
                    log.info((Object)"toute la saison metier est incluse dans la saison de fermeture");
                    if (ToutFerme) {
                        log.info((Object)"toute la zone est ferm\u00e9e, le metier passe donc \u00e0 ch\u00f4mage pour cette saison");
                        this.reportNonActivite(context, listestrategies, metiers, metier, saison);
                        continue;
                    }
                    log.info((Object)("tout n'est pas ferm\u00e9e, le secteur de p\u00eache devient " + secteurResult));
                    for (Month month : SaisonFermee) {
                        metier.getMetierSeasonInfo(month).clearZone();
                        metier.getMetierSeasonInfo(month).addZone(secteurResult);
                    }
                    continue;
                }
                if (DebInclus && (!FinInclus || this.param_endMonth.equals(saison.get(saison.size() - 1)))) {
                    log.info((Object)("il y a intersection de la saison de fermeture avec la saison m\u00e9tier de " + this.param_beginMonth + " \u00e0 " + saison.get(saison.size() - 1)));
                    if (ToutFerme) {
                        log.info((Object)"toute la zone m\u00e9tier est ferm\u00e9e");
                        chomageMonth = new ArrayList<Month>(SaisonFermee);
                        chomageMonth.retainAll(saison);
                        log.info((Object)("de " + chomageMonth.get(0) + " a " + chomageMonth.get(chomageMonth.size() - 1) + ", le metier est donc mis au chomage"));
                        this.reportNonActivite(context, listestrategies, metiers, metier, chomageMonth);
                        continue;
                    }
                    saisonmetier.setLastMonth(this.param_beginMonth.previous());
                    NouvelInfoSaison = (MetierSeasonInfo)metierSeasonInfoDao.create(new Object[0]);
                    NouvelInfoSaison.setMetier(metier);
                    NouvelInfoSaison.setFirstMonth(this.param_beginMonth);
                    NouvelInfoSaison.setLastMonth((Month)saison.get(saison.size() - 1));
                    NouvelInfoSaison.addZone(secteurResult);
                    NouvelInfoSaison.setComment("saison cr\u00e9e pendant la simulation");
                    metier.addMetierSeasonInfo(NouvelInfoSaison);
                    log.info((Object)("de " + saison.get(0) + " \u00e0 " + this.param_beginMonth.previous() + " le metier peche en " + saisonmetier.getZone()));
                    log.info((Object)("de " + this.param_beginMonth + " \u00e0 " + saison.get(saison.size() - 1) + " le metier peche en " + secteurResult));
                    continue;
                }
                if ((!DebInclus || this.param_beginMonth.equals(saison.get(0))) && FinInclus) {
                    log.info((Object)("il y a intersection de la saison de fermeture avec la saison m\u00e9tier de " + this.param_beginMonth + " \u00e0 " + saison.get(saison.size() - 1)));
                    if (ToutFerme) {
                        log.info((Object)"toute la zone est fermee");
                        chomageMonth = new ArrayList(SaisonFermee);
                        chomageMonth.retainAll(saison);
                        this.reportNonActivite(context, listestrategies, metiers, metier, chomageMonth);
                        continue;
                    }
                    saisonmetier.setFirstMonth(this.param_endMonth.next());
                    NouvelInfoSaison = (MetierSeasonInfo)metierSeasonInfoDao.create(new Object[0]);
                    NouvelInfoSaison.setMetier(metier);
                    NouvelInfoSaison.setFirstMonth((Month)saison.get(0));
                    NouvelInfoSaison.setLastMonth(this.param_endMonth);
                    NouvelInfoSaison.addZone(secteurResult);
                    NouvelInfoSaison.setComment("saison cr\u00e9e pendant la simulation");
                    metier.addMetierSeasonInfo(NouvelInfoSaison);
                    log.info((Object)("de " + saison.get(0) + " \u00e0 " + this.param_endMonth + " le metier peche en " + secteurResult));
                    log.info((Object)("de " + this.param_endMonth.next() + " \u00e0 " + saison.get(saison.size() - 1) + " le metier peche en " + saisonmetier.getZone()));
                    continue;
                }
                if (ToutFerme) {
                    log.info((Object)"toute la zone m\u00e9tier est ferm\u00e9e");
                    this.reportNonActivite(context, listestrategies, metiers, metier, SaisonFermee);
                    continue;
                }
                saisonmetier.setFirstMonth(this.param_beginMonth.previous());
                NouvelInfoSaison = (MetierSeasonInfo)metierSeasonInfoDao.create(new Object[0]);
                NouvelInfoSaison.setMetier(metier);
                NouvelInfoSaison.setFirstMonth(this.param_beginMonth);
                NouvelInfoSaison.setLastMonth(this.param_endMonth);
                NouvelInfoSaison.addZone(secteurResult);
                NouvelInfoSaison.setComment("saison cr\u00e9e pendant la simulation");
                metier.addMetierSeasonInfo(NouvelInfoSaison);
                MetierSeasonInfo NouvelInfoSaison2 = (MetierSeasonInfo)metierSeasonInfoDao.create(new Object[0]);
                NouvelInfoSaison2.setMetier(metier);
                NouvelInfoSaison2.setFirstMonth(this.param_endMonth.next());
                NouvelInfoSaison2.setLastMonth((Month)saison.get(saison.size() - 1));
                NouvelInfoSaison2.setZone(saisonmetier.getZone());
                NouvelInfoSaison2.setComment("saison cr\u00e9e pendant la simulation");
                metier.addMetierSeasonInfo(NouvelInfoSaison2);
                log.info((Object)("de " + saison.get(0) + " \u00e0 " + this.param_beginMonth.previous() + " le metier peche en " + saisonmetier.getZone()));
                log.info((Object)("de " + this.param_beginMonth + " \u00e0 " + this.param_endMonth + " le metier peche en " + secteurResult));
                log.info((Object)("de " + this.param_endMonth.next() + " \u00e0 " + saison.get(saison.size() - 1) + " le metier peche en " + saisonmetier.getZone()));
            }
        }
    }

    public boolean condition(SimulationContext context, TimeStep step, Metier metier) throws Exception {
        boolean result = false;
        MatrixND mat = this.tableNonActivite.get(step.getMonth());
        if (mat != null && !this.affectNonActivite) {
            result = true;
        }
        return result;
    }

    public void preAction(SimulationContext context, TimeStep step, Metier metier) throws Exception {
        this.affectNonActivite = true;
        MatrixND mat = this.tableNonActivite.get(step.getMonth());
        MetierMonitor metierMon = context.getMetierMonitor();
        MatrixND noActivity = metierMon.getNoActivity(step);
        if (noActivity == null) {
            metierMon.setNoActivity(step, mat.copy());
        } else {
            noActivity.add(mat);
        }
    }

    public void postAction(SimulationContext context, TimeStep step, Metier metier) throws Exception {
        this.affectNonActivite = false;
    }
}

