/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.importData;

import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import fr.ifremer.echobase.entities.ImportType;
import fr.ifremer.echobase.entities.data.Mooring;
import fr.ifremer.echobase.services.service.importdata.configurations.MooringResultsImportConfiguration;
import fr.ifremer.echobase.ui.actions.importData.AbstractConfigureImport;
import java.io.File;
import java.util.Map;

public class ConfigureMooringResultsImport
extends AbstractConfigureImport<MooringResultsImportConfiguration> {
    private static final long serialVersionUID = 1L;
    protected Map<String, String> moorings;
    protected Map<String, String> importTypes;
    protected String resultLabel;

    public ConfigureMooringResultsImport() {
        super(MooringResultsImportConfiguration.class);
    }

    protected MooringResultsImportConfiguration createModel() {
        return new MooringResultsImportConfiguration(this.getLocale());
    }

    protected void prepareInputAction(MooringResultsImportConfiguration model) {
        this.moorings = this.userDbPersistenceService.loadSortAndDecorate(Mooring.class);
        this.importTypes = this.decoratorService.decorateEnums((Enum[])ImportType.getMooringResultImportType());
        if (model.getImportType() == null) {
            model.setImportType(ImportType.RESULT_MOORING);
        }
    }

    @InputConfig(methodName="input")
    public String modeMooring() throws Exception {
        return this.execute();
    }

    @InputConfig(methodName="input")
    public String modeMooringEsdu() throws Exception {
        return this.execute();
    }

    public Map<String, String> getMoorings() {
        return this.moorings;
    }

    public Map<String, String> getImportTypes() {
        return this.importTypes;
    }

    public String getResultLabel() {
        return this.resultLabel;
    }

    public void setResultLabel(String resultLabel) {
        this.resultLabel = resultLabel;
    }

    public void setEchotypeFile(File file) {
        ((MooringResultsImportConfiguration)this.getModel()).getEchotypeFile().setFile(file);
    }

    public void setEchotypeFileContentType(String contentType) {
        ((MooringResultsImportConfiguration)this.getModel()).getEchotypeFile().setContentType(contentType);
    }

    public void setEchotypeFileFileName(String fileName) {
        ((MooringResultsImportConfiguration)this.getModel()).getEchotypeFile().setFileName(fileName);
    }

    public void setEsduByEchotypeFile(File file) {
        ((MooringResultsImportConfiguration)this.getModel()).getEsduByEchotypeFile().setFile(file);
    }

    public void setEsduByEchotypeFileContentType(String contentType) {
        ((MooringResultsImportConfiguration)this.getModel()).getEsduByEchotypeFile().setContentType(contentType);
    }

    public void setEsduByEchotypeFileFileName(String fileName) {
        ((MooringResultsImportConfiguration)this.getModel()).getEsduByEchotypeFile().setFileName(fileName);
    }

    public void setEsduByEchotypeAndSpeciesCategoryFile(File file) {
        ((MooringResultsImportConfiguration)this.getModel()).getEsduByEchotypeAndSpeciesCategoryFile().setFile(file);
    }

    public void setEsduByEchotypeAndSpeciesCategoryFileContentType(String contentType) {
        ((MooringResultsImportConfiguration)this.getModel()).getEsduByEchotypeAndSpeciesCategoryFile().setContentType(contentType);
    }

    public void setEsduByEchotypeAndSpeciesCategoryFileFileName(String fileName) {
        ((MooringResultsImportConfiguration)this.getModel()).getEsduByEchotypeAndSpeciesCategoryFile().setFileName(fileName);
    }
}

