/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.importData;

import com.google.common.collect.Maps;
import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.entities.data.VoyageImpl;
import fr.ifremer.echobase.entities.references.AreaOfOperation;
import fr.ifremer.echobase.entities.references.Mission;
import fr.ifremer.echobase.services.VoyageService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import fr.ifremer.echobase.ui.actions.importData.ImportMode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigureVoyage
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ConfigureVoyage.class);
    protected Map<String, String> voyages;
    protected Map<String, String> missions;
    protected Map<String, String> areaOfOperations;
    protected Map<String, String> importModes;
    protected ImportMode importMode;
    protected Voyage voyage;
    protected String missionId;
    protected String areaOfOperationId;

    public Voyage getVoyage() {
        if (this.voyage == null) {
            this.voyage = new VoyageImpl();
        }
        return this.voyage;
    }

    public Map<String, String> getImportModes() {
        return this.importModes;
    }

    public Map<String, String> getVoyages() {
        return this.voyages;
    }

    public Map<String, String> getMissions() {
        return this.missions;
    }

    public Map<String, String> getAreaOfOperations() {
        return this.areaOfOperations;
    }

    public ImportMode getImportMode() {
        return this.importMode;
    }

    public void setMissionId(String missionId) {
        this.missionId = missionId;
    }

    public void setAreaOfOperationId(String areaOfOperationId) {
        this.areaOfOperationId = areaOfOperationId;
    }

    public void setImportMode(ImportMode importMode) {
        this.importMode = importMode;
    }

    public String input() throws Exception {
        this.importModes = Maps.newLinkedHashMap();
        for (ImportMode mode : ImportMode.values()) {
            this.importModes.put(mode.name(), this._(mode.getI18nKey(), new Object[0]));
        }
        if (this.importMode == null) {
            this.importMode = ImportMode.USE_EXISTING_VOYAGE;
        }
        VoyageService service = (VoyageService)this.newService(VoyageService.class);
        List allVoyages = service.getEntities(Voyage.class);
        this.voyages = this.sortAndDecorate((Collection)allVoyages, null);
        List allMissions = service.getEntities(Mission.class);
        this.missions = this.sortAndDecorate((Collection)allMissions, null);
        List allAreaOfOperations = service.getEntities(AreaOfOperation.class);
        this.areaOfOperations = this.sortAndDecorate((Collection)allAreaOfOperations, null);
        if (log.isInfoEnabled()) {
            log.info((Object)("File errors : " + this.getFieldErrors()));
        }
        return "input";
    }

    @InputConfig(methodName="input")
    public String execute() throws Exception {
        if (this.importMode == ImportMode.CREATE_NEW_VOYAGE) {
            VoyageService service = (VoyageService)this.newService(VoyageService.class);
            Voyage voyageToCreate = this.getVoyage();
            if (StringUtils.isNotEmpty((CharSequence)this.missionId)) {
                Mission mission = (Mission)service.getEntityById(Mission.class, this.missionId);
                this.voyage.setMission(mission);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.areaOfOperationId)) {
                AreaOfOperation area = (AreaOfOperation)service.getEntityById(AreaOfOperation.class, this.areaOfOperationId);
                this.voyage.setAreaOfOperation(area);
            }
            this.voyage = service.createVoyage(voyageToCreate);
        }
        return "success";
    }
}

