/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: ConfigureVoyage.java 116 2011-11-24 23:06:43Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/trunk/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/importData/ConfigureVoyage.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.importData;

import com.google.common.collect.Maps;
import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.entities.data.VoyageImpl;
import fr.ifremer.echobase.entities.references.AreaOfOperation;
import fr.ifremer.echobase.entities.references.Mission;
import fr.ifremer.echobase.services.VoyageService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.List;
import java.util.Map;

/**
 * Configure the step 1 of import data (says which campagne to use).
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class ConfigureVoyage extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(ConfigureVoyage.class);

    /** Universe of existing voyages. */
    protected Map<String, String> voyages;

    /** Universe of existing missions. */
    protected Map<String, String> missions;

    /** Universe of existing areaOfOperations. */
    protected Map<String, String> areaOfOperations;

    /** Universe of possible import modes. */
    protected Map<String, String> importModes;

    /** Selected import mode. */
    protected ImportMode importMode;

    /** Voyage to use. */
    protected Voyage voyage;

    /** Mission selected id. */
    protected String missionId;

    /** Area of operation selected id. */
    protected String areaOfOperationId;

    public Voyage getVoyage() {
        if (voyage == null) {
            voyage = new VoyageImpl();
        }
        return voyage;
    }

    public Map<String, String> getImportModes() {
        return importModes;
    }

    public Map<String, String> getVoyages() {
        return voyages;
    }

    public Map<String, String> getMissions() {
        return missions;
    }

    public Map<String, String> getAreaOfOperations() {
        return areaOfOperations;
    }

    public ImportMode getImportMode() {
        return importMode;
    }

    public void setMissionId(String missionId) {
        this.missionId = missionId;
    }

    public void setAreaOfOperationId(String areaOfOperationId) {
        this.areaOfOperationId = areaOfOperationId;
    }

    public void setImportMode(ImportMode importMode) {
        this.importMode = importMode;
    }

    @Override
    public String input() throws Exception {
        importModes = Maps.newLinkedHashMap();
        for (ImportMode mode : ImportMode.values()) {
            importModes.put(mode.name(), _(mode.getI18nKey()));
        }

        if (importMode == null) {
            importMode = ImportMode.USE_EXISTING_VOYAGE;
        }

        VoyageService service = newService(VoyageService.class);
        List<Voyage> allVoyages = service.getEntities(Voyage.class);
        voyages = sortAndDecorate(allVoyages, null);

        List<Mission> allMissions = service.getEntities(Mission.class);
        missions = sortAndDecorate(allMissions, null);

        List<AreaOfOperation> allAreaOfOperations =
                service.getEntities(AreaOfOperation.class);
        areaOfOperations = sortAndDecorate(allAreaOfOperations, null);
        if (log.isInfoEnabled()) {
            log.info("File errors : "+getFieldErrors());
        }
        return INPUT;
    }

    @InputConfig(methodName = "input")
    @Override
    public String execute() throws Exception {

        if (importMode == ImportMode.CREATE_NEW_VOYAGE) {

            // create voyage in db
            VoyageService service = newService(VoyageService.class);
            Voyage voyageToCreate = getVoyage();
            //TODO Remove this test when references will be ok
            if (StringUtils.isNotEmpty(missionId)) {
                Mission mission =
                        service.getEntityById(Mission.class, missionId);
                voyage.setMission(mission);
            }
            //TODO Remove this test when references will be ok
            if (StringUtils.isNotEmpty(areaOfOperationId)) {
                AreaOfOperation area = service.getEntityById(AreaOfOperation.class,
                                                             areaOfOperationId);
                voyage.setAreaOfOperation(area);
            }
            voyage = service.createVoyage(voyageToCreate);
        }
        return SUCCESS;
    }

}
