/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: EchoBaseTopiaTransactionFilter.java 35 2011-11-11 02:13:58Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/trunk/echobase-ui/src/main/java/fr/ifremer/echobase/ui/EchoBaseTopiaTransactionFilter.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui;

import com.google.common.base.Supplier;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaRuntimeException;
import org.nuiton.web.filter.TopiaTransactionFilter;

/**
 * EchoBase implementation of the {@link TopiaTransactionFilter}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class EchoBaseTopiaTransactionFilter extends TopiaTransactionFilter {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(EchoBaseTopiaTransactionFilter.class);

    @Override
    protected TopiaContext beginTransaction() throws TopiaRuntimeException {
        EchoBaseApplicationContext applicationContext =
                EchoBaseActionSupport.getEchoBaseApplicationContext();
        Supplier<TopiaContext> rootContextSupplier =
                applicationContext.getRootContextSupplier();

        TopiaContext rootContext = rootContextSupplier.get();
        TopiaContext transaction = null;
        try {
            transaction = rootContext.beginTransaction();
        } catch (TopiaException eee) {
            throw new TopiaRuntimeException("Could not start transaction", eee);
        }
        if (log.isDebugEnabled()) {
            log.debug("Starts a new echo transaction " + transaction);
        }
        return transaction;
    }
}
