/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.util.io;

import fr.ifremer.coser.CoserConstants;
import fr.ifremer.coser.CoserTechnicalException;
import fr.ifremer.coser.CoserUtils;
import fr.ifremer.coser.bean.Project;
import fr.ifremer.coser.bean.RSufiResult;
import fr.ifremer.coser.bean.Selection;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.regex.Matcher;

public class OneRSufiResultFileFilter
implements FileFilter {
    protected File projectsDirectory;
    protected Project project;
    protected Selection selection;
    protected RSufiResult rsufi;
    protected boolean exportWithData;

    public OneRSufiResultFileFilter(File projectsDirectory, Project project, Selection selection, RSufiResult rsufi, boolean exportWithData) {
        this.projectsDirectory = projectsDirectory;
        this.project = project;
        this.selection = selection;
        this.rsufi = rsufi;
        this.exportWithData = exportWithData;
    }

    @Override
    public boolean accept(File pathname) {
        boolean result;
        try {
            String currentPathName = pathname.getCanonicalPath() + File.separator;
            File projectDirectory = new File(this.projectsDirectory, this.project.getName());
            File selectionsDirectory = new File(projectDirectory, "selections");
            File selectionDirectory = new File(selectionsDirectory, this.selection.getName());
            File resultsDirectory = new File(selectionDirectory, "results");
            File resultDirectory = new File(resultsDirectory, this.rsufi.getName());
            String projectPath = projectDirectory.getCanonicalPath() + File.separator;
            String selectionsPath = selectionsDirectory.getCanonicalPath() + File.separator;
            String selectionPath = selectionDirectory.getCanonicalPath() + File.separator;
            String resultsPath = resultsDirectory.getCanonicalPath() + File.separator;
            String resultPath = resultDirectory.getCanonicalPath() + File.separator;
            boolean bl = result = currentPathName.startsWith(projectPath) && !currentPathName.startsWith(selectionsPath) || currentPathName.startsWith(selectionPath) && !currentPathName.startsWith(resultsPath) || currentPathName.startsWith(resultPath);
            if (!this.exportWithData) {
                String fileName = pathname.getName();
                for (CoserConstants.Category category : CoserConstants.Category.values()) {
                    if (!category.isDataCategory()) continue;
                    String sourceFileName = this.project.getDataStorageFileName(category, null);
                    Matcher matcher = CoserUtils.FILENAME_SUFFIX_PATTERN.matcher(sourceFileName);
                    if (matcher.matches()) {
                        result &= !fileName.startsWith(matcher.group(1)) || !fileName.endsWith(matcher.group(2));
                        continue;
                    }
                    result &= !fileName.startsWith(sourceFileName);
                }
            }
        }
        catch (IOException ex) {
            throw new CoserTechnicalException("Can't get system canonical path");
        }
        return result;
    }
}

