/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.storage;

import au.com.bytecode.opencsv.CSVReader;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import fr.ifremer.coser.CoserTechnicalException;
import fr.ifremer.coser.storage.DataStorage;
import fr.ifremer.coser.storage.DataStorageWalker;
import fr.ifremer.coser.storage.MemoryDataStorage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.nuiton.i18n.I18n;

public class DataStorages {
    public static DataStorage load(File file) {
        return DataStorages.load(file, ';');
    }

    public static DataStorage load(File file, char separator) {
        MemoryDataStorage content = new MemoryDataStorage();
        CSVReader csvReader = null;
        try {
            FileInputStream stream = new FileInputStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, "UTF-8"));
            csvReader = new CSVReader((Reader)reader, separator);
            String[] line = csvReader.readNext();
            if (line == null || line.length <= 1) {
                throw new CoserTechnicalException(I18n.t((String)"Can't read file '%s'. Check CSV file separator", (Object[])new Object[]{file.getAbsolutePath()}));
            }
            content.add(line);
            while ((line = csvReader.readNext()) != null) {
                if (line.length <= 1) continue;
                content.add(line);
            }
        }
        catch (IOException ex) {
            try {
                throw new CoserTechnicalException("Can't read file", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(csvReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)csvReader);
        return content;
    }

    public static File save(DataStorage dataStorage, String prefix, String suffix) throws CoserTechnicalException {
        File file;
        try {
            file = File.createTempFile(prefix, suffix);
        }
        catch (IOException e) {
            throw new CoserTechnicalException("Could not create temp file", e);
        }
        file.deleteOnExit();
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            DataStorages.save(dataStorage, writer);
            ((Writer)writer).close();
            ((Writer)writer).close();
        }
        catch (IOException ex) {
            try {
                throw new CoserTechnicalException("Can't save data", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
        return file;
    }

    public static String toString(DataStorage storage) {
        String rawDataText;
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            DataStorages.save(storage, writer);
            rawDataText = writer.toString();
            writer.close();
        }
        catch (IOException ex) {
            throw new CoserTechnicalException("Could not close writer", ex);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
        return rawDataText;
    }

    public static void save(DataStorage dataStorage, Writer writer) throws CoserTechnicalException {
        try {
            for (String[] contentDatas : dataStorage) {
                for (int i = 1; i < contentDatas.length; ++i) {
                    String contentData;
                    if (i != 1) {
                        writer.write(59);
                    }
                    if ((contentData = contentDatas[i]).indexOf(59) > -1) {
                        writer.write("\"" + contentData + "\"");
                        continue;
                    }
                    writer.write(contentData);
                }
                writer.write("\n");
            }
            writer.close();
        }
        catch (IOException ex) {
            throw new CoserTechnicalException("Can't save data", ex);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    public static <P extends Predicate<String[]>> boolean match(DataStorage storage, P predicate, boolean skipHeader) {
        Preconditions.checkNotNull((Object)storage);
        Preconditions.checkNotNull(predicate);
        Iterator<String[]> iterator = storage.iterator(skipHeader);
        boolean result = false;
        while (iterator.hasNext()) {
            String[] tuple = iterator.next();
            if (!predicate.apply((Object)tuple)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static <P extends Predicate<String[]>> DataStorage sub(DataStorage storage, P predicate, String ... header) {
        Preconditions.checkNotNull((Object)storage);
        Preconditions.checkNotNull(predicate);
        Preconditions.checkNotNull((Object)header);
        final MemoryDataStorage result = new MemoryDataStorage();
        result.add(header);
        DataStorages.walk(storage, predicate, new DataStorageWalker(){

            @Override
            public void onRow(String ... row) {
                result.add(row);
            }
        });
        return result;
    }

    public static <W extends DataStorageWalker> void walk(DataStorage storage, W walker) {
        Preconditions.checkNotNull((Object)storage);
        Preconditions.checkNotNull(walker);
        Iterator<String[]> iterator = storage.iterator(true);
        while (iterator.hasNext()) {
            String[] tuple = iterator.next();
            walker.onRow(tuple);
        }
    }

    public static <P extends Predicate<String[]>, W extends DataStorageWalker> void walk(DataStorage storage, P predicate, W walker) {
        Preconditions.checkNotNull((Object)storage);
        Preconditions.checkNotNull(predicate);
        Preconditions.checkNotNull(walker);
        Iterator<String[]> iterator = storage.iterator(true);
        while (iterator.hasNext()) {
            String[] tuple = iterator.next();
            if (!predicate.apply((Object)tuple)) continue;
            walker.onRow(tuple);
        }
    }
}

