/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.services;

import com.itextpdf.text.DocumentException;
import fr.ifremer.coser.CoserBusinessConfig;
import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.CoserConstants;
import fr.ifremer.coser.CoserUtils;
import fr.ifremer.coser.bean.Project;
import fr.ifremer.coser.bean.RSufiResult;
import fr.ifremer.coser.bean.RSufiResultPath;
import fr.ifremer.coser.bean.Selection;
import fr.ifremer.coser.services.CommonService;
import fr.ifremer.coser.services.ProjectService;
import fr.ifremer.coser.services.PublicationService;
import fr.ifremer.coser.storage.DataStorage;
import fr.ifremer.coser.storage.MemoryDataStorage;
import fr.ifremer.coser.util.DataType;
import fr.ifremer.coser.util.InputStreamKnownSizeBody;
import fr.ifremer.coser.util.ProgressMonitor;
import fr.ifremer.coser.util.ProgressStream;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.MultiPartEmail;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.nuiton.i18n.I18n;
import org.nuiton.util.FileUtil;
import org.nuiton.util.StringUtil;
import org.nuiton.util.ZipUtil;
import org.w3c.dom.Document;
import org.xhtmlrenderer.pdf.ITextRenderer;

@Deprecated
public class WebService {
    private static final Log log = LogFactory.getLog(WebService.class);
    protected CoserBusinessConfig config;
    protected CommonService commonService;
    protected ProjectService projectService;
    protected PublicationService publicationService;
    protected MultiKeyMap indicatorsMap;
    protected DataStorage zonesMap;
    protected Configuration freemarkerConfiguration;

    public WebService(CoserBusinessConfig config) {
        this.config = config;
        this.commonService = new CommonService(config);
        this.projectService = new ProjectService(config);
        this.publicationService = new PublicationService(config);
        this.freemarkerConfiguration = new Configuration();
        this.freemarkerConfiguration.setEncoding(Locale.getDefault(), "UTF-8");
        ClassTemplateLoader templateLoader = new ClassTemplateLoader(WebService.class, "/ftl");
        this.freemarkerConfiguration.setTemplateLoader((TemplateLoader)templateLoader);
        this.freemarkerConfiguration.setObjectWrapper((ObjectWrapper)new BeansWrapper());
    }

    protected MultiKeyMap getIndicatorsMap() throws CoserBusinessException {
        if (this.indicatorsMap == null) {
            this.indicatorsMap = new MultiKeyMap();
            File indicatorsFile = this.config.getWebIndicatorsFile();
            DataStorage indicatorsStorage = this.commonService.loadCSVFile(indicatorsFile);
            Iterator<String[]> iteratorInd = indicatorsStorage.iterator(true);
            while (iteratorInd.hasNext()) {
                String[] indicator = iteratorInd.next();
                this.indicatorsMap.put((Object)indicator[0], (Object)"fr", (Object)indicator[1]);
                this.indicatorsMap.put((Object)indicator[0], (Object)"en", (Object)indicator[2]);
                this.indicatorsMap.put((Object)indicator[0], (Object)"es", (Object)indicator[3]);
                this.indicatorsMap.put((Object)indicator[0], (Object)"unit", (Object)indicator[4]);
            }
        }
        return this.indicatorsMap;
    }

    protected String getIndicatorValue(String indicator, String localeCode) throws CoserBusinessException {
        String localLocaleCode = localeCode;
        if (!("fr".equals(localLocaleCode) || "es".equals(localLocaleCode) || "unit".equals(localLocaleCode))) {
            localLocaleCode = "en";
        }
        return (String)this.getIndicatorsMap().get((Object)indicator, (Object)localLocaleCode);
    }

    public DataStorage getZonesMap() throws CoserBusinessException {
        if (this.zonesMap == null) {
            File zoneFile = this.config.getWebZonesFile();
            if (zoneFile.isFile()) {
                this.zonesMap = this.commonService.loadCSVFile(zoneFile);
            } else {
                return new MemoryDataStorage();
            }
        }
        return this.zonesMap;
    }

    public String getZoneFullName(String zoneId) throws CoserBusinessException {
        DataStorage localZoneMap = this.getZonesMap();
        String resultName = null;
        int zoneIndex = localZoneMap.indexOf(zoneId);
        if (zoneIndex != -1) {
            resultName = localZoneMap.get(zoneIndex)[2];
            resultName = resultName + " - " + localZoneMap.get(zoneIndex)[3];
            resultName = resultName + " - " + localZoneMap.get(zoneIndex)[4];
            resultName = resultName + " - " + localZoneMap.get(zoneIndex)[5];
        }
        return resultName;
    }

    public List<RSufiResultPath> findAllProjectWithResult(Date beginDate, Date endDate, boolean onlyPubliableResult) throws CoserBusinessException {
        ArrayList<RSufiResultPath> results = new ArrayList<RSufiResultPath>();
        File projectsDirectory = this.config.getRSufiProjectsDirectory();
        File[] projects = projectsDirectory.listFiles();
        if (projects != null) {
            for (File existingProject : projects) {
                if (!existingProject.isDirectory()) continue;
                String projectName = existingProject.getName();
                Project p = new Project(projectName);
                File selectionsDirectory = new File(existingProject, "selections");
                File[] selections = selectionsDirectory.listFiles();
                if (selections == null) continue;
                for (File existingSelection : selections) {
                    if (!existingSelection.isDirectory()) continue;
                    String selectionName = existingSelection.getName();
                    Selection s = new Selection(selectionName);
                    File rsufisDirectory = new File(existingSelection, "results");
                    File[] rSufiResults = rsufisDirectory.listFiles();
                    if (rSufiResults == null) continue;
                    for (File rSufiResult : rSufiResults) {
                        RSufiResult r;
                        boolean candidate;
                        if (!rSufiResult.isDirectory() || !(candidate = this.isCandidateResult(r = this.projectService.getRSufiResult(rSufiResult), beginDate, endDate, onlyPubliableResult))) continue;
                        RSufiResultPath result = new RSufiResultPath(p, s, r);
                        results.add(result);
                    }
                }
            }
        }
        return results;
    }

    protected boolean isCandidateResult(RSufiResult rsufiResult, Date beginDate, Date endDate, boolean onlyPubliableResult) {
        boolean result = true;
        if (beginDate != null) {
            result &= rsufiResult.getCreationDate().compareTo(beginDate) >= 0;
        }
        if (endDate != null) {
            result &= rsufiResult.getCreationDate().compareTo(endDate) <= 0;
        }
        if (onlyPubliableResult) {
            result &= rsufiResult.isPubliableResult();
        }
        return result;
    }

    public File performResultExtract(Collection<RSufiResultPath> selectedResults, Collection<RSufiResultPath> publishDataResults, File extractDirectory) throws CoserBusinessException {
        File prepareZip = null;
        try {
            if (extractDirectory == null) {
                prepareZip = File.createTempFile("Coserextract-", ".zip");
            } else {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
                String zipName = "Coserextract" + dateFormat.format(new Date()) + ".zip";
                prepareZip = new File(extractDirectory, zipName);
            }
            MultipleFileFilter mFileFilters = new MultipleFileFilter();
            for (RSufiResultPath path : selectedResults) {
                Project project = path.getProject();
                project = this.projectService.openProject(project.getName());
                OneResultFileFilter oneRFF = new OneResultFileFilter(this.config.getRSufiProjectsDirectory(), project, path.getSelection(), path.getRsufiResult(), publishDataResults.contains(path));
                mFileFilters.add(oneRFF);
            }
            File projectsDirectory = this.config.getRSufiProjectsDirectory();
            List files = FileUtil.getFilteredElements((File)projectsDirectory, (FileFilter)mFileFilters, (boolean)true);
            ZipUtil.compressFiles((File)prepareZip, (File)projectsDirectory, (Collection)files, (boolean)false);
        }
        catch (IOException ex) {
            throw new CoserBusinessException("Can't prepare upload data", ex);
        }
        return prepareZip;
    }

    public String performResultUpload(Collection<RSufiResultPath> selectedResults, Collection<RSufiResultPath> indicatorsResults, Collection<RSufiResultPath> mapResults, Collection<RSufiResultPath> publishDataResults, String login, String password, ProgressMonitor progress) throws CoserBusinessException {
        String uploadStatus = null;
        progress.setCurrent(0);
        progress.setText(I18n.t((String)"coser.business.uploadresult.modifyResultOptions", (Object[])new Object[0]));
        this.modifyRSufiResults(selectedResults, indicatorsResults, mapResults, publishDataResults);
        progress.setText(I18n.t((String)"coser.business.uploadresult.checkcollision", (Object[])new Object[0]));
        this.checkDataCollision(selectedResults);
        progress.setText(I18n.t((String)"coser.business.uploadresult.preparezip", (Object[])new Object[0]));
        File prepareZip = this.performResultExtract(selectedResults, publishDataResults, null);
        progress.setText(I18n.t((String)"coser.business.uploadresult.sendzip", (Object[])new Object[0]));
        progress.setTotal((int)prepareZip.length());
        try {
            HttpResponse response;
            DefaultHttpClient httpclient = new DefaultHttpClient();
            MultipartEntity reqEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            StringBody loginBody = new StringBody(login, Charset.forName("UTF-8"));
            reqEntity.addPart("login", (ContentBody)loginBody);
            String sha1password = StringUtil.encodeSHA1((String)password);
            StringBody passwordBody = new StringBody(sha1password, Charset.forName("UTF-8"));
            reqEntity.addPart("sha1Password", (ContentBody)passwordBody);
            ProgressStream stream = new ProgressStream(new FileInputStream(prepareZip), progress);
            InputStreamKnownSizeBody fileBody = new InputStreamKnownSizeBody(stream, prepareZip.length(), "application/zip", prepareZip.getName());
            reqEntity.addPart("resultFile", (ContentBody)fileBody);
            HttpPost httppost = new HttpPost(this.config.getWebUploadURL());
            httppost.setEntity((HttpEntity)reqEntity);
            if (log.isInfoEnabled()) {
                log.info((Object)("Uploading " + prepareZip + " to " + httppost.getURI()));
            }
            if ((response = httpclient.execute((HttpUriRequest)httppost)).getStatusLine().getStatusCode() != 200) {
                uploadStatus = response.getStatusLine().getReasonPhrase();
            }
        }
        catch (ClientProtocolException ex) {
            throw new CoserBusinessException("Can't upload file", ex);
        }
        catch (IOException ex) {
            throw new CoserBusinessException("Can't upload file", ex);
        }
        prepareZip.delete();
        return uploadStatus;
    }

    protected void modifyRSufiResults(Collection<RSufiResultPath> selectedResults, Collection<RSufiResultPath> indicatorsResults, Collection<RSufiResultPath> mapResults, Collection<RSufiResultPath> publishDataResults) throws CoserBusinessException {
        RSufiResult rsufiResult;
        for (RSufiResultPath selectedResult : selectedResults) {
            rsufiResult = selectedResult.getRsufiResult();
            rsufiResult.setIndicatorsResult(false);
            rsufiResult.setMapsResult(false);
            rsufiResult.setDataAllowed(false);
        }
        for (RSufiResultPath indicatorsResult : indicatorsResults) {
            rsufiResult = indicatorsResult.getRsufiResult();
            rsufiResult.setIndicatorsResult(true);
        }
        for (RSufiResultPath mapResult : mapResults) {
            rsufiResult = mapResult.getRsufiResult();
            rsufiResult.setMapsResult(true);
        }
        for (RSufiResultPath publishDataResult : publishDataResults) {
            rsufiResult = publishDataResult.getRsufiResult();
            rsufiResult.setDataAllowed(true);
        }
        for (RSufiResultPath selectedResult : selectedResults) {
            Project project = selectedResult.getProject();
            Selection selection = selectedResult.getSelection();
            RSufiResult rsufiResult2 = selectedResult.getRsufiResult();
            File projectDirectory = new File(this.config.getRSufiProjectsDirectory(), project.getName());
            File selectionsDirectory = new File(projectDirectory, "selections");
            File selectionDirectory = new File(selectionsDirectory, selection.getName());
            File resultsDirectory = new File(selectionDirectory, "results");
            File resultDirectory = new File(resultsDirectory, rsufiResult2.getName());
            this.projectService.saveRSufiResult(resultDirectory, rsufiResult2);
        }
    }

    protected void checkDataCollision(Collection<RSufiResultPath> selectedResults) throws CoserBusinessException {
        ArrayList<String> resultZoneTypeIds = new ArrayList<String>();
        for (RSufiResultPath selectedResult : selectedResults) {
            Project project = selectedResult.getProject();
            Selection selection = selectedResult.getSelection();
            RSufiResult rsufiResult = selectedResult.getRsufiResult();
            String resultZoneTypeId = rsufiResult.getZone() + String.valueOf(rsufiResult.isMapsResult());
            if (resultZoneTypeIds.contains(resultZoneTypeId)) {
                throw new CoserBusinessException(I18n.t((String)"coser.business.resultupload.duplicatedresult", (Object[])new Object[]{project.getName(), selection.getName(), rsufiResult.getName(), rsufiResult.getZone()}));
            }
            resultZoneTypeIds.add(resultZoneTypeId);
        }
    }

    public void registerNewUploadedResults(String login, File archiveFile) throws CoserBusinessException {
        try {
            File tempDirectory = FileUtil.createTempDirectory((String)"coser-upload-", (String)"-tmp");
            ZipUtil.uncompress((File)archiveFile, (File)tempDirectory);
            File projectsDirectory = this.config.getWebIndicatorsProjectsDirectory();
            File mapsDirectory = this.config.getWebMapsProjectsDirectory();
            Map<String, String> indicatorResults = this.getZonesIds(projectsDirectory, true, null, null);
            Map<String, String> mapsResults = this.getZonesIds(mapsDirectory, null, true, null);
            Map<String, String> dataResults = this.getZonesIds(projectsDirectory, null, null, true);
            Map<String, String> noIndicatorsResultZoneIds = this.getZonesIds(tempDirectory, false, null, null);
            this.cleanCurrentProjectDirectory(projectsDirectory, noIndicatorsResultZoneIds.keySet());
            Map<String, String> noMapsResultZoneIds = this.getZonesIds(tempDirectory, null, false, null);
            this.cleanCurrentProjectDirectory(mapsDirectory, noMapsResultZoneIds.keySet());
            Map<String, String> noDataResultZoneIds = this.getZonesIds(tempDirectory, null, null, false);
            Map<String, String> indicatorsResultZoneIds = this.getZonesIds(tempDirectory, true, null, null);
            this.cleanCurrentProjectDirectory(projectsDirectory, indicatorsResultZoneIds.keySet());
            FileFilter indicatorsFileFilter = this.getCopyFileFilter(tempDirectory, false);
            this.customCopyDirectory(tempDirectory, projectsDirectory, indicatorsFileFilter);
            Map<String, String> mapsResultZoneIds = this.getZonesIds(tempDirectory, null, true, null);
            this.cleanCurrentProjectDirectory(mapsDirectory, mapsResultZoneIds.keySet());
            FileFilter mapsFileFilter = this.getCopyFileFilter(tempDirectory, true);
            this.customCopyDirectory(tempDirectory, mapsDirectory, mapsFileFilter);
            Map<String, String> dataResultZoneIds = this.getZonesIds(tempDirectory, null, null, true);
            FileUtils.deleteDirectory((File)tempDirectory);
            if (log.isInfoEnabled()) {
                log.info((Object)("Unzipping file " + archiveFile + " to " + projectsDirectory));
            }
            StringBuilder content = new StringBuilder();
            int count = 0;
            content.append(I18n.t((String)"coser.business.notificationmail.mapsresults", (Object[])new Object[0]) + "\n");
            for (Map.Entry<String, String> noMapsResultZoneId : noMapsResultZoneIds.entrySet()) {
                if (!mapsResults.containsValue(noMapsResultZoneId.getValue())) continue;
                content.append(" - " + I18n.t((String)"coser.business.notificationmail.deleted", (Object[])new Object[]{this.getZoneFullName(noMapsResultZoneId.getKey()), noMapsResultZoneId.getValue()}) + "\n");
                ++count;
            }
            for (Map.Entry<String, String> mapsResultZoneId : mapsResultZoneIds.entrySet()) {
                if (mapsResults.containsValue(mapsResultZoneId.getValue())) continue;
                content.append(" - " + I18n.t((String)"coser.business.notificationmail.added", (Object[])new Object[]{this.getZoneFullName(mapsResultZoneId.getKey()), mapsResultZoneId.getValue()}) + "\n");
                ++count;
            }
            content.append("\n");
            content.append(I18n.t((String)"coser.business.notificationmail.indicatorsresults", (Object[])new Object[0]) + "\n");
            for (Map.Entry<String, String> noIndicatorsResultZoneId : noIndicatorsResultZoneIds.entrySet()) {
                if (!indicatorResults.containsValue(noIndicatorsResultZoneId.getValue())) continue;
                content.append(" - " + I18n.t((String)"coser.business.notificationmail.deleted", (Object[])new Object[]{this.getZoneFullName(noIndicatorsResultZoneId.getKey()), noIndicatorsResultZoneId.getValue()}) + "\n");
                ++count;
            }
            for (Map.Entry<String, String> indicatorsResultZoneId : indicatorsResultZoneIds.entrySet()) {
                if (indicatorResults.containsValue(indicatorsResultZoneId.getValue())) continue;
                content.append(" - " + I18n.t((String)"coser.business.notificationmail.added", (Object[])new Object[]{this.getZoneFullName(indicatorsResultZoneId.getKey()), indicatorsResultZoneId.getValue()}) + "\n");
                ++count;
            }
            content.append("\n");
            content.append(I18n.t((String)"coser.business.notificationmail.dataresults", (Object[])new Object[0]) + "\n");
            for (Map.Entry<String, String> noDataResultZoneId : noDataResultZoneIds.entrySet()) {
                if (!dataResults.containsValue(noDataResultZoneId.getValue())) continue;
                content.append(" - " + I18n.t((String)"coser.business.notificationmail.deleted", (Object[])new Object[]{this.getZoneFullName(noDataResultZoneId.getKey()), noDataResultZoneId.getValue()}) + "\n");
                ++count;
            }
            for (Map.Entry<String, String> dataResultZoneId : dataResultZoneIds.entrySet()) {
                if (dataResults.containsValue(dataResultZoneId.getValue())) continue;
                content.append(" - " + I18n.t((String)"coser.business.notificationmail.added", (Object[])new Object[]{this.getZoneFullName(dataResultZoneId.getKey()), dataResultZoneId.getValue()}) + "\n");
                ++count;
            }
            content.append("\n");
            this.sendNewResultNotifications(login, count, content.toString());
            this.updateDataProperties();
        }
        catch (IOException ex) {
            throw new CoserBusinessException("Can't uncompress file", ex);
        }
    }

    protected void customCopyDirectory(File srcDir, File destDir, FileFilter indicatorsFileFilter) throws IOException {
        List files = FileUtil.getFilteredElements((File)srcDir, null, (boolean)true);
        for (File file : files) {
            if (!indicatorsFileFilter.accept(file)) continue;
            String path = file.getPath().substring(srcDir.getPath().length());
            File destFile = new File(destDir, path);
            if (file.isDirectory()) {
                destFile.mkdirs();
                continue;
            }
            FileUtils.copyFile((File)file, (File)destFile);
        }
    }

    protected void updateDataProperties() throws CoserBusinessException {
        File webProperties = this.config.getWebPropertiesFile();
        Properties props = new Properties();
        FileInputStream iStream = null;
        FileOutputStream oStream = null;
        try {
            if (webProperties.isFile()) {
                iStream = new FileInputStream(webProperties);
                props.load(iStream);
            }
            props.setProperty("updateDate", String.valueOf(new Date().getTime()));
            oStream = new FileOutputStream(webProperties);
            props.store(oStream, "Update data");
        }
        catch (IOException ex) {
            try {
                throw new CoserBusinessException("Can't save properties file", ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(iStream);
                IOUtils.closeQuietly(oStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)iStream);
        IOUtils.closeQuietly((OutputStream)oStream);
    }

    public Date getLastDataUpdateDate() throws CoserBusinessException {
        Date dataUpdateDate = null;
        File webProperties = this.config.getWebPropertiesFile();
        if (webProperties.isFile()) {
            FileInputStream stream;
            block6: {
                Properties props = new Properties();
                stream = null;
                try {
                    stream = new FileInputStream(webProperties);
                    props.load(stream);
                    if (!props.containsKey("updateDate")) break block6;
                    String date = props.getProperty("updateDate");
                    long time = Long.parseLong(date);
                    dataUpdateDate = new Date(time);
                }
                catch (IOException ex) {
                    try {
                        throw new CoserBusinessException("Can't read properties file", ex);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(stream);
                        throw throwable;
                    }
                }
            }
            IOUtils.closeQuietly((InputStream)stream);
        }
        if (dataUpdateDate == null) {
            dataUpdateDate = new Date(0L);
        }
        return dataUpdateDate;
    }

    protected Map<String, String> getZonesIds(File scanDirectory, Boolean indicatorResults, Boolean mapResults, Boolean dataResults) throws CoserBusinessException {
        HashMap<String, String> resultIds = new HashMap<String, String>();
        File[] projectFiles = scanDirectory.listFiles();
        if (projectFiles != null) {
            for (File projectFile : projectFiles) {
                File selectionsDirectory;
                File[] selectionFiles;
                if (!projectFile.isDirectory() || (selectionFiles = (selectionsDirectory = new File(projectFile, "selections")).listFiles()) == null) continue;
                for (File selectionFile : selectionFiles) {
                    File resultsDirectory;
                    File[] resultFiles;
                    if (!selectionFile.isDirectory() || (resultFiles = (resultsDirectory = new File(selectionFile, "results")).listFiles()) == null) continue;
                    for (File resultFile : resultFiles) {
                        String resultResultId;
                        if (!resultFile.isDirectory()) continue;
                        RSufiResult rsufiResult = this.projectService.getRSufiResult(resultFile);
                        if (indicatorResults != null && rsufiResult.isIndicatorsResult() != indicatorResults.booleanValue() || mapResults != null && rsufiResult.isMapsResult() != mapResults.booleanValue() || dataResults != null && rsufiResult.isDataAllowed() != dataResults.booleanValue() || !StringUtils.isNotBlank((CharSequence)(resultResultId = rsufiResult.getZone()))) continue;
                        String resultPath = projectFile.getName() + "/" + selectionFile.getName() + "/" + resultFile.getName();
                        resultIds.put(resultResultId, resultPath);
                    }
                }
            }
        }
        return resultIds;
    }

    protected FileFilter getCopyFileFilter(File scanDirectory, boolean mapResults) throws CoserBusinessException {
        MultipleFileFilter aggregateFileFilter = new MultipleFileFilter();
        File[] projectFiles = scanDirectory.listFiles();
        if (projectFiles != null) {
            for (File projectFile : projectFiles) {
                File selectionsDirectory;
                File[] selectionFiles;
                if (!projectFile.isDirectory() || (selectionFiles = (selectionsDirectory = new File(projectFile, "selections")).listFiles()) == null) continue;
                for (File selectionFile : selectionFiles) {
                    File resultsDirectory;
                    File[] resultFiles;
                    if (!selectionFile.isDirectory() || (resultFiles = (resultsDirectory = new File(selectionFile, "results")).listFiles()) == null) continue;
                    for (File resultFile : resultFiles) {
                        if (!resultFile.isDirectory()) continue;
                        RSufiResult rsufiResult = this.projectService.getRSufiResult(resultFile);
                        if ((!mapResults || !rsufiResult.isMapsResult()) && (mapResults || !rsufiResult.isIndicatorsResult())) continue;
                        Project p = new Project(projectFile.getName());
                        Selection s = new Selection(selectionFile.getName());
                        OneResultFileFilter resultFileFilter = new OneResultFileFilter(scanDirectory, p, s, rsufiResult, true);
                        aggregateFileFilter.add(resultFileFilter);
                    }
                }
            }
        }
        return aggregateFileFilter;
    }

    protected void cleanCurrentProjectDirectory(File projectsDirectory, Collection<String> newResultIds) throws CoserBusinessException {
        try {
            File[] projectFiles = projectsDirectory.listFiles();
            if (projectFiles != null) {
                for (File projectFile : projectFiles) {
                    if (!projectFile.isDirectory()) continue;
                    int projectSelectionCount = 0;
                    File selectionsDirectory = new File(projectFile, "selections");
                    File[] selectionFiles = selectionsDirectory.listFiles();
                    if (selectionFiles != null) {
                        for (File selectionFile : selectionFiles) {
                            if (!selectionFile.isDirectory()) continue;
                            int selectionResultCount = 0;
                            File resultsDirectory = new File(selectionFile, "results");
                            File[] resultFiles = resultsDirectory.listFiles();
                            if (resultFiles != null) {
                                for (File resultFile : resultFiles) {
                                    if (!resultFile.isDirectory()) continue;
                                    RSufiResult rsufiResult = this.projectService.getRSufiResult(resultFile);
                                    String resultResultId = rsufiResult.getZone();
                                    if (newResultIds.contains(resultResultId)) {
                                        FileUtils.deleteDirectory((File)resultFile);
                                        continue;
                                    }
                                    ++selectionResultCount;
                                }
                            }
                            if (selectionResultCount == 0) {
                                FileUtils.deleteDirectory((File)selectionFile);
                                continue;
                            }
                            ++projectSelectionCount;
                        }
                    }
                    if (projectSelectionCount != 0) continue;
                    FileUtils.deleteDirectory((File)projectFile);
                }
            }
        }
        catch (IOException ex) {
            throw new CoserBusinessException("Can't delete directory", ex);
        }
    }

    protected void sendNewResultNotifications(String login, int count, String detail) {
        List<String> emails = this.config.getNewResultNotificationList();
        for (String email : emails) {
            try {
                MultiPartEmail emailPart = new MultiPartEmail();
                emailPart.setHostName(this.config.getSmtpHost());
                emailPart.addTo(email);
                emailPart.setFrom("noreply-coser@ifremer.fr", "Coser");
                emailPart.setSubject(I18n.t((String)"coser.business.notificationmail.subject", (Object[])new Object[]{count}));
                emailPart.setContent((Object)I18n.t((String)"coser.business.notificationmail.body", (Object[])new Object[]{login, detail}), "text/plain; charset=ISO-8859-9");
                emailPart.send();
            }
            catch (EmailException ex) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"Can't send mail", (Throwable)ex);
            }
        }
    }

    public Map<String, String> getFacades() throws CoserBusinessException {
        LinkedHashMap<String, String> facades = new LinkedHashMap<String, String>();
        DataStorage zonesMap = this.getZonesMap();
        Iterator<String[]> itZone = zonesMap.iterator(true);
        while (itZone.hasNext()) {
            String[] tuple = itZone.next();
            facades.put(tuple[1], tuple[2]);
        }
        return facades;
    }

    public Map<String, String> getZoneForFacade(String facade, boolean onlyWithSource, boolean forMap) throws CoserBusinessException {
        HashMap<String, String> zonesForFacade = new HashMap<String, String>();
        ArrayList<String> subZones = new ArrayList<String>();
        Iterator<String[]> itZone = this.getZonesMap().iterator(true);
        while (itZone.hasNext()) {
            String[] tuple = itZone.next();
            if (facade != null && !tuple[1].equals(facade)) continue;
            subZones.add(tuple[0]);
        }
        File projectsDirectory = null;
        projectsDirectory = forMap ? this.config.getWebMapsProjectsDirectory() : this.config.getWebIndicatorsProjectsDirectory();
        File[] projectFiles = projectsDirectory.listFiles();
        if (projectFiles != null) {
            for (File projectFile : projectFiles) {
                File selectionsDirectory;
                File[] selectionFiles;
                if (!projectFile.isDirectory() || (selectionFiles = (selectionsDirectory = new File(projectFile, "selections")).listFiles()) == null) continue;
                for (File selectionFile : selectionFiles) {
                    File resultsDirectory;
                    File[] resultFiles;
                    if (!selectionFile.isDirectory() || (resultFiles = (resultsDirectory = new File(selectionFile, "results")).listFiles()) == null) continue;
                    for (File resultFile : resultFiles) {
                        String resultZoneId;
                        if (!resultFile.isDirectory()) continue;
                        RSufiResult rsufiResult = this.projectService.getRSufiResult(resultFile);
                        if (onlyWithSource && !rsufiResult.isDataAllowed() || !subZones.contains(resultZoneId = rsufiResult.getZone())) continue;
                        String zoneid = resultZoneId;
                        int zoneIndex = this.getZonesMap().indexOf(zoneid);
                        String[] zoneData = this.getZonesMap().get(zoneIndex);
                        String zoneName = zoneData[3] + " - " + zoneData[4] + " - " + zoneData[5];
                        zonesForFacade.put(zoneid, zoneName);
                    }
                }
            }
        }
        return zonesForFacade;
    }

    public Map<String, List<String>> getZoneByFacade() throws CoserBusinessException {
        HashMap<String, List<String>> zonesByFacade = new HashMap<String, List<String>>();
        Iterator<String[]> itZone = this.getZonesMap().iterator(true);
        while (itZone.hasNext()) {
            String[] tuple = itZone.next();
            String facadeid = tuple[1];
            String zoneid = tuple[0];
            ArrayList<String> zones = (ArrayList<String>)zonesByFacade.get(facadeid);
            if (zones == null) {
                zones = new ArrayList<String>();
                zonesByFacade.put(facadeid, zones);
            }
            zones.add(zoneid);
        }
        return zonesByFacade;
    }

    public Map<String, String> getZonePictures() throws CoserBusinessException {
        HashMap<String, String> result = new HashMap<String, String>();
        Iterator<String[]> itZone = this.getZonesMap().iterator(true);
        while (itZone.hasNext()) {
            String[] tuple = itZone.next();
            result.put(tuple[0], tuple[9]);
        }
        return result;
    }

    public Map<String, String> getZoneMetaInfo(Locale locale) throws CoserBusinessException {
        HashMap<String, String> result = new HashMap<String, String>();
        Iterator<String[]> itZone = this.getZonesMap().iterator(true);
        while (itZone.hasNext()) {
            String[] tuple = itZone.next();
            if (locale != null && "fr".equals(locale.getLanguage())) {
                result.put(tuple[0], tuple[6]);
                continue;
            }
            if (locale != null && "es".equals(locale.getLanguage())) {
                result.put(tuple[0], tuple[8]);
                continue;
            }
            result.put(tuple[0], tuple[7]);
        }
        return result;
    }

    public Map<String, String> getSpecies(String zone, boolean forMap) throws CoserBusinessException {
        return this.getSpecies(Collections.singleton(zone), forMap);
    }

    public Map<String, String> getSpecies(Collection<String> zones, boolean forMap) throws CoserBusinessException {
        TreeMap<String, String> result = new TreeMap<String, String>();
        File projectsDirectory = null;
        projectsDirectory = forMap ? this.config.getWebMapsProjectsDirectory() : this.config.getWebIndicatorsProjectsDirectory();
        File[] projectFiles = projectsDirectory.listFiles();
        if (projectFiles != null) {
            for (File projectFile : projectFiles) {
                File selectionsDirectory;
                File[] selectionFiles;
                if (!projectFile.isDirectory() || (selectionFiles = (selectionsDirectory = new File(projectFile, "selections")).listFiles()) == null) continue;
                for (File selectionFile : selectionFiles) {
                    File resultsDirectory;
                    File[] resultFiles;
                    if (!selectionFile.isDirectory() || (resultFiles = (resultsDirectory = new File(selectionFile, "results")).listFiles()) == null) continue;
                    for (File resultFile : resultFiles) {
                        RSufiResult rsufiResult;
                        if (!resultFile.isDirectory() || (rsufiResult = this.projectService.getRSufiResult(resultFile)).getZone() == null || !zones.contains(rsufiResult.getZone())) continue;
                        Project project = this.projectService.openProject(projectFile.getName(), projectsDirectory);
                        Map<String, String> resultSpecies = this.getRsufiResultSpecies(project, resultFile, rsufiResult);
                        result.putAll(resultSpecies);
                    }
                }
            }
        }
        return result;
    }

    protected Map<String, String> getRsufiResultSpecies(Project project, File resultDirectory, RSufiResult rsufiResult) throws CoserBusinessException {
        HashMap<String, String> result = new HashMap<String, String>();
        HashMap<String, String> speciesNames = new HashMap<String, String>();
        Iterator<String[]> reftax = project.getRefTaxSpecies().iterator(true);
        while (reftax.hasNext()) {
            String[] tuple = reftax.next();
            String speciesCode = tuple[3];
            String speciesName = tuple[4] + " " + tuple[5];
            speciesNames.put(speciesCode, speciesName);
        }
        File estPopIndFile = new File(resultDirectory, rsufiResult.getEstPopIndName());
        DataStorage dataStorage = this.commonService.loadCSVFile(estPopIndFile, '\t');
        Iterator<String[]> estPopIndIterator = dataStorage.iterator(true);
        while (estPopIndIterator.hasNext()) {
            String[] tuple = estPopIndIterator.next();
            String specyCode = tuple[3];
            String specyName = (String)speciesNames.get(specyCode);
            if (!StringUtils.isNotEmpty((CharSequence)specyName)) continue;
            result.put(specyCode, specyName);
        }
        return result;
    }

    public Map<String, String> getIndicators(String zone, String species, Locale locale) throws CoserBusinessException {
        TreeMap<String, String> indicators = new TreeMap<String, String>();
        File projectsDirectory = this.config.getWebIndicatorsProjectsDirectory();
        File[] projectFiles = projectsDirectory.listFiles();
        if (projectFiles != null) {
            for (File projectFile : projectFiles) {
                File selectionsDirectory;
                File[] selectionFiles;
                if (!projectFile.isDirectory() || (selectionFiles = (selectionsDirectory = new File(projectFile, "selections")).listFiles()) == null) continue;
                block1: for (File selectionFile : selectionFiles) {
                    File resultsDirectory;
                    File[] resultFiles;
                    if (!selectionFile.isDirectory() || (resultFiles = (resultsDirectory = new File(selectionFile, "results")).listFiles()) == null) continue;
                    for (File resultFile : resultFiles) {
                        RSufiResult rsufiResult;
                        if (!resultFile.isDirectory() || (rsufiResult = this.projectService.getRSufiResult(resultFile)).getZone() == null || !rsufiResult.getZone().equals(zone)) continue;
                        Map<String, String> resultIndicators = null;
                        resultIndicators = species == null ? this.getRsufiResultComIndicators(resultFile, rsufiResult, locale) : this.getRsufiResultPopIndicators(resultFile, rsufiResult, species, locale);
                        indicators.putAll(resultIndicators);
                        continue block1;
                    }
                }
            }
        }
        return indicators;
    }

    public Map<String, String> getIndicators(Collection<String> zones, DataType dataType, Locale locale) throws CoserBusinessException {
        TreeMap<String, String> indicators = new TreeMap<String, String>();
        File projectsDirectory = this.config.getWebIndicatorsProjectsDirectory();
        File[] projectFiles = projectsDirectory.listFiles();
        if (projectFiles != null) {
            for (File projectFile : projectFiles) {
                File selectionsDirectory;
                File[] selectionFiles;
                if (!projectFile.isDirectory() || (selectionFiles = (selectionsDirectory = new File(projectFile, "selections")).listFiles()) == null) continue;
                for (File selectionFile : selectionFiles) {
                    File resultsDirectory;
                    File[] resultFiles;
                    if (!selectionFile.isDirectory() || (resultFiles = (resultsDirectory = new File(selectionFile, "results")).listFiles()) == null) continue;
                    for (File resultFile : resultFiles) {
                        RSufiResult rsufiResult;
                        if (!resultFile.isDirectory() || !zones.contains((rsufiResult = this.projectService.getRSufiResult(resultFile)).getZone())) continue;
                        Map<String, String> resultIndicators = null;
                        if (dataType == DataType.COMMUNITY) {
                            resultIndicators = this.getRsufiResultComIndicators(resultFile, rsufiResult, locale);
                            indicators.putAll(resultIndicators);
                        }
                        if (dataType != DataType.POPULATION) continue;
                        resultIndicators = this.getRsufiResultPopIndicators(resultFile, rsufiResult, null, locale);
                        indicators.putAll(resultIndicators);
                    }
                }
            }
        }
        return indicators;
    }

    protected Map<String, String> getRsufiResultPopIndicators(File resultDirectory, RSufiResult rsufiResult, String species, Locale locale) throws CoserBusinessException {
        HashMap<String, String> result = new HashMap<String, String>();
        File estPopIndFile = new File(resultDirectory, rsufiResult.getEstPopIndName());
        DataStorage dataStorage = this.commonService.loadCSVFile(estPopIndFile, '\t');
        Iterator<String[]> estPopIndIterator = dataStorage.iterator(true);
        while (estPopIndIterator.hasNext()) {
            String[] tuple = estPopIndIterator.next();
            String specyCode = tuple[3];
            if (species != null && !specyCode.equals(species)) continue;
            String indicatorCode = tuple[1];
            String translations = this.getIndicatorValue(indicatorCode, locale.getLanguage());
            if (translations == null) {
                translations = "##" + indicatorCode + "##" + locale.getLanguage();
            }
            result.put(indicatorCode, translations);
        }
        return result;
    }

    protected Map<String, String> getRsufiResultComIndicators(File resultDirectory, RSufiResult rsufiResult, Locale locale) throws CoserBusinessException {
        HashMap<String, String> result = new HashMap<String, String>();
        File estComIndFile = new File(resultDirectory, rsufiResult.getEstComIndName());
        DataStorage dataStorage = this.commonService.loadCSVFile(estComIndFile, '\t');
        Iterator<String[]> estPopIndIterator = dataStorage.iterator(true);
        while (estPopIndIterator.hasNext()) {
            String[] tuple = estPopIndIterator.next();
            String indicatorCode = tuple[1];
            String translations = this.getIndicatorValue(indicatorCode, locale.getLanguage());
            if (translations == null) {
                translations = "##" + indicatorCode + "##" + locale.getLanguage();
            }
            result.put(indicatorCode, translations);
        }
        return result;
    }

    public Map<String, String> getIndicatorLists(String zone, String indicator, Locale locale) throws CoserBusinessException {
        LinkedHashMap<String, String> indicators = new LinkedHashMap<String, String>();
        File projectsDirectory = this.config.getWebIndicatorsProjectsDirectory();
        File[] projectFiles = projectsDirectory.listFiles();
        if (projectFiles != null) {
            for (File projectFile : projectFiles) {
                File selectionsDirectory;
                File[] selectionFiles;
                if (!projectFile.isDirectory() || (selectionFiles = (selectionsDirectory = new File(projectFile, "selections")).listFiles()) == null) continue;
                block1: for (File selectionFile : selectionFiles) {
                    File resultsDirectory;
                    File[] resultFiles;
                    if (!selectionFile.isDirectory() || (resultFiles = (resultsDirectory = new File(selectionFile, "results")).listFiles()) == null) continue;
                    for (File resultFile : resultFiles) {
                        RSufiResult rsufiResult;
                        if (!resultFile.isDirectory() || (rsufiResult = this.projectService.getRSufiResult(resultFile)).getZone() == null || !rsufiResult.getZone().equals(zone)) continue;
                        File codeTypeEspecesFile = new File(projectFile, CoserConstants.Category.TYPE_ESPECES.getStorageFileName());
                        Map<String, String> resultIndicators = this.getRsufiResultComIndicatorLists(resultFile, rsufiResult, codeTypeEspecesFile, indicator, locale);
                        indicators.putAll(resultIndicators);
                        continue block1;
                    }
                }
            }
        }
        return indicators;
    }

    protected Map<String, String> getRsufiResultComIndicatorLists(File resultDirectory, RSufiResult rsufiResult, File codeTypeEspecesFile, String indicator, Locale locale) throws CoserBusinessException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        File estComIndFile = new File(resultDirectory, rsufiResult.getEstComIndName());
        DataStorage dataStorage = this.commonService.loadCSVFile(estComIndFile, '\t');
        DataStorage dataStorageType = this.commonService.loadCSVFile(codeTypeEspecesFile, ';');
        Iterator<String[]> estPopIndIterator = dataStorage.iterator(true);
        while (estPopIndIterator.hasNext()) {
            String[] tuple = estPopIndIterator.next();
            String indicatorCode = tuple[1];
            if (!indicatorCode.equals(indicator)) continue;
            String list = tuple[2];
            String listLetter = String.valueOf(list.charAt(0));
            String translation = "## " + list + " not found ##";
            Iterator<String[]> typeIterator = dataStorageType.iterator(true);
            while (typeIterator.hasNext()) {
                String[] tupleType = typeIterator.next();
                if (!tupleType[4].equals(listLetter)) continue;
                if (tupleType[4].equalsIgnoreCase("T")) {
                    if (locale != null && "fr".equals(locale.getLanguage())) {
                        translation = "Tous Liste " + list.charAt(1);
                        break;
                    }
                    if (locale != null && "en".equals(locale.getLanguage())) {
                        translation = "Todo Lista " + list.charAt(1);
                        break;
                    }
                    translation = "All List " + list.charAt(1);
                    break;
                }
                if (locale != null && "fr".equals(locale.getLanguage())) {
                    translation = tupleType[0] + " Liste " + list.charAt(1);
                    break;
                }
                if (locale != null && "en".equals(locale.getLanguage())) {
                    translation = tupleType[0] + " Lista " + list.charAt(1);
                    break;
                }
                translation = tupleType[0] + " List " + list.charAt(1);
                break;
            }
            result.put(list, translation);
        }
        return result;
    }

    public File getChart(String zone, String species, String indicator, String list, Locale locale) throws CoserBusinessException {
        File result = null;
        File projectsDirectory = this.config.getWebIndicatorsProjectsDirectory();
        File[] projectFiles = projectsDirectory.listFiles();
        if (projectFiles != null) {
            for (File projectFile : projectFiles) {
                File selectionsDirectory;
                File[] selectionFiles;
                if (!projectFile.isDirectory() || (selectionFiles = (selectionsDirectory = new File(projectFile, "selections")).listFiles()) == null) continue;
                block1: for (File selectionFile : selectionFiles) {
                    File resultsDirectory;
                    File[] resultFiles;
                    if (!selectionFile.isDirectory() || (resultFiles = (resultsDirectory = new File(selectionFile, "results")).listFiles()) == null) continue;
                    for (File resultFile : resultFiles) {
                        RSufiResult rsufiResult;
                        if (!resultFile.isDirectory() || (rsufiResult = this.projectService.getRSufiResult(resultFile)).getZone() == null || !rsufiResult.getZone().equals(zone)) continue;
                        Project project = this.projectService.openProject(projectFile.getName(), projectsDirectory);
                        String indicatorName = this.getIndicatorValue(indicator, locale.getLanguage());
                        String unit = this.getIndicatorValue(indicator, "unit");
                        String zoneDisplayName = this.getZoneFullName(zone);
                        if (species == null) {
                            File codeTypeEspecesFile = new File(projectFile, CoserConstants.Category.TYPE_ESPECES.getStorageFileName());
                            result = this.publicationService.getRsufiResultComChart(project, resultFile, rsufiResult, codeTypeEspecesFile, indicator, list, zoneDisplayName, indicatorName, unit, locale);
                            continue block1;
                        }
                        result = this.publicationService.getRsufiResultPopChart(project, resultFile, rsufiResult, species, indicator, zoneDisplayName, indicatorName, unit, locale);
                        continue block1;
                    }
                }
            }
        }
        return result;
    }

    public File getChartData(String zone, String species, String indicator, String list, Locale locale) throws CoserBusinessException {
        File result = null;
        File projectsDirectory = this.config.getWebIndicatorsProjectsDirectory();
        File[] projectFiles = projectsDirectory.listFiles();
        if (projectFiles != null) {
            for (File projectFile : projectFiles) {
                File selectionsDirectory;
                File[] selectionFiles;
                if (!projectFile.isDirectory() || (selectionFiles = (selectionsDirectory = new File(projectFile, "selections")).listFiles()) == null) continue;
                block1: for (File selectionFile : selectionFiles) {
                    File resultsDirectory;
                    File[] resultFiles;
                    if (!selectionFile.isDirectory() || (resultFiles = (resultsDirectory = new File(selectionFile, "results")).listFiles()) == null) continue;
                    for (File resultFile : resultFiles) {
                        RSufiResult rsufiResult;
                        if (!resultFile.isDirectory() || (rsufiResult = this.projectService.getRSufiResult(resultFile)).getZone() == null || !rsufiResult.getZone().equals(zone)) continue;
                        result = this.getChartDataFile(projectsDirectory, projectFile, selectionFile, resultFile, rsufiResult, species, indicator, list, locale);
                        continue block1;
                    }
                }
            }
        }
        return result;
    }

    protected File getChartDataFile(File projectsDirectory, File projectDirectory, File selectionDirectory, File resultDirectory, RSufiResult rSufiResult, String species, String indicator, String list, Locale locale) throws CoserBusinessException {
        File result = null;
        try {
            if (species == null) {
                File tempDir = FileUtil.createTempDirectory((String)"coser-chartdata-", (String)"-tmp");
                String surveyName = this.projectService.getProjectSurveyName(resultDirectory, rSufiResult);
                File baseDir = new File(tempDir, surveyName);
                baseDir.mkdirs();
                File csvFile = this.publicationService.getRsufiResultComChartData(resultDirectory, rSufiResult, indicator, list);
                File csvFileCopied = new File(baseDir, indicator + ".csv");
                FileUtils.copyFile((File)csvFile, (File)csvFileCopied);
                csvFile.delete();
                Project project = this.projectService.openProject(projectDirectory.getName(), projectsDirectory);
                Selection selection = project.getSelections().get(selectionDirectory.getName());
                File metaFile = this.generateMetaFilePDF(project, selection, resultDirectory, rSufiResult, indicator, locale);
                File metaFileCopied = new File(baseDir, "Information.pdf");
                FileUtils.copyFile((File)metaFile, (File)metaFileCopied);
                result = File.createTempFile("coser-chartdata-", ".zip");
                result.deleteOnExit();
                ZipUtil.compress((File)result, (File)baseDir);
                FileUtils.deleteDirectory((File)tempDir);
            } else {
                result = this.publicationService.getRsufiResultPopChartData(resultDirectory, rSufiResult, species, indicator);
            }
        }
        catch (IOException ex) {
            throw new CoserBusinessException("Can't generate chart data file", ex);
        }
        return result;
    }

    public File getMapFile(String zone, String species) throws CoserBusinessException {
        File result = null;
        File projectsDirectory = this.config.getWebMapsProjectsDirectory();
        File[] projectFiles = projectsDirectory.listFiles();
        if (projectFiles != null) {
            for (File projectFile : projectFiles) {
                File selectionsDirectory;
                File[] selectionFiles;
                if (!projectFile.isDirectory() || (selectionFiles = (selectionsDirectory = new File(projectFile, "selections")).listFiles()) == null) continue;
                for (File selectionFile : selectionFiles) {
                    File resultsDirectory;
                    File[] resultFiles;
                    if (!selectionFile.isDirectory() || (resultFiles = (resultsDirectory = new File(selectionFile, "results")).listFiles()) == null) continue;
                    for (File resultFile : resultFiles) {
                        RSufiResult rsufiResult;
                        if (!resultFile.isDirectory() || (rsufiResult = this.projectService.getRSufiResult(resultFile)).getZone() == null || !rsufiResult.getZone().equals(zone) || !rsufiResult.isMapsResult()) continue;
                        String surveyName = this.projectService.getProjectSurveyName(resultFile, rsufiResult);
                        String mapName = null;
                        mapName = species != null ? surveyName + "_" + species.toUpperCase() + ".png" : surveyName + "_Repartition-stations.png";
                        File mapsDirectory = new File(resultFile, "maps");
                        result = new File(mapsDirectory, mapName);
                    }
                }
            }
        }
        return result;
    }

    public File getSourceZip(String zone, Locale locale) throws CoserBusinessException {
        File result = null;
        File projectsDirectory = this.config.getWebIndicatorsProjectsDirectory();
        File[] projectFiles = projectsDirectory.listFiles();
        if (projectFiles != null) {
            for (File projectFile : projectFiles) {
                File selectionsDirectory;
                File[] selectionFiles;
                if (!projectFile.isDirectory() || (selectionFiles = (selectionsDirectory = new File(projectFile, "selections")).listFiles()) == null) continue;
                for (File selectionFile : selectionFiles) {
                    File resultsDirectory;
                    File[] resultFiles;
                    if (!selectionFile.isDirectory() || (resultFiles = (resultsDirectory = new File(selectionFile, "results")).listFiles()) == null) continue;
                    for (File resultFile : resultFiles) {
                        RSufiResult rsufiResult;
                        if (!resultFile.isDirectory() || (rsufiResult = this.projectService.getRSufiResult(resultFile)).getZone() == null || !rsufiResult.getZone().equals(zone)) continue;
                        Project project = this.projectService.openProject(projectFile.getName(), projectsDirectory);
                        Selection selection = project.getSelections().get(selectionFile.getName());
                        this.projectService.loadSelectionData(projectsDirectory, project, selection);
                        result = this.generateSourceZip(project, selection, resultFile, rsufiResult, locale);
                    }
                }
            }
        }
        return result;
    }

    protected File generateSourceZip(Project project, Selection selection, File resultDirectory, RSufiResult rSufiResult, Locale locale) throws CoserBusinessException {
        if (!rSufiResult.isDataAllowed()) {
            throw new CoserBusinessException("Can't download source for non allowed result");
        }
        File resultZip = null;
        try {
            File tempDir = FileUtil.createTempDirectory((String)"coser-source-", (String)"-tmp");
            File archiveDir = this.projectService.extractRSUfiData(project, selection, tempDir, true);
            String filename = null;
            filename = locale != null && "fr".equals(locale.getLanguage()) ? "DechargeDonnees.pdf" : (locale != null && "es".equals(locale.getLanguage()) ? "DatosDeExencionDeResponsabilidad.pdf" : "DataDisclaimer.pdf");
            File dechargePDF = new File(archiveDir, filename);
            this.generateDechargePDF(dechargePDF, resultDirectory, rSufiResult, locale);
            File projectsDirectory = this.config.getWebIndicatorsProjectsDirectory();
            File projectDirectory = new File(projectsDirectory, project.getName());
            File reftaxFile = new File(projectDirectory, CoserConstants.Category.REFTAX_SPECIES.getStorageFileName());
            FileUtils.copyFileToDirectory((File)reftaxFile, (File)archiveDir);
            resultZip = File.createTempFile("coser-source-", ".zip");
            resultZip.deleteOnExit();
            ZipUtil.compress((File)resultZip, (File)archiveDir);
            FileUtils.deleteDirectory((File)tempDir);
        }
        catch (IOException ex) {
            throw new CoserBusinessException("Can't create zip file", ex);
        }
        return resultZip;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File generateDechargePDF(File disclamerPdf, File resultDirectory, RSufiResult rSufiResult, Locale locale) throws CoserBusinessException {
        File result = null;
        FileOutputStream os = null;
        try {
            Date updateDate = this.getLastDataUpdateDate();
            String surveyName = "";
            if (resultDirectory != null && rSufiResult != null) {
                surveyName = this.projectService.getProjectSurveyName(resultDirectory, rSufiResult);
            }
            Template mapTemplate = this.freemarkerConfiguration.getTemplate("decharge.ftl", locale);
            HashMap<String, Object> root = new HashMap<String, Object>();
            root.put("updateDate", updateDate);
            root.put("surveyName", surveyName);
            StringWriter out = new StringWriter();
            mapTemplate.process(root, (Writer)out);
            ((Writer)out).flush();
            Document document = CoserUtils.parseDocument(((Object)out).toString());
            os = new FileOutputStream(disclamerPdf);
            ITextRenderer renderer = new ITextRenderer();
            renderer.setDocument(document, null);
            renderer.layout();
            renderer.createPDF((OutputStream)os);
            ((OutputStream)os).close();
        }
        catch (IOException ex) {
            try {
                throw new CoserBusinessException("Can't generate decharge file", ex);
                catch (TemplateException ex2) {
                    throw new CoserBusinessException("Can't generate decharge file", ex2);
                }
                catch (DocumentException ex3) {
                    throw new CoserBusinessException("Can't generate decharge file", ex3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected File generateMetaFilePDF(Project project, Selection selection, File resultDirectory, RSufiResult rsufiResult, String indicator, Locale locale) throws CoserBusinessException {
        File result = null;
        HashMap<String, Integer> refTaxSpeciesNumSys = new HashMap<String, Integer>();
        HashMap<String, String> refTaxSpeciesName = new HashMap<String, String>();
        Iterator<String[]> itReftax = project.getRefTaxSpecies().iterator(true);
        while (itReftax.hasNext()) {
            String[] tuple = itReftax.next();
            String speciesCode = tuple[3];
            Integer iNumSys = Integer.valueOf(tuple[1]);
            refTaxSpeciesNumSys.put(speciesCode, iNumSys);
            String speciesSciName = StringEscapeUtils.escapeXml((String)tuple[4]);
            String speciesAuthor = StringEscapeUtils.escapeXml((String)tuple[5]);
            refTaxSpeciesName.put(speciesCode, "<span style='font-style:italic'>" + speciesSciName + "</span> " + speciesAuthor);
        }
        HashMap<String, Integer[]> specyTypes = new HashMap<String, Integer[]>();
        Iterator<String[]> itTypeSpecies = project.getTypeEspeces().iterator(true);
        while (itTypeSpecies.hasNext()) {
            String[] tuple = itTypeSpecies.next();
            String specyTypeCode = tuple[4];
            Integer iMinNumSys = Integer.valueOf(tuple[2]);
            Integer iMaxNumSys = Integer.valueOf(tuple[3]);
            specyTypes.put(specyTypeCode, new Integer[]{iMinNumSys, iMaxNumSys});
        }
        File estComIndFile = new File(resultDirectory, rsufiResult.getEstComIndName());
        HashMap indicatorMap = new HashMap();
        HashMap speciesMap = new HashMap();
        DataStorage dataStorage = this.commonService.loadCSVFile(estComIndFile, '\t');
        Iterator<String[]> estComIndIterator = dataStorage.iterator(true);
        while (estComIndIterator.hasNext()) {
            String indicatorName;
            String[] tuple = estComIndIterator.next();
            String indicatorCode = tuple[1];
            String listIdCode = tuple[2];
            String listNumber = listIdCode.substring(1);
            TreeSet<String> indicatorList = (TreeSet<String>)indicatorMap.get(listNumber);
            if (indicatorList == null) {
                indicatorList = new TreeSet<String>();
                indicatorMap.put(listNumber, indicatorList);
            }
            if ((indicatorName = this.getIndicatorValue(indicatorCode, locale.getLanguage())) == null) continue;
            indicatorList.add(indicatorName);
        }
        for (String listNumber : indicatorMap.keySet()) {
            List<String> selectionSpeciesList = null;
            if ("1".equals(listNumber)) {
                selectionSpeciesList = selection.getSelectedSpecies();
            } else if ("2".equals(listNumber)) {
                selectionSpeciesList = selection.getSelectedSpeciesOccDens();
            } else if ("3".equals(listNumber)) {
                selectionSpeciesList = selection.getSelectedSpeciesSizeAllYear();
            } else if ("4".equals(listNumber)) {
                selectionSpeciesList = selection.getSelectedSpeciesMaturity();
            }
            if (selectionSpeciesList != null) {
                TreeSet<String> speciesList = new TreeSet<String>();
                for (String speciesCode : selectionSpeciesList) {
                    String speciesName = (String)refTaxSpeciesName.get(speciesCode);
                    Integer speciesNumSys = (Integer)refTaxSpeciesNumSys.get(speciesCode);
                    for (Map.Entry speciesTypeEntry : specyTypes.entrySet()) {
                        String speciesTypeCode = (String)speciesTypeEntry.getKey();
                        Integer[] bound = (Integer[])speciesTypeEntry.getValue();
                        if (speciesNumSys < bound[0] || speciesNumSys > bound[1]) continue;
                        speciesName = "(" + speciesTypeCode + ") " + speciesName;
                        break;
                    }
                    speciesList.add(speciesName);
                }
                speciesMap.put(listNumber, speciesList);
                continue;
            }
            if (!log.isWarnEnabled()) continue;
            log.warn((Object)("Can't get species list for list id " + listNumber));
        }
        FileOutputStream os = null;
        try {
            Template mapTemplate = this.freemarkerConfiguration.getTemplate("metainfo.ftl", locale);
            HashMap root = new HashMap();
            root.put("indicatorsMap", indicatorMap);
            root.put("speciesMap", speciesMap);
            StringWriter out = new StringWriter();
            mapTemplate.process(root, (Writer)out);
            ((Writer)out).flush();
            Document document = CoserUtils.parseDocument(((Object)out).toString());
            result = File.createTempFile("coser-metainfo-", ".pdf");
            result.deleteOnExit();
            os = new FileOutputStream(result);
            ITextRenderer renderer = new ITextRenderer();
            renderer.setDocument(document, null);
            renderer.layout();
            renderer.createPDF((OutputStream)os);
            ((OutputStream)os).close();
        }
        catch (IOException ex) {
            try {
                throw new CoserBusinessException("Can't generate meta info file", ex);
                catch (TemplateException ex2) {
                    throw new CoserBusinessException("Can't generate meta info file", ex2);
                }
                catch (DocumentException ex3) {
                    throw new CoserBusinessException("Can't generate meta info file", ex3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
        return result;
    }

    public Map<String, String> getIndicatorsResultsPerZone() throws CoserBusinessException {
        return this.getResultsPerZone(this.config.getWebIndicatorsProjectsDirectory());
    }

    public Map<String, String> getMapsResultsPerZone() throws CoserBusinessException {
        return this.getResultsPerZone(this.config.getWebMapsProjectsDirectory());
    }

    protected Map<String, String> getResultsPerZone(File scanDirectory) throws CoserBusinessException {
        HashMap<String, String> resultIds = new HashMap<String, String>();
        File[] projectFiles = scanDirectory.listFiles();
        if (projectFiles != null) {
            for (File projectFile : projectFiles) {
                File selectionsDirectory;
                File[] selectionFiles;
                if (!projectFile.isDirectory() || (selectionFiles = (selectionsDirectory = new File(projectFile, "selections")).listFiles()) == null) continue;
                for (File selectionFile : selectionFiles) {
                    File resultsDirectory;
                    File[] resultFiles;
                    if (!selectionFile.isDirectory() || (resultFiles = (resultsDirectory = new File(selectionFile, "results")).listFiles()) == null) continue;
                    for (File resultFile : resultFiles) {
                        if (!resultFile.isDirectory()) continue;
                        RSufiResult rsufiResult = this.projectService.getRSufiResult(resultFile);
                        String resultResultId = rsufiResult.getZone();
                        String name = projectFile.getName() + "/" + selectionFile.getName() + "/" + resultFile.getName();
                        resultIds.put(resultResultId, name);
                    }
                }
            }
        }
        return resultIds;
    }

    public void deleteIndicatorsResult(List<String> deleteZoneId) throws CoserBusinessException {
        this.cleanCurrentProjectDirectory(this.config.getWebIndicatorsProjectsDirectory(), deleteZoneId);
    }

    public void deleteMapsResult(List<String> deleteZoneId) throws CoserBusinessException {
        this.cleanCurrentProjectDirectory(this.config.getWebMapsProjectsDirectory(), deleteZoneId);
    }

    public File extractData(List<String> zones, List<DataType> types, List<String> species, List<String> comIndicators, List<String> popIndicators, Locale locale) throws CoserBusinessException {
        File resultZip = null;
        File tempDir = null;
        try {
            tempDir = FileUtil.createTempDirectory((String)"coser-extract-", (String)"-tmp");
            File subDir = new File(tempDir, "Indicateurs_Ifremer");
            subDir.mkdirs();
            if (types.contains((Object)DataType.SOURCE)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Extracting sources");
                }
                File srcDir = new File(subDir, "sources");
                this.extractSource(zones, srcDir);
            }
            MultiKeyMap pdfMaps = null;
            if (types.contains((Object)DataType.MAP)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Extracting maps");
                }
                pdfMaps = this.extractDataMap(zones, species);
            }
            MultiKeyMap pdfCharts = null;
            if (CollectionUtils.isNotEmpty(comIndicators) || CollectionUtils.isNotEmpty(popIndicators)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Extracting charts");
                }
                pdfCharts = this.extractCharts(zones, species, comIndicators, popIndicators, locale);
            }
            if (MapUtils.isNotEmpty((Map)pdfMaps) || MapUtils.isNotEmpty(pdfCharts)) {
                this.generateExtractPDF(subDir, zones, pdfMaps, pdfCharts, locale);
            }
            String filename = null;
            filename = locale != null && "fr".equals(locale.getLanguage()) ? "DechargeDonnees.pdf" : (locale != null && "es".equals(locale.getLanguage()) ? "DatosDeExencionDeResponsabilidad.pdf" : "DataDisclaimer.pdf");
            File dechargePDF = new File(subDir, filename);
            this.generateDechargePDF(dechargePDF, null, null, locale);
            resultZip = File.createTempFile("coser-extract-", ".zip");
            resultZip.deleteOnExit();
            ZipUtil.compress((File)resultZip, (File)subDir);
            FileUtils.deleteDirectory((File)tempDir);
        }
        catch (IOException ex) {
            throw new CoserBusinessException("Can't create zip file", ex);
        }
        finally {
            FileUtils.deleteQuietly((File)tempDir);
        }
        return resultZip;
    }

    protected MultiKeyMap extractDataMap(Collection<String> zones, Collection<String> species) throws CoserBusinessException, IOException {
        MultiKeyMap mapForZoneAndSpecies = new MultiKeyMap();
        File projectsDirectory = this.config.getWebMapsProjectsDirectory();
        File[] projectFiles = projectsDirectory.listFiles();
        if (projectFiles != null) {
            for (File projectFile : projectFiles) {
                File selectionsDirectory;
                File[] selectionFiles;
                if (!projectFile.isDirectory() || (selectionFiles = (selectionsDirectory = new File(projectFile, "selections")).listFiles()) == null) continue;
                for (File selectionFile : selectionFiles) {
                    File resultsDirectory;
                    File[] resultFiles;
                    if (!selectionFile.isDirectory() || (resultFiles = (resultsDirectory = new File(selectionFile, "results")).listFiles()) == null) continue;
                    for (File resultFile : resultFiles) {
                        RSufiResult rsufiResult;
                        if (!resultFile.isDirectory() || !(rsufiResult = this.projectService.getRSufiResult(resultFile)).isMapsResult() || !zones.contains(rsufiResult.getZone())) continue;
                        Project project = this.projectService.openProject(projectFile.getName(), projectsDirectory);
                        String surveyName = this.projectService.getProjectSurveyName(resultFile, rsufiResult);
                        File mapsDirectory = new File(resultFile, "maps");
                        for (String aSpecies : species) {
                            String mapName = surveyName + "_" + aSpecies.toUpperCase() + ".png";
                            File mapFile = new File(mapsDirectory, mapName);
                            if (!mapFile.isFile()) continue;
                            String speciesName = project.getDisplaySpeciesText(aSpecies);
                            mapForZoneAndSpecies.put((Object)rsufiResult.getZone(), (Object)speciesName, (Object)mapFile);
                        }
                    }
                }
            }
        }
        return mapForZoneAndSpecies;
    }

    protected File extractSource(Collection<String> zones, File directory) throws CoserBusinessException {
        File result = null;
        File projectsDirectory = this.config.getWebIndicatorsProjectsDirectory();
        File[] projectFiles = projectsDirectory.listFiles();
        if (projectFiles != null) {
            for (File projectFile : projectFiles) {
                File selectionsDirectory;
                File[] selectionFiles;
                if (!projectFile.isDirectory() || (selectionFiles = (selectionsDirectory = new File(projectFile, "selections")).listFiles()) == null) continue;
                for (File selectionFile : selectionFiles) {
                    File resultsDirectory;
                    File[] resultFiles;
                    if (!selectionFile.isDirectory() || (resultFiles = (resultsDirectory = new File(selectionFile, "results")).listFiles()) == null) continue;
                    for (File resultFile : resultFiles) {
                        RSufiResult rsufiResult;
                        if (!resultFile.isDirectory() || !(rsufiResult = this.projectService.getRSufiResult(resultFile)).isDataAllowed() || !zones.contains(rsufiResult.getZone())) continue;
                        Project project = this.projectService.openProject(projectFile.getName(), projectsDirectory);
                        Selection selection = project.getSelections().get(selectionFile.getName());
                        this.projectService.loadSelectionData(projectsDirectory, project, selection);
                        File zoneDirectory = new File(directory, rsufiResult.getZone());
                        zoneDirectory.mkdirs();
                        this.projectService.extractRSUfiData(project, selection, zoneDirectory, true);
                    }
                }
            }
        }
        return result;
    }

    protected MultiKeyMap extractCharts(Collection<String> zones, Collection<String> species, Collection<String> comIndicators, Collection<String> popIndicators, Locale locale) throws CoserBusinessException {
        MultiKeyMap chartFileAndDatas = new MultiKeyMap();
        File projectsDirectory = this.config.getWebIndicatorsProjectsDirectory();
        File[] projectFiles = projectsDirectory.listFiles();
        if (projectFiles != null) {
            for (File projectFile : projectFiles) {
                File selectionsDirectory;
                File[] selectionFiles;
                if (!projectFile.isDirectory() || (selectionFiles = (selectionsDirectory = new File(projectFile, "selections")).listFiles()) == null) continue;
                for (File selectionFile : selectionFiles) {
                    File resultsDirectory;
                    File[] resultFiles;
                    if (!selectionFile.isDirectory() || (resultFiles = (resultsDirectory = new File(selectionFile, "results")).listFiles()) == null) continue;
                    for (File resultFile : resultFiles) {
                        RSufiResult rsufiResult;
                        if (!resultFile.isDirectory() || !zones.contains((rsufiResult = this.projectService.getRSufiResult(resultFile)).getZone())) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Extracting charts for result " + resultFile));
                        }
                        Project project = this.projectService.openProject(projectFile.getName(), projectsDirectory);
                        String zone = rsufiResult.getZone();
                        String zoneDisplayName = this.getZoneFullName(zone);
                        File codeTypeEspecesFile = new File(projectFile, CoserConstants.Category.TYPE_ESPECES.getStorageFileName());
                        if (CollectionUtils.isNotEmpty(comIndicators)) {
                            Map<String, Object[]> chartFileAndDataCom = this.publicationService.getRsufiResultComCharts(project, resultFile, rsufiResult, codeTypeEspecesFile, comIndicators, zoneDisplayName, this.getIndicatorsMap(), locale, 650, 430);
                            for (Map.Entry<String, Object[]> entry : chartFileAndDataCom.entrySet()) {
                                chartFileAndDatas.put((Object)zone, (Object)entry.getKey(), (Object)entry.getValue());
                            }
                        }
                        if (!CollectionUtils.isNotEmpty(popIndicators)) continue;
                        Map<String, Object[]> chartFileAndDataPop = this.publicationService.getRsufiResultPopCharts(project, resultFile, rsufiResult, species, popIndicators, zoneDisplayName, this.getIndicatorsMap(), locale, 650, 430);
                        for (Map.Entry<String, Object[]> entry : chartFileAndDataPop.entrySet()) {
                            chartFileAndDatas.put((Object)zone, (Object)entry.getKey(), (Object)entry.getValue());
                        }
                    }
                }
            }
        }
        return chartFileAndDatas;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void generateExtractPDF(File directory, List<String> zones, MultiKeyMap pdfMaps, MultiKeyMap pdfCharts, Locale locale) throws CoserBusinessException {
        Iterator<String> i$ = zones.iterator();
        block5: while (i$.hasNext()) {
            String zone = i$.next();
            ArrayList<File> toDelete = new ArrayList<File>();
            FileOutputStream os = null;
            try {
                String zoneId;
                StringBuilder htmlContent = new StringBuilder();
                htmlContent.append("<html><head>");
                htmlContent.append("<title>" + I18n.l((Locale)locale, (String)"coser.business.extract.extracttitle", (Object[])new Object[0]) + "</title>");
                htmlContent.append("<meta http-equiv='Content-Type' content='text/html; charset=utf-8' />");
                htmlContent.append("</head><body>");
                if (pdfMaps != null) {
                    for (Map.Entry mapEntry : pdfMaps.entrySet()) {
                        zoneId = (String)((MultiKey)mapEntry.getKey()).getKey(0);
                        if (!zoneId.equals(zone)) continue;
                        String speciesName = (String)((MultiKey)mapEntry.getKey()).getKey(1);
                        File file = (File)mapEntry.getValue();
                        String zoneName = this.getZoneFullName(zoneId);
                        htmlContent.append("<div style='page-break-after: always'>");
                        htmlContent.append("<p>" + zoneName + " - " + speciesName + "</p>");
                        htmlContent.append("<img src='file://" + file.getAbsolutePath() + "' />");
                        htmlContent.append("</div>");
                    }
                }
                if (pdfCharts != null) {
                    for (Map.Entry chartFileAndData : pdfCharts.entrySet()) {
                        zoneId = (String)((MultiKey)chartFileAndData.getKey()).getKey(0);
                        if (!zoneId.equals(zone)) continue;
                        File chartFile = (File)((Object[])chartFileAndData.getValue())[0];
                        String content = (String)((Object[])chartFileAndData.getValue())[1];
                        htmlContent.append("<div style='page-break-after: always'>");
                        htmlContent.append("<img src='file://" + chartFile.getAbsolutePath() + "' />");
                        htmlContent.append("<br />");
                        htmlContent.append(I18n.l((Locale)locale, (String)"coser.business.extract.extractdata", (Object[])new Object[0]) + " :");
                        htmlContent.append("<pre>").append(content).append("</pre>");
                        htmlContent.append("</div>");
                        toDelete.add(chartFile);
                    }
                }
                htmlContent.append("</body></html>");
                Document document = CoserUtils.parseDocument(htmlContent.toString());
                String zoneDisplay = this.getZoneFullName(zone);
                zoneDisplay = StringUtils.stripAccents((String)zoneDisplay);
                zoneDisplay = zoneDisplay.replaceAll("[^\\w- ]", "_");
                File pdfFile = new File(directory, zoneDisplay + ".pdf");
                os = new FileOutputStream(pdfFile);
                ITextRenderer renderer = new ITextRenderer();
                renderer.setDocument(document, null);
                renderer.layout();
                renderer.createPDF((OutputStream)os);
                ((OutputStream)os).close();
            }
            catch (IOException ex) {
                try {
                    throw new CoserBusinessException("Can't generate log pdf", ex);
                    catch (DocumentException ex2) {
                        throw new CoserBusinessException("Can't generate log pdf", ex2);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(os);
                    Iterator i$2 = toDelete.iterator();
                    while (true) {
                        if (!i$2.hasNext()) {
                            throw throwable;
                        }
                        File file = (File)i$2.next();
                        file.delete();
                    }
                }
            }
            IOUtils.closeQuietly((OutputStream)os);
            Iterator i$3 = toDelete.iterator();
            while (true) {
                if (!i$3.hasNext()) continue block5;
                File file = (File)i$3.next();
                file.delete();
            }
            break;
        }
        return;
    }

    protected class OneResultFileFilter
    implements FileFilter {
        protected File projectsDirectory;
        protected Project project;
        protected Selection selection;
        protected RSufiResult rsufi;
        protected boolean exportWithData;

        public OneResultFileFilter(File projectsDirectory, Project project, Selection selection, RSufiResult rsufi, boolean exportWithData) {
            this.projectsDirectory = projectsDirectory;
            this.project = project;
            this.selection = selection;
            this.rsufi = rsufi;
            this.exportWithData = exportWithData;
        }

        @Override
        public boolean accept(File pathname) {
            boolean result = false;
            try {
                String currentPathName = pathname.getCanonicalPath() + File.separator;
                File projectDirectory = new File(this.projectsDirectory, this.project.getName());
                File selectionsDirectory = new File(projectDirectory, "selections");
                File selectionDirectory = new File(selectionsDirectory, this.selection.getName());
                File resultsDirectory = new File(selectionDirectory, "results");
                File resultDirectory = new File(resultsDirectory, this.rsufi.getName());
                String projectPath = projectDirectory.getCanonicalPath() + File.separator;
                String selectionsPath = selectionsDirectory.getCanonicalPath() + File.separator;
                String selectionPath = selectionDirectory.getCanonicalPath() + File.separator;
                String resultsPath = resultsDirectory.getCanonicalPath() + File.separator;
                String resultPath = resultDirectory.getCanonicalPath() + File.separator;
                boolean bl = result = currentPathName.startsWith(projectPath) && !currentPathName.startsWith(selectionsPath) || currentPathName.startsWith(selectionPath) && !currentPathName.startsWith(resultsPath) || currentPathName.startsWith(resultPath);
                if (!this.exportWithData) {
                    String fileName = pathname.getName();
                    for (CoserConstants.Category category : CoserConstants.Category.values()) {
                        if (!category.isDataCategory()) continue;
                        String sourceFileName = WebService.this.commonService.getDataStorageFileName(this.project, category, null);
                        Matcher matcher = CoserUtils.FILENAME_SUFFIX_PATTERN.matcher(sourceFileName);
                        if (matcher.matches()) {
                            result &= !fileName.startsWith(matcher.group(1)) || !fileName.endsWith(matcher.group(2));
                            continue;
                        }
                        result &= !fileName.startsWith(sourceFileName);
                    }
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("Can't get system canonical path");
            }
            return result;
        }
    }

    protected static class MultipleFileFilter
    implements FileFilter {
        protected Collection<FileFilter> fileFilters = new ArrayList<FileFilter>();

        protected MultipleFileFilter() {
        }

        public void add(FileFilter f) {
            this.fileFilters.add(f);
        }

        @Override
        public boolean accept(File pathname) {
            boolean result = false;
            Iterator<FileFilter> it = this.fileFilters.iterator();
            while (it.hasNext() && !result) {
                result = it.next().accept(pathname);
            }
            return result;
        }
    }
}

