/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.services;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.coser.CoserBusinessConfig;
import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.CoserTechnicalException;
import fr.ifremer.coser.bean.EchoBaseProject;
import fr.ifremer.coser.bean.GlobalResult;
import fr.ifremer.coser.bean.Project;
import fr.ifremer.coser.bean.RSufiResult;
import fr.ifremer.coser.bean.RSufiResultPath;
import fr.ifremer.coser.bean.Selection;
import fr.ifremer.coser.services.ProjectService;
import fr.ifremer.coser.util.InputStreamKnownSizeBody;
import fr.ifremer.coser.util.ProgressMonitor;
import fr.ifremer.coser.util.ProgressStream;
import fr.ifremer.coser.util.io.MultipleFileFilter;
import fr.ifremer.coser.util.io.OneEchobaseFileFilter;
import fr.ifremer.coser.util.io.OneRSufiResultFileFilter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Consts;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.impl.client.HttpClientBuilder;
import org.nuiton.i18n.I18n;
import org.nuiton.util.FileUtil;
import org.nuiton.util.StringUtil;
import org.nuiton.util.ZipUtil;

public class ClientResultService {
    private static final Log log = LogFactory.getLog(ClientResultService.class);
    protected CoserBusinessConfig config;
    protected ProjectService projectService;

    public ClientResultService(CoserBusinessConfig config) {
        this.config = config;
        this.projectService = new ProjectService(config);
    }

    public List<GlobalResult> findAllProjectWithResult(Date beginDate, Date endDate, boolean onlyPubliableResult) throws CoserBusinessException {
        File echoBaseProjectsDirectory;
        File[] echoBaseProjects;
        ArrayList results = Lists.newArrayList();
        File rsufiProjectsDirectory = this.config.getRSufiProjectsDirectory();
        File[] rsufiProjects = rsufiProjectsDirectory.listFiles();
        if (rsufiProjects != null) {
            for (File existingProject : rsufiProjects) {
                if (!existingProject.isDirectory()) continue;
                Collection<GlobalResult> rsufiResults = this.getRsufiResults(existingProject, beginDate, endDate, onlyPubliableResult);
                results.addAll(rsufiResults);
            }
        }
        if ((echoBaseProjects = (echoBaseProjectsDirectory = this.config.getEchoBaseProjectsDirectory()).listFiles()) != null) {
            for (File existingProject : echoBaseProjects) {
                if (!existingProject.isDirectory()) continue;
                Collection<GlobalResult> echoBaseResults = this.getEchoBaseResults(existingProject, beginDate, endDate, onlyPubliableResult);
                results.addAll(echoBaseResults);
            }
        }
        return results;
    }

    public String performResultUpload(Collection<GlobalResult> selectedResults, Collection<GlobalResult> indicatorsResults, Collection<GlobalResult> mapResults, Collection<GlobalResult> publishDataResults, String login, String password, ProgressMonitor progress) throws CoserBusinessException {
        progress.setCurrent(0);
        progress.setText(I18n.t((String)"coser.business.uploadresult.modifyResultOptions", (Object[])new Object[0]));
        this.modifyRSufiResults(selectedResults, indicatorsResults, mapResults, publishDataResults);
        progress.setText(I18n.t((String)"coser.business.uploadresult.checkcollision", (Object[])new Object[0]));
        this.checkDataCollision(selectedResults);
        progress.setText(I18n.t((String)"coser.business.uploadresult.preparezip", (Object[])new Object[0]));
        File prepareZip = this.performResultExtract(selectedResults, publishDataResults, null);
        progress.setText(I18n.t((String)"coser.business.uploadresult.sendzip", (Object[])new Object[0]));
        progress.setTotal((int)prepareZip.length());
        try {
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            multipartEntityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            multipartEntityBuilder.setCharset(Consts.UTF_8);
            multipartEntityBuilder.addBinaryBody("login", login.getBytes());
            String sha1password = StringUtil.encodeSHA1((String)password);
            multipartEntityBuilder.addBinaryBody("sha1Password", sha1password.getBytes());
            ProgressStream stream = new ProgressStream(new FileInputStream(prepareZip), progress);
            InputStreamKnownSizeBody fileBody = new InputStreamKnownSizeBody(stream, prepareZip.length(), "application/zip", prepareZip.getName());
            multipartEntityBuilder.addPart("resultFile", (ContentBody)fileBody);
            HttpPost httppost = new HttpPost(this.config.getWebUploadURL());
            httppost.setEntity(multipartEntityBuilder.build());
            if (log.isInfoEnabled()) {
                log.info((Object)("Uploading " + prepareZip + " to " + httppost.getURI()));
            }
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            CloseableHttpResponse response = httpClientBuilder.build().execute((HttpUriRequest)httppost);
            String uploadStatus = null;
            if (response.getStatusLine().getStatusCode() != 200) {
                uploadStatus = response.getStatusLine().getReasonPhrase();
            }
            FileUtils.forceDelete((File)prepareZip);
            return uploadStatus;
        }
        catch (ClientProtocolException ex) {
            throw new CoserBusinessException("Can't upload file", ex);
        }
        catch (IOException ex) {
            throw new CoserBusinessException("Can't upload file", ex);
        }
    }

    protected Collection<GlobalResult> getEchoBaseResults(File existingProject, Date beginDate, Date endDate, boolean onlyPubliableResult) {
        EchoBaseProject echoBaseProject = new EchoBaseProject(existingProject);
        try {
            echoBaseProject.load();
        }
        catch (IOException e) {
            throw new CoserTechnicalException("Could not load echobase project", e);
        }
        GlobalResult result = new GlobalResult(echoBaseProject);
        boolean candidate = this.isCandidateResult(result, beginDate, endDate, onlyPubliableResult);
        ArrayList results = Lists.newArrayList();
        if (candidate) {
            results.add(result);
        }
        return results;
    }

    protected Collection<GlobalResult> getRsufiResults(File existingProject, Date beginDate, Date endDate, boolean onlyPubliableResult) {
        ArrayList results = Lists.newArrayList();
        String projectName = existingProject.getName();
        Project p = new Project(projectName);
        File selectionsDirectory = new File(existingProject, "selections");
        File[] selections = selectionsDirectory.listFiles();
        if (selections != null) {
            for (File existingSelection : selections) {
                if (!existingSelection.isDirectory()) continue;
                String selectionName = existingSelection.getName();
                Selection s = new Selection(selectionName);
                File rsufisDirectory = new File(existingSelection, "results");
                File[] rSufiResults = rsufisDirectory.listFiles();
                if (rSufiResults == null) continue;
                for (File rSufiResult : rSufiResults) {
                    RSufiResult r;
                    if (!rSufiResult.isDirectory()) continue;
                    try {
                        r = this.projectService.getRSufiResult(rSufiResult);
                    }
                    catch (CoserBusinessException e) {
                        throw new CoserTechnicalException("Could not load rsufi result", e);
                    }
                    RSufiResultPath path = new RSufiResultPath(p, s, r);
                    GlobalResult result = new GlobalResult(path);
                    boolean candidate = this.isCandidateResult(result, beginDate, endDate, onlyPubliableResult);
                    if (!candidate) continue;
                    results.add(result);
                }
            }
        }
        return results;
    }

    protected boolean isCandidateResult(GlobalResult rsufiResult, Date beginDate, Date endDate, boolean onlyPubliableResult) {
        boolean result = true;
        if (beginDate != null) {
            boolean bl = result = rsufiResult.getCreationDate().compareTo(beginDate) >= 0;
        }
        if (endDate != null) {
            result &= rsufiResult.getCreationDate().compareTo(endDate) <= 0;
        }
        if (onlyPubliableResult) {
            result &= rsufiResult.isPubliableResult();
        }
        return result;
    }

    protected void modifyRSufiResults(Collection<GlobalResult> selectedResults, Collection<GlobalResult> indicatorsResults, Collection<GlobalResult> mapResults, Collection<GlobalResult> publishDataResults) {
        for (GlobalResult selectedResult : selectedResults) {
            selectedResult.setIndicatorsResult(false);
            selectedResult.setMapsResult(false);
            selectedResult.setDataAllowed(false);
        }
        for (GlobalResult indicatorsResult : indicatorsResults) {
            indicatorsResult.setIndicatorsResult(true);
        }
        for (GlobalResult mapResult : mapResults) {
            mapResult.setMapsResult(true);
        }
        for (GlobalResult publishDataResult : publishDataResults) {
            publishDataResult.setDataAllowed(true);
        }
        for (GlobalResult selectedGlobalResult : selectedResults) {
            Serializable selectedResult;
            if (selectedGlobalResult.isRsufi()) {
                selectedResult = selectedGlobalResult.getRsufiProject();
                Project project = ((RSufiResultPath)selectedResult).getProject();
                Selection selection = ((RSufiResultPath)selectedResult).getSelection();
                RSufiResult rsufiResult = ((RSufiResultPath)selectedResult).getRsufiResult();
                File projectDirectory = new File(this.config.getRSufiProjectsDirectory(), project.getName());
                File selectionsDirectory = new File(projectDirectory, "selections");
                File selectionDirectory = new File(selectionsDirectory, selection.getName());
                File resultsDirectory = new File(selectionDirectory, "results");
                File resultDirectory = new File(resultsDirectory, rsufiResult.getName());
                try {
                    this.projectService.saveRSufiResult(resultDirectory, rsufiResult);
                    continue;
                }
                catch (CoserBusinessException e) {
                    throw new CoserTechnicalException("Could not save rsufi results", e);
                }
            }
            selectedResult = selectedGlobalResult.getEchobaseProject();
            try {
                ((EchoBaseProject)selectedResult).save();
            }
            catch (IOException e) {
                throw new CoserTechnicalException("Could not save echobaseProject", e);
            }
        }
    }

    protected void checkDataCollision(Collection<GlobalResult> selectedResults) {
        ArrayList resultZoneTypeIds = Lists.newArrayList();
        for (GlobalResult selectedResult : selectedResults) {
            String resultZoneTypeId;
            if (selectedResult.isRsufi()) {
                RSufiResult rsufiResult = selectedResult.getRsufiProject().getRsufiResult();
                resultZoneTypeId = rsufiResult.getZone() + String.valueOf(rsufiResult.isMapsResult());
            } else {
                EchoBaseProject echobaseProject = selectedResult.getEchobaseProject();
                resultZoneTypeId = echobaseProject.getZoneName() + String.valueOf(true);
            }
            if (resultZoneTypeIds.contains(resultZoneTypeId)) {
                throw new CoserTechnicalException(I18n.t((String)"coser.business.resultupload.duplicatedresult2", (Object[])new Object[]{selectedResult.getName(), selectedResult.getZone()}));
            }
            resultZoneTypeIds.add(resultZoneTypeId);
        }
    }

    public File performResultExtract(Collection<GlobalResult> selectedResults, Collection<GlobalResult> publishDataResults, File extractDirectory) {
        File result;
        try {
            if (extractDirectory == null) {
                result = File.createTempFile("Coserextract-", ".zip");
            } else {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
                String zipName = "Coserextract" + dateFormat.format(new Date()) + ".zip";
                result = new File(extractDirectory, zipName);
            }
            File tempExtractDirectory = FileUtil.createTempDirectory((String)"CoserExtractTemp", (String)"dummy");
            this.performResultExtractForRSufi(tempExtractDirectory, selectedResults, publishDataResults);
            this.performResultExtractForEchoBase(tempExtractDirectory, selectedResults, publishDataResults);
            List files = FileUtil.getFilteredElements((File)tempExtractDirectory, (FileFilter)FileFilterUtils.trueFileFilter(), (boolean)true);
            ZipUtil.compressFiles((File)result, (File)tempExtractDirectory, (Collection)files, (boolean)false);
            FileUtils.deleteDirectory((File)tempExtractDirectory);
        }
        catch (IOException e) {
            throw new CoserTechnicalException("Can't prepare upload data", e);
        }
        return result;
    }

    protected void performResultExtractForRSufi(File extractDirectory, Collection<GlobalResult> selectedResults, Collection<GlobalResult> publishDataResults) {
        Preconditions.checkNotNull((Object)extractDirectory);
        try {
            File projectsDirectory = this.config.getRSufiProjectsDirectory();
            File rsufiDirectory = new File(extractDirectory, "rsufi");
            FileUtils.forceMkdir((File)rsufiDirectory);
            MultipleFileFilter mFileFilters = new MultipleFileFilter();
            for (GlobalResult globalProject : selectedResults) {
                if (!globalProject.isRsufi()) continue;
                RSufiResultPath path = globalProject.getRsufiProject();
                Project project = path.getProject();
                project = this.projectService.openProject(project.getName());
                OneRSufiResultFileFilter oneRFF = new OneRSufiResultFileFilter(projectsDirectory, project, path.getSelection(), path.getRsufiResult(), publishDataResults.contains(globalProject));
                mFileFilters.add(oneRFF);
            }
            List files = FileUtil.getFilteredElements((File)projectsDirectory, (FileFilter)mFileFilters, (boolean)true);
            File tempZip = File.createTempFile("Coserextractrsufi-", ".zip");
            ZipUtil.compressFiles((File)tempZip, (File)projectsDirectory, (Collection)files, (boolean)false);
            ZipUtil.uncompress((File)tempZip, (File)rsufiDirectory);
            FileUtils.forceDelete((File)tempZip);
        }
        catch (CoserBusinessException e) {
            throw new CoserTechnicalException("Can't prepare upload data", e);
        }
        catch (IOException e) {
            throw new CoserTechnicalException("Can't prepare upload data", e);
        }
    }

    protected void performResultExtractForEchoBase(File extractDirectory, Collection<GlobalResult> selectedResults, Collection<GlobalResult> publishDataResults) {
        Preconditions.checkNotNull((Object)extractDirectory);
        try {
            File projectsDirectory = this.config.getEchoBaseProjectsDirectory();
            File echobaseDirectory = new File(extractDirectory, "echobase");
            FileUtils.forceMkdir((File)echobaseDirectory);
            MultipleFileFilter mFileFilters = new MultipleFileFilter();
            for (GlobalResult globalProject : selectedResults) {
                if (!globalProject.isEchoBase()) continue;
                EchoBaseProject echobaseProject = globalProject.getEchobaseProject();
                OneEchobaseFileFilter fileFilter = new OneEchobaseFileFilter(echobaseProject, publishDataResults.contains(globalProject));
                mFileFilters.add(fileFilter);
            }
            FileUtils.copyDirectory((File)projectsDirectory, (File)echobaseDirectory, (FileFilter)mFileFilters);
        }
        catch (IOException e) {
            throw new CoserTechnicalException("Can't prepare upload data", e);
        }
    }
}

