/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.result.util;

import com.google.common.base.Preconditions;
import fr.ifremer.coser.CoserTechnicalException;
import fr.ifremer.coser.bean.IndicatorMap;
import fr.ifremer.coser.storage.DataStorageWalker;
import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StatisticalLineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.DefaultStatisticalCategoryDataset;
import org.nuiton.i18n.I18n;

public class Charts {
    public File generateChartFile(String prefix, JFreeChart chart, int width, int height) {
        try {
            File file = File.createTempFile(prefix, ".png");
            file.deleteOnExit();
            ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)chart, (int)width, (int)height);
            return file;
        }
        catch (IOException ex) {
            throw new CoserTechnicalException("Can't save chart", ex);
        }
    }

    public String getYearChartTitle(Locale locale) {
        Preconditions.checkNotNull((Object)locale);
        String yearAxis = I18n.l((Locale)locale, (String)"coser.business.year", (Object[])new Object[0]);
        return yearAxis;
    }

    public JFreeChart generateCommunityChart(Locale locale, ExtractGraphDataWalker walker, IndicatorMap indicatorMap, String indicator, String chartTitle) {
        String indicatorName = indicatorMap.getIndicatorValue(locale, indicator);
        int multiplicator = walker.getMultiplicator();
        int minYear = walker.getMinYear();
        int maxYear = walker.getMaxYear();
        Map<Integer, Double[]> graphData = walker.getGraphData();
        DefaultStatisticalCategoryDataset statisticalDataset = new DefaultStatisticalCategoryDataset();
        for (int indexYear = minYear; indexYear <= maxYear; ++indexYear) {
            Double[] entry = graphData.get(indexYear);
            if (entry != null) {
                Double estimation = entry[0] / (double)multiplicator;
                Double ecart = entry[1] / (double)multiplicator;
                statisticalDataset.add((Number)estimation, (Number)ecart, (Comparable)((Object)"Serie1"), (Comparable)Integer.valueOf(indexYear));
                continue;
            }
            statisticalDataset.add(null, null, (Comparable)((Object)"Serie1"), (Comparable)Integer.valueOf(indexYear));
        }
        String yearAxis = this.getYearChartTitle(locale);
        CategoryAxis categoryAxis = new CategoryAxis(yearAxis);
        categoryAxis.setCategoryMargin(0.0);
        categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        String unit = indicatorMap.getIndicatorUnit(indicator);
        String legendY = indicatorName;
        if (multiplicator != 1) {
            legendY = legendY + " (" + unit + "*" + multiplicator + ")";
        } else if (StringUtils.isNotEmpty((CharSequence)unit)) {
            legendY = legendY + " (" + unit + ")";
        }
        NumberAxis valueAxis = new NumberAxis(legendY);
        valueAxis.setUpperMargin(0.1);
        StatisticalLineAndShapeRenderer renderer = new StatisticalLineAndShapeRenderer(false, true);
        CategoryPlot plot = new CategoryPlot((CategoryDataset)statisticalDataset, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(PlotOrientation.VERTICAL);
        JFreeChart chart = new JFreeChart(chartTitle, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        chart.removeLegend();
        chart.setBackgroundPaint((Paint)Color.WHITE);
        return chart;
    }

    public JFreeChart generatePopulationChart(Locale locale, ExtractGraphDataWalker walker, IndicatorMap indicatorMap, String indicator, String title) {
        if (!walker.isIndicatorFound()) {
            return null;
        }
        int multiplicator = walker.getMultiplicator();
        int minYear = walker.getMinYear();
        int maxYear = walker.getMaxYear();
        Map<Integer, Double[]> graphData = walker.getGraphData();
        String indicatorName = indicatorMap.getIndicatorValue(locale, indicator);
        DefaultStatisticalCategoryDataset statisticalDataset = new DefaultStatisticalCategoryDataset();
        for (int indexYear = minYear; indexYear <= maxYear; ++indexYear) {
            Double[] entry = graphData.get(indexYear);
            if (entry != null) {
                Double estimation = entry[0] / (double)multiplicator;
                Double ecart = entry[1] / (double)multiplicator;
                statisticalDataset.add((Number)estimation, (Number)ecart, (Comparable)((Object)"Serie1"), (Comparable)Integer.valueOf(indexYear));
                continue;
            }
            statisticalDataset.add(null, null, (Comparable)((Object)"Serie1"), (Comparable)Integer.valueOf(indexYear));
        }
        String yearAxis = this.getYearChartTitle(locale);
        CategoryAxis categoryAxis = new CategoryAxis(yearAxis);
        categoryAxis.setCategoryMargin(0.0);
        categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        String unit = indicatorMap.getIndicatorUnit(indicator);
        String legendY = indicatorName;
        if (multiplicator != 1) {
            legendY = legendY + " (" + unit + "*" + multiplicator + ")";
        } else if (StringUtils.isNotEmpty((CharSequence)unit)) {
            legendY = legendY + " (" + unit + ")";
        }
        NumberAxis valueAxis = new NumberAxis(legendY);
        valueAxis.setUpperMargin(0.1);
        StatisticalLineAndShapeRenderer renderer = new StatisticalLineAndShapeRenderer(false, true);
        CategoryPlot plot = new CategoryPlot((CategoryDataset)statisticalDataset, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(PlotOrientation.VERTICAL);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        chart.removeLegend();
        chart.setBackgroundPaint((Paint)Color.WHITE);
        return chart;
    }

    public static abstract class ExtractGraphDataWalker
    implements DataStorageWalker {
        int multiplicator = 1;
        int minYear = Integer.MAX_VALUE;
        int maxYear = Integer.MIN_VALUE;
        boolean indicatorFound = false;
        Map<Integer, Double[]> graphData = new HashMap<Integer, Double[]>();

        protected abstract String getEstimationData(String ... var1);

        protected abstract String getEcartData(String ... var1);

        protected abstract String getYearData(String ... var1);

        @Override
        public void onRow(String ... tuple) {
            this.indicatorFound = true;
            Double estimation = Double.parseDouble(this.getEstimationData(tuple));
            Double ecart = Double.parseDouble(this.getEcartData(tuple));
            int year = Integer.parseInt(this.getYearData(tuple));
            if (year < this.minYear) {
                this.minYear = year;
            }
            if (year > this.maxYear) {
                this.maxYear = year;
            }
            this.graphData.put(year, new Double[]{estimation, ecart});
            if (estimation > 1.0E9) {
                this.multiplicator = 1000000;
            }
            if (estimation > 1000000.0 && this.multiplicator < 1000000) {
                this.multiplicator = 1000;
            }
        }

        public int getMultiplicator() {
            return this.multiplicator;
        }

        public int getMinYear() {
            return this.minYear;
        }

        public int getMaxYear() {
            return this.maxYear;
        }

        public boolean isIndicatorFound() {
            return this.indicatorFound;
        }

        public Map<Integer, Double[]> getGraphData() {
            return this.graphData;
        }
    }
}

