/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.result.request;

import com.google.common.base.Preconditions;
import fr.ifremer.coser.result.CoserRequest;
import fr.ifremer.coser.result.request.CoserRequestExtractTypeListAware;
import fr.ifremer.coser.result.request.CoserRequestZoneListAware;
import fr.ifremer.coser.util.DataType;
import java.io.File;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class ExtractRawDataAndResultsRequest
implements CoserRequest,
CoserRequestZoneListAware,
CoserRequestExtractTypeListAware {
    private static final long serialVersionUID = 1L;
    protected List<String> zoneList;
    protected List<String> populationIndicatorList;
    protected List<String> communityIndicatorList;
    protected List<String> speciesList;
    protected List<DataType> extractTypeList;
    protected File extractDirectory;

    @Override
    public boolean isFilled() {
        boolean filled;
        boolean bl = filled = CollectionUtils.isNotEmpty(this.extractTypeList) && CollectionUtils.isNotEmpty(this.zoneList);
        if (filled && DataType.isNeedSpecies(this.extractTypeList)) {
            filled = CollectionUtils.isNotEmpty(this.speciesList);
        }
        if (filled && this.extractTypeList.contains((Object)DataType.COMMUNITY)) {
            filled = CollectionUtils.isNotEmpty(this.communityIndicatorList);
        }
        if (filled && this.extractTypeList.contains((Object)DataType.POPULATION)) {
            filled = CollectionUtils.isNotEmpty(this.populationIndicatorList);
        }
        return filled;
    }

    @Override
    public List<DataType> getExtractTypeList() {
        return this.extractTypeList;
    }

    @Override
    public void setExtractTypeList(List<DataType> extractTypeSet) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(extractTypeSet));
        this.extractTypeList = extractTypeSet;
    }

    @Override
    public List<String> getZoneList() {
        return this.zoneList;
    }

    @Override
    public void setZoneList(List<String> zoneList) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(zoneList));
        this.zoneList = zoneList;
    }

    public List<String> getPopulationIndicatorList() {
        return this.populationIndicatorList;
    }

    public void setPopulationIndicatorList(List<String> populationIndicatorList) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(populationIndicatorList));
        this.populationIndicatorList = populationIndicatorList;
    }

    public List<String> getCommunityIndicatorList() {
        return this.communityIndicatorList;
    }

    public void setCommunityIndicatorList(List<String> communityIndicatorList) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(communityIndicatorList));
        this.communityIndicatorList = communityIndicatorList;
    }

    public List<String> getSpeciesList() {
        return this.speciesList;
    }

    public void setSpeciesList(List<String> speciesList) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(speciesList));
        this.speciesList = speciesList;
    }

    public void setExtractDirectory(File extractDirectory) {
        this.extractDirectory = extractDirectory;
    }

    public File getExtractDirectory() {
        return this.extractDirectory;
    }
}

