/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.result.repository.legacy.command;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import fr.ifremer.coser.result.repository.legacy.LegacyPredicates;
import fr.ifremer.coser.result.repository.legacy.command.AbstractLegacyCommand;
import fr.ifremer.coser.result.request.GetPopulationIndicatorResultDataRequest;
import fr.ifremer.coser.result.result.FileResult;
import fr.ifremer.coser.storage.DataStorage;
import fr.ifremer.coser.storage.DataStorages;
import java.io.File;

public class GetPopulationIndicatorResultDataCommand
extends AbstractLegacyCommand<GetPopulationIndicatorResultDataRequest> {
    @Override
    public boolean accept(GetPopulationIndicatorResultDataRequest request) {
        boolean result;
        boolean bl = result = this.repository.isIndicatorsResult() && this.repository.matchFacade(request) && this.repository.matchZone(request);
        if (result) {
            Predicate<String[]> predicate = this.createPredicate(request);
            result = this.repository.matchPopulation(predicate);
        }
        return result;
    }

    public FileResult execute(GetPopulationIndicatorResultDataRequest request) {
        Predicate<String[]> predicate = this.createPredicate(request);
        DataStorage dataStorage = this.extractPopulation(predicate);
        File file = DataStorages.save(dataStorage, "coser-chart-population-indicator", ".csv");
        FileResult result = this.newFileResult(file);
        return result;
    }

    protected Predicate<String[]> createPredicate(GetPopulationIndicatorResultDataRequest request) {
        return Predicates.and(LegacyPredicates.populationSpeciesPredicate(request.getSpecies()), LegacyPredicates.populationIndicatorPredicate(request.getIndicator()));
    }
}

