/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.result.repository.legacy.command;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import fr.ifremer.coser.CoserTechnicalException;
import fr.ifremer.coser.result.repository.legacy.LegacyPredicates;
import fr.ifremer.coser.result.repository.legacy.command.AbstractLegacyCommand;
import fr.ifremer.coser.result.request.GetCommunityIndicatorResultDataRequest;
import fr.ifremer.coser.result.result.FileResult;
import fr.ifremer.coser.storage.DataStorage;
import fr.ifremer.coser.storage.DataStorages;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.nuiton.util.FileUtil;
import org.nuiton.util.ZipUtil;

public class GetCommunityIndicatorResultDataCommand
extends AbstractLegacyCommand<GetCommunityIndicatorResultDataRequest> {
    @Override
    public boolean accept(GetCommunityIndicatorResultDataRequest request) {
        boolean result;
        boolean bl = result = this.repository.isIndicatorsResult() && this.repository.matchFacade(request) && this.repository.matchZone(request);
        if (result) {
            Predicate<String[]> predicate = this.createPredicate(request);
            result = this.repository.matchCommunity(predicate);
        }
        return result;
    }

    public FileResult execute(GetCommunityIndicatorResultDataRequest request) {
        Predicate<String[]> predicate = this.createPredicate(request);
        File file = this.getCommunityIndicatorDataFile(predicate, request.getIndicator());
        FileResult result = this.newFileResult(file);
        return result;
    }

    protected File getCommunityIndicatorDataFile(Predicate<String[]> predicate, String indicator) {
        try {
            File tempDir = FileUtil.createTempDirectory((String)"coser-chart-community-indicator", (String)"-tmp");
            File baseDir = new File(tempDir, this.repository.getSurveyName());
            FileUtils.forceMkdir((File)baseDir);
            DataStorage dataStorage = this.extractCommunity(predicate);
            File csvFile = DataStorages.save(dataStorage, "coser-chart-community-indicator", ".csv");
            File csvFileCopied = new File(baseDir, indicator + ".csv");
            FileUtils.copyFile((File)csvFile, (File)csvFileCopied);
            FileUtils.forceDelete((File)csvFile);
            File metaFile = this.getReports().generateMetaFilePDF(this.repository.getPath(), this.repository.getResultDirectory(), this.getLocale(), this.getIndicatorsMap());
            File metaFileCopied = new File(baseDir, "Information.pdf");
            FileUtils.copyFile((File)metaFile, (File)metaFileCopied);
            File result = File.createTempFile("coser-chart-community-indicator", ".zip");
            result.deleteOnExit();
            ZipUtil.compress((File)result, (File)baseDir);
            FileUtils.deleteDirectory((File)tempDir);
            return result;
        }
        catch (Exception e) {
            throw new CoserTechnicalException("Can't create zip file", e);
        }
    }

    protected Predicate<String[]> createPredicate(GetCommunityIndicatorResultDataRequest request) {
        return Predicates.and(LegacyPredicates.communityIndicatorPredicate(request.getIndicator()), LegacyPredicates.communitySpeciesListPredicate(request.getSpecies()));
    }
}

