/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.result.repository.echobase.command;

import fr.ifremer.coser.CoserTechnicalException;
import fr.ifremer.coser.result.repository.echobase.command.AbstractEchoBaseCommand;
import fr.ifremer.coser.result.request.ExtractRawDataRequest;
import fr.ifremer.coser.result.result.FileResult;
import fr.ifremer.coser.result.util.Reports;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.nuiton.util.FileUtil;
import org.nuiton.util.ZipUtil;

public class ExtractRawDataCommand
extends AbstractEchoBaseCommand<ExtractRawDataRequest> {
    @Override
    public boolean accept(ExtractRawDataRequest request) {
        return this.repository.matchFacade(request) && this.repository.matchZone(request);
    }

    public FileResult execute(ExtractRawDataRequest r) {
        File resultZip;
        Locale locale = this.getLocale();
        try {
            File tempDir = FileUtil.createTempDirectory((String)"coser-source-", (String)"-tmp");
            File archiveDir = new File(tempDir, "ECHOBASE_" + this.repository.getProject().getName());
            this.extractRawData(archiveDir);
            String filename = Reports.getDechargeFilename(locale);
            File dechargePDF = new File(archiveDir, filename);
            Date lastDataUpdateDate = this.getConfig().getLastDataUpdateDate();
            this.getReports().generateDechargePDF(dechargePDF, locale, lastDataUpdateDate, this.repository.getSurveyName());
            File reftaxFile = this.repository.getProject().getSpeciesDefinitionFile();
            FileUtils.copyFileToDirectory((File)reftaxFile, (File)archiveDir);
            resultZip = File.createTempFile("coser-source-", ".zip");
            resultZip.deleteOnExit();
            ZipUtil.compress((File)resultZip, (File)archiveDir);
            FileUtils.deleteDirectory((File)tempDir);
        }
        catch (IOException e) {
            throw new CoserTechnicalException("Can't create zip file", e);
        }
        FileResult result = this.newFileResult(resultZip);
        return result;
    }
}

