/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.result;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.coser.CoserApplicationContext;
import fr.ifremer.coser.CoserTechnicalException;
import fr.ifremer.coser.result.CoserCommand;
import fr.ifremer.coser.result.CoserCommandFactory;
import fr.ifremer.coser.result.CoserMainRepositoryProvider;
import fr.ifremer.coser.result.CoserRequest;
import fr.ifremer.coser.result.CoserRequestContext;
import fr.ifremer.coser.result.CoserResult;
import fr.ifremer.coser.result.DuplicatedResultException;
import fr.ifremer.coser.result.NoResultFoundException;
import fr.ifremer.coser.result.NoResultRepositoryFoundException;
import fr.ifremer.coser.result.repository.ResultRepository;
import fr.ifremer.coser.result.request.DeleteResultsRequest;
import fr.ifremer.coser.result.request.ExtractRawDataAndResultsRequest;
import fr.ifremer.coser.result.result.FileResult;
import fr.ifremer.coser.result.result.MapResult;
import fr.ifremer.coser.result.result.VoidResult;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;

public class CoserRequestExecutor {
    protected final CoserMainRepositoryProvider repositoryProvider;
    protected final CoserCommandFactory commandFactory;
    protected FileResult fileResult;
    protected List<CoserResult> multipleResults;
    protected MapResult mapResult;
    protected VoidResult voidResult;
    protected List<ResultRepository> matchingRepositories;

    public CoserRequestExecutor(CoserApplicationContext applicationContext, CoserMainRepositoryProvider repositoryProvider) {
        Preconditions.checkNotNull((Object)applicationContext);
        Preconditions.checkNotNull((Object)repositoryProvider);
        this.commandFactory = applicationContext.getCommandFactory();
        this.repositoryProvider = repositoryProvider;
    }

    public FileResult executeUnique(CoserRequestContext context, ExtractRawDataAndResultsRequest request) {
        File extractDirectory = new File(context.getTemporaryDirectory(), "Indicateurs_Ifremer");
        request.setExtractDirectory(extractDirectory);
        try {
            FileUtils.forceMkdir((File)extractDirectory);
        }
        catch (IOException e) {
            throw new CoserTechnicalException("Could not create directory: " + extractDirectory, e);
        }
        this.executeAll(context, request);
        File file = context.getExtracts().assemblyExtractResult(context, extractDirectory, request.getZoneList(), this.multipleResults);
        FileResult result = new FileResult("ALL", file);
        return result;
    }

    public CoserRequestExecutor executeUnique(CoserRequestContext context, CoserRequest request) {
        Preconditions.checkNotNull((Object)request);
        Preconditions.checkArgument((boolean)request.isFilled(), (Object)("Request " + request + " is not filled."));
        List<ResultRepository> repositories = this.getMatchingRepositories(context, request);
        if (CollectionUtils.isEmpty(repositories)) {
            throw new NoResultRepositoryFoundException("No result repository matching request", request);
        }
        if (repositories.size() > 1) {
            throw new DuplicatedResultException(repositories.toArray(new ResultRepository[repositories.size()]));
        }
        this.matchingRepositories = ImmutableList.copyOf(repositories);
        ResultRepository repository = this.getFirstMatchingRepository();
        CoserResult result = this.execute(context, repository, request);
        if (result instanceof FileResult) {
            this.fileResult = (FileResult)result;
        } else if (result instanceof MapResult) {
            this.mapResult = (MapResult)result;
        } else if (result instanceof VoidResult) {
            this.voidResult = (VoidResult)result;
        }
        return this;
    }

    public CoserRequestExecutor executeFirst(CoserRequestContext context, CoserRequest request) {
        Preconditions.checkNotNull((Object)request);
        Preconditions.checkArgument((boolean)request.isFilled(), (Object)("Request " + request + " is not filled."));
        List<ResultRepository> repositories = this.getMatchingRepositories(context, request);
        if (CollectionUtils.isEmpty(repositories)) {
            throw new NoResultRepositoryFoundException("No result repository matching request", request);
        }
        this.matchingRepositories = ImmutableList.copyOf(repositories);
        ResultRepository repository = this.getFirstMatchingRepository();
        CoserResult result = this.execute(context, repository, request);
        if (result instanceof FileResult) {
            this.fileResult = (FileResult)result;
        } else if (result instanceof MapResult) {
            this.mapResult = (MapResult)result;
        } else if (result instanceof VoidResult) {
            this.voidResult = (VoidResult)result;
        }
        return this;
    }

    public void deleteResults(CoserRequestContext context, DeleteResultsRequest request) {
        this.executeAll(context, request);
        this.repositoryProvider.resetRepositories();
    }

    public CoserRequestExecutor executeAll(CoserRequestContext context, CoserRequest request) {
        Preconditions.checkNotNull((Object)request);
        Preconditions.checkArgument((boolean)request.isFilled(), (Object)("Request " + request + " is not filled."));
        ArrayList result = Lists.newArrayList();
        List<ResultRepository> repositories = this.getMatchingRepositories(context, request);
        this.matchingRepositories = ImmutableList.copyOf(repositories);
        for (ResultRepository repository : repositories) {
            CoserResult repositoryResult = this.execute(context, repository, request);
            result.add(repositoryResult);
        }
        this.multipleResults = result;
        return this;
    }

    public MapResult toMapResult() {
        if (this.mapResult == null) {
            throw new CoserTechnicalException("No MapResult found");
        }
        return this.mapResult;
    }

    public FileResult toFileResult() {
        if (this.fileResult == null) {
            throw new CoserTechnicalException("No FileResult found");
        }
        return this.fileResult;
    }

    public <Result extends CoserResult> List<Result> toMultipleResult(Class<Result> resultType) {
        if (this.multipleResults == null) {
            throw new CoserTechnicalException("No MultipleResult found");
        }
        for (CoserResult coserResult : this.multipleResults) {
            if (resultType.isAssignableFrom(coserResult.getClass())) continue;
            throw new CoserTechnicalException("Result should a " + resultType + ", but was: " + coserResult.getClass());
        }
        return this.multipleResults;
    }

    public Map<String, String> toMap() {
        List<MapResult> mapResults = this.toMultipleResult(MapResult.class);
        HashMap resultAsMap = Maps.newHashMap();
        for (MapResult map : mapResults) {
            resultAsMap.putAll(map.getResult());
        }
        return resultAsMap;
    }

    public List<ResultRepository> getMatchingRepositories() {
        return this.matchingRepositories;
    }

    public ResultRepository getFirstMatchingRepository() {
        return this.matchingRepositories.get(0);
    }

    protected List<ResultRepository> getMatchingRepositories(CoserRequestContext context, CoserRequest request) {
        ArrayList result = Lists.newArrayList();
        Set<ResultRepository> repositories = this.repositoryProvider.getResultRepositories();
        for (ResultRepository repository : repositories) {
            if (!this.accept(context, repository, request)) continue;
            result.add(repository);
        }
        return result;
    }

    protected <Request extends CoserRequest, Repository extends ResultRepository> boolean accept(CoserRequestContext context, Repository repository, Request request) {
        CoserCommand<Repository, Request> command = this.newCommand(context, repository, request);
        boolean result = command.accept(request);
        return result;
    }

    protected <Request extends CoserRequest, Repository extends ResultRepository> CoserResult execute(CoserRequestContext context, Repository repository, Request request) {
        CoserCommand<Repository, Request> command = this.newCommand(context, repository, request);
        CoserResult result = command.execute(request);
        if (result == null) {
            throw new NoResultFoundException(repository.getId(), request);
        }
        return result;
    }

    protected <Request extends CoserRequest, Repository extends ResultRepository> CoserCommand<Repository, Request> newCommand(CoserRequestContext context, Repository repository, Request request) {
        CoserCommand<Repository, Request> command = this.commandFactory.newCommand(context, repository, request);
        return command;
    }
}

