/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.result;

import fr.ifremer.coser.CoserTechnicalException;
import fr.ifremer.coser.result.CoserCommand;
import fr.ifremer.coser.result.CoserRequest;
import fr.ifremer.coser.result.CoserRequestContext;
import fr.ifremer.coser.result.repository.ResultRepository;
import fr.ifremer.coser.result.repository.ResultRepositoryType;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.map.MultiKeyMap;

public class CoserCommandFactory {
    protected final MultiKeyMap<Object, Class<? extends CoserCommand>> commands = new MultiKeyMap();

    public CoserCommandFactory(Set<ResultRepositoryType> resultRepositoryTypes) {
        for (ResultRepositoryType resultRepositoryType : resultRepositoryTypes) {
            String resultRepositoryTypeId = resultRepositoryType.getId();
            Map<Class<? extends CoserRequest>, Class<? extends CoserCommand>> commandTypes = resultRepositoryType.getCommandTypes();
            for (Map.Entry<Class<? extends CoserRequest>, Class<? extends CoserCommand>> entry : commandTypes.entrySet()) {
                this.commands.put((Object)resultRepositoryTypeId, entry.getKey(), entry.getValue());
            }
        }
    }

    public <Repo extends ResultRepository, R extends CoserRequest> CoserCommand<Repo, R> newCommand(CoserRequestContext requestContext, Repo repository, R request) {
        Class commandType = (Class)this.commands.get((Object)repository.getResultRepositoryType().getId(), request.getClass());
        try {
            CoserCommand command = (CoserCommand)commandType.newInstance();
            command.setRepository(repository);
            command.setRequestContext(requestContext);
            return command;
        }
        catch (InstantiationException e) {
            throw new CoserTechnicalException(e);
        }
        catch (IllegalAccessException e) {
            throw new CoserTechnicalException(e);
        }
    }
}

