/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.command;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.CoserConstants;
import fr.ifremer.coser.CoserUtils;
import fr.ifremer.coser.bean.AbstractDataContainer;
import fr.ifremer.coser.bean.Project;
import fr.ifremer.coser.command.CategoryLineCommand;
import fr.ifremer.coser.storage.DataStorage;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.i18n.I18n;

public class DeleteLineCommand
extends CategoryLineCommand {
    @Override
    public void doCommand(Project project, AbstractDataContainer container) throws CoserBusinessException {
        DataStorage dataStorage = null;
        DataStorage deletedDataStorage = null;
        switch (this.category) {
            case CATCH: {
                dataStorage = container.getCatch();
                deletedDataStorage = container.getDeletedCatch();
                break;
            }
            case HAUL: {
                dataStorage = container.getHaul();
                deletedDataStorage = container.getDeletedHaul();
                break;
            }
            case LENGTH: {
                dataStorage = container.getLength();
                deletedDataStorage = container.getDeletedLength();
                break;
            }
            case STRATA: {
                dataStorage = container.getStrata();
                deletedDataStorage = container.getDeletedStrata();
            }
        }
        int index = dataStorage.indexOf(this.lineNumber);
        if (index < 0) {
            throw new CoserBusinessException(I18n.t((String)"Can't find line %s for deletion", (Object[])new Object[]{this.lineNumber}));
        }
        String[] data = dataStorage.remove(index);
        deletedDataStorage.add(data);
    }

    @Override
    public void undoCommand(Project project, AbstractDataContainer container) throws CoserBusinessException {
        DataStorage dataStorage = null;
        DataStorage deletedDataStorage = null;
        switch (this.category) {
            case CATCH: {
                dataStorage = container.getCatch();
                deletedDataStorage = container.getDeletedCatch();
                break;
            }
            case HAUL: {
                dataStorage = container.getHaul();
                deletedDataStorage = container.getDeletedHaul();
                break;
            }
            case LENGTH: {
                dataStorage = container.getLength();
                deletedDataStorage = container.getDeletedLength();
                break;
            }
            case STRATA: {
                dataStorage = container.getStrata();
                deletedDataStorage = container.getDeletedStrata();
            }
        }
        int indexDeletedData = deletedDataStorage.indexOf(this.lineNumber);
        if (indexDeletedData != -1) {
            String[] deletedDataLine = deletedDataStorage.get(indexDeletedData);
            int lineNumberInt = Integer.parseInt(this.lineNumber);
            int indexData = dataStorage.indexOf(String.valueOf(lineNumberInt));
            if (indexData != -1) {
                throw new CoserBusinessException("Original line already exists !");
            }
            while ((indexData = dataStorage.indexOf(String.valueOf(--lineNumberInt))) < 0 && lineNumberInt > 0) {
            }
            if (indexData >= 0) {
                dataStorage.add(indexData + 1, deletedDataLine);
            } else {
                dataStorage.add(0, deletedDataLine);
            }
        } else {
            throw new CoserBusinessException(I18n.t((String)"Can't find line %s for undeletion", (Object[])new Object[]{this.lineNumber}));
        }
        deletedDataStorage.remove(indexDeletedData);
    }

    @Override
    public String toStringRepresentation() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("category=" + this.category.toString());
        args.add("lineNumber=" + this.lineNumber);
        return CoserUtils.convertBracketString(args);
    }

    @Override
    public void fromStringRepresentation(String representation) {
        List<String> args = CoserUtils.convertBracketToList(representation);
        for (String arg : args) {
            int indexOfEqual = arg.indexOf(61);
            String argAttribute = arg.substring(0, indexOfEqual);
            String value = arg.substring(indexOfEqual + 1);
            if (argAttribute.equals("category")) {
                this.category = CoserConstants.Category.valueOf(value);
                continue;
            }
            if (!argAttribute.equals("lineNumber")) continue;
            this.lineNumber = value;
        }
    }

    @Override
    public String getLogString(Project project, AbstractDataContainer container) {
        return I18n.t((String)"coser.business.command.deleteline.log", (Object[])new Object[]{I18n.t((String)this.category.getTranslationKey(), (Object[])new Object[0]), this.lineNumber});
    }

    @Override
    public String getDescription(Project project, AbstractDataContainer container) {
        String desc = I18n.t((String)"coser.business.command.deleteline.desc", (Object[])new Object[]{I18n.t((String)this.category.getTranslationKey(), (Object[])new Object[0]), this.lineNumber});
        if (StringUtils.isNotBlank((CharSequence)this.comment)) {
            desc = desc + " (" + this.comment + ")";
        }
        return desc;
    }

    public String toString() {
        return "Delete line " + this.lineNumber + " on " + (Object)((Object)this.category);
    }
}

