/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.bean;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import fr.ifremer.coser.result.repository.legacy.LegacyPredicates;
import fr.ifremer.coser.storage.DataStorage;
import fr.ifremer.coser.storage.DataStorageWalker;
import fr.ifremer.coser.storage.DataStorages;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.nuiton.i18n.I18n;

public class SpeciesListMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final DataStorage storage;

    public SpeciesListMap(File speciesFile) {
        this.storage = DataStorages.load(speciesFile);
    }

    public String getSpeciesListName(Locale locale, String specesList) {
        Predicate<String[]> predicate = LegacyPredicates.speciesListPredicate(specesList);
        GetNameWalker walker = new GetNameWalker(locale, specesList);
        DataStorages.walk(this.storage, predicate, walker);
        String translation = walker.getTranslation();
        return translation;
    }

    public Map<String, String> getSpeciesSubMap(Locale locale, Collection<String> speciesList) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        if (speciesList != null) {
            for (String species : speciesList) {
                String speciesLabel = this.getSpeciesListName(locale, species);
                result.put(species, speciesLabel);
            }
        }
        return result;
    }

    protected Iterator<String[]> iterator(boolean skipFirstLine) {
        Iterator<String[]> iterator = this.storage.iterator(skipFirstLine);
        return iterator;
    }

    public static class GetNameWalker
    implements DataStorageWalker {
        protected String translation;
        protected String speciesList;
        protected final Locale locale;

        public GetNameWalker(Locale locale, String speciesList) {
            this.speciesList = speciesList;
            this.locale = locale;
            this.translation = "## " + speciesList + " not found ##";
        }

        public String getTranslation() {
            return this.translation;
        }

        @Override
        public void onRow(String ... tuple) {
            this.translation = tuple[4].equalsIgnoreCase("T") ? I18n.l((Locale)this.locale, (String)"coser.business.specesList.nameForAll", (Object[])new Object[]{Character.valueOf(this.speciesList.charAt(1))}) : I18n.l((Locale)this.locale, (String)"coser.business.specesList.name", (Object[])new Object[]{tuple[0], Character.valueOf(this.speciesList.charAt(1))});
        }
    }
}

