/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.FileUtil;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CoserUtils {
    public static final char BRACKET_STRING_SEPARATOR = ';';
    public static final Pattern FILENAME_SUFFIX_PATTERN = Pattern.compile("^(.+)(\\.[^\\.]+)$");

    public static String convertBracketString(List<String> args) {
        StringBuilder buffer = new StringBuilder();
        Iterator<String> itArgs = args.iterator();
        while (itArgs.hasNext()) {
            buffer.append('(');
            String arg = itArgs.next();
            arg = StringUtils.replace((String)arg, (String)"\\", (String)"\\\\");
            arg = StringUtils.replace((String)arg, (String)")", (String)"\\)");
            arg = StringUtils.replace((String)arg, (String)"(", (String)"\\(");
            buffer.append(arg);
            buffer.append(')');
            if (!itArgs.hasNext()) continue;
            buffer.append(';');
        }
        return buffer.toString();
    }

    protected static List<String> splitWithBrackets(String str, char separator) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer op = new StringBuffer();
        int opened = 0;
        boolean escapeNext = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (escapeNext) {
                op.append(c);
                escapeNext = false;
                continue;
            }
            if (c == '\\') {
                escapeNext = true;
                continue;
            }
            if (c == '(') {
                op.append(c);
                ++opened;
                continue;
            }
            if (c == ')') {
                op.append(c);
                --opened;
                continue;
            }
            if (c == separator) {
                if (opened == 0) {
                    result.add(op.toString());
                    op = new StringBuffer();
                    continue;
                }
                op.append(c);
                continue;
            }
            op.append(c);
        }
        if (op.length() > 0) {
            result.add(op.toString());
        }
        return result;
    }

    public static List<String> convertBracketToList(String argsString) {
        List<String> args = CoserUtils.splitWithBrackets(argsString, ';');
        ArrayList<String> listArgs = new ArrayList<String>();
        for (String arg : args) {
            if (!arg.startsWith("(") || !arg.endsWith(")")) continue;
            arg = StringUtils.removeStart((String)arg, (String)"(");
            arg = StringUtils.removeEnd((String)arg, (String)")");
            arg = StringUtils.replace((String)arg, (String)"\\)", (String)")");
            arg = StringUtils.replace((String)arg, (String)"\\(", (String)"(");
            arg = StringUtils.replace((String)arg, (String)"\\\\", (String)"\\");
            listArgs.add(arg);
        }
        return listArgs;
    }

    public static String addSuffixBeforeExtension(String str, String suffix) {
        String result = null;
        Matcher matcher = FILENAME_SUFFIX_PATTERN.matcher(str);
        result = matcher.matches() ? matcher.group(1) + suffix + matcher.group(2) : str + suffix;
        return result;
    }

    public static List<String> splitAsList(String str) {
        String[] strArray = str.split(",");
        List<String> strList = Arrays.asList(strArray);
        return strList;
    }

    public static Document parseDocument(String content) throws IOException {
        Document result = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            result = builder.parse(new InputSource(new StringReader(content)));
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        return result;
    }

    public static <K, V extends Comparable<? super V>> LinkedHashMap<K, V> sortByValue(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                return ((Comparable)o1.getValue()).compareTo(o2.getValue());
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <K> List<K> sortCollectionWithMapKeys(LinkedHashMap<K, ?> map, Collection<K> list) {
        ArrayList<K> keys = new ArrayList<K>(map.keySet());
        keys.retainAll(list);
        return keys;
    }

    public static void customCopyDirectory(File srcDir, File destDir, FileFilter fileFilter) throws IOException {
        List files = FileUtil.getFilteredElements((File)srcDir, null, (boolean)true);
        for (File file : files) {
            if (!fileFilter.accept(file)) continue;
            String path = file.getPath().substring(srcDir.getPath().length());
            File destFile = new File(destDir, path);
            if (file.isDirectory()) {
                FileUtils.forceMkdir((File)destFile);
                continue;
            }
            FileUtils.copyFile((File)file, (File)destFile);
        }
    }
}

