/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.services.v1;

import com.google.common.base.Preconditions;
import fr.ifremer.coselmar.beans.DocumentBean;
import fr.ifremer.coselmar.converter.BeanEntityConverter;
import fr.ifremer.coselmar.persistence.entity.Document;
import fr.ifremer.coselmar.persistence.entity.DocumentPrivacy;
import fr.ifremer.coselmar.services.CoselmarTechnicalException;
import fr.ifremer.coselmar.services.CoselmarWebServiceSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.debux.webmotion.server.call.UploadFile;
import org.debux.webmotion.server.render.Render;
import org.nuiton.util.DateUtil;

public class DocumentsWebService
extends CoselmarWebServiceSupport {
    private static final Log log = LogFactory.getLog(DocumentsWebService.class);

    public DocumentBean getDocument(String documentId) {
        String fullId = Document.class.getCanonicalName() + "_" + documentId;
        Document document = (Document)this.getDocumentDao().forTopiaIdEquals(fullId).findUnique();
        DocumentBean documentBean = BeanEntityConverter.toBean((Document)document);
        return documentBean;
    }

    public List<DocumentBean> getDocuments(List<String> searchKeywords) {
        List documentList = searchKeywords != null && !searchKeywords.isEmpty() ? this.getDocumentDao().findAllContainingAllKeywords(searchKeywords) : this.getDocumentDao().findAll();
        ArrayList<DocumentBean> result = new ArrayList<DocumentBean>(documentList.size());
        for (Document document : documentList) {
            DocumentBean documentBean = BeanEntityConverter.toBean((Document)document);
            result.add(documentBean);
        }
        return result;
    }

    public void addDocument(DocumentBean document, UploadFile uploadFile) {
        Preconditions.checkNotNull((Object)document);
        Preconditions.checkNotNull((Object)uploadFile);
        String fileName = uploadFile.getName();
        File uploadedFile = uploadFile.getFile();
        String contentType = uploadFile.getContentType();
        if (log.isInfoEnabled()) {
            String message = String.format("File name : %s, content-type : %s", fileName, contentType);
            log.info((Object)message);
        }
        File dataDirectory = this.getCoselmarServicesConfig().getDataDirectory();
        String absolutePath = dataDirectory.getAbsolutePath();
        Date now = this.getNow();
        String formatedDay = DateUtil.formatDate((Date)now, (String)"yyyymmdd");
        String prefix = formatedDay + "-";
        File destFile = new File(absolutePath + "/" + prefix + fileName);
        try {
            FileUtils.moveFile((File)uploadedFile, (File)destFile);
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"error during File transfer", (Throwable)e);
            }
            throw new CoselmarTechnicalException("Internal error during file transfer");
        }
        Document documentEntity = (Document)this.getDocumentDao().create();
        documentEntity.setName(fileName);
        documentEntity.setPrivacy(DocumentPrivacy.valueOf((String)document.getPrivacy().toUpperCase()));
        documentEntity.addAllKeywords((Collection)document.getKeywords());
        documentEntity.setMimeType(contentType);
        Date depositDate = document.getDepositDate();
        if (depositDate != null) {
            documentEntity.setDepositDate(new Date(depositDate.getTime()));
        } else {
            documentEntity.setDepositDate(new Date());
        }
        this.commit();
    }

    public Render getDocumentFile(String documentId) {
        String fullId = Document.class.getCanonicalName() + "_" + documentId;
        Document document = (Document)this.getDocumentDao().forTopiaIdEquals(fullId).findUnique();
        String fileName = document.getName();
        Date depositeDate = document.getDepositDate();
        File dataDirectory = this.getCoselmarServicesConfig().getDataDirectory();
        String absolutePath = dataDirectory.getAbsolutePath();
        String formatedDay = DateUtil.formatDate((Date)depositeDate, (String)"yyyymmdd");
        String prefix = formatedDay + "-";
        File documentFile = new File(absolutePath + "/" + prefix + fileName);
        String fileMimeType = document.getMimeType();
        try {
            FileInputStream fileStream = new FileInputStream(documentFile);
            return this.renderDownload((InputStream)fileStream, fileName, fileMimeType);
        }
        catch (FileNotFoundException e) {
            if (log.isErrorEnabled()) {
                String message = String.format("Unable to retrieve file %s", fileName);
                log.error((Object)message);
            }
            throw new CoselmarTechnicalException("File does not exist");
        }
    }

    public void saveDocument(DocumentBean documentBean) {
        throw new CoselmarTechnicalException("not yet implemented");
    }

    public void deleteDocument(String documentId) {
        String fullId = Document.class.getCanonicalName() + "_" + documentId;
        Document document = (Document)this.getDocumentDao().forTopiaIdEquals(fullId).findUnique();
        this.getDocumentDao().delete(document);
        this.commit();
    }
}

