/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.persistence.entity;

import fr.ifremer.coselmar.beans.QuestionSearchBean;
import fr.ifremer.coselmar.persistence.DaoUtils;
import fr.ifremer.coselmar.persistence.entity.AbstractQuestionTopiaDao;
import fr.ifremer.coselmar.persistence.entity.CoselmarUser;
import fr.ifremer.coselmar.persistence.entity.Privacy;
import fr.ifremer.coselmar.persistence.entity.Question;
import fr.ifremer.coselmar.persistence.entity.Status;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.persistence.TopiaQueryBuilderAddCriteriaOrRunQueryStep;
import org.nuiton.util.pagination.PaginationParameter;

public class QuestionTopiaDao
extends AbstractQuestionTopiaDao<Question> {
    public List<Question> findForExpert(CoselmarUser expert, QuestionSearchBean searchBean, PaginationParameter page) {
        StringBuilder hqlBuilder = new StringBuilder("SELECT Q FROM " + Question.class.getName() + " Q " + " INNER JOIN Q." + "participants" + " CUG ");
        HashMap<String, Object> args = new HashMap<String, Object>();
        String publicCondition = DaoUtils.getQueryForAttributeEquals("Q", "privacy", args, (Object)Privacy.PUBLIC, "");
        hqlBuilder.append(" WHERE ( (" + publicCondition + " ) ");
        String privateCondition = DaoUtils.getQueryForAttributeEquals("Q", "privacy", args, (Object)Privacy.PRIVATE, "");
        hqlBuilder.append(" OR (" + privateCondition);
        String participantCondition = DaoUtils.andAttributeContains("CUG", "members", args, expert);
        hqlBuilder.append(participantCondition);
        String clientCondition = DaoUtils.andAttributeContains("Q", "clients", args, expert);
        hqlBuilder.append(clientCondition + ") )");
        String finerHql = this.refineSearch(searchBean, "Q", args);
        hqlBuilder.append(" AND (" + finerHql + ")");
        List questions = page != null ? this.forHql(hqlBuilder.toString(), args).find(page) : this.forHql(hqlBuilder.toString(), args).findAll();
        return questions;
    }

    public List<Question> findForExpert(CoselmarUser expert) {
        StringBuilder hqlBuilder = new StringBuilder("SELECT Q FROM " + Question.class.getName() + " Q " + " INNER JOIN Q." + "participants" + " CUG ");
        HashMap<String, Object> args = new HashMap<String, Object>();
        String publicCondition = DaoUtils.getQueryForAttributeEquals("Q", "privacy", args, (Object)Privacy.PUBLIC, "");
        hqlBuilder.append(" WHERE ( (" + publicCondition + " ) ");
        String privateCondition = DaoUtils.getQueryForAttributeEquals("Q", "privacy", args, (Object)Privacy.PRIVATE, "");
        hqlBuilder.append(" OR (" + privateCondition);
        String participantCondition = DaoUtils.andAttributeContains("CUG", "members", args, expert);
        hqlBuilder.append(participantCondition);
        String clientCondition = DaoUtils.andAttributeContains("Q", "clients", args, expert);
        hqlBuilder.append(clientCondition + ") )");
        List questions = this.forHql(hqlBuilder.toString(), args).findAll();
        return questions;
    }

    public List<Question> findForExpert(CoselmarUser expert, List<String> topiaIds, PaginationParameter page) {
        StringBuilder hqlBuilder = new StringBuilder("SELECT Q FROM " + Question.class.getName() + " Q " + " INNER JOIN Q." + "participants" + " CUG ");
        HashMap<String, Object> args = new HashMap<String, Object>();
        String publicCondition = DaoUtils.getQueryForAttributeEquals("Q", "privacy", args, (Object)Privacy.PUBLIC, "");
        hqlBuilder.append(" WHERE ( (" + publicCondition + " ) ");
        String privateCondition = DaoUtils.getQueryForAttributeEquals("Q", "privacy", args, (Object)Privacy.PRIVATE, "");
        hqlBuilder.append(" OR (" + privateCondition + " AND ( 0 = 1 ");
        String participantCondition = DaoUtils.orAttributeContains("CUG", "members", args, expert);
        hqlBuilder.append(participantCondition);
        String clientCondition = DaoUtils.orAttributeContains("Q", "clients", args, expert);
        hqlBuilder.append(clientCondition + ") ) )");
        String topiaIdsCondition = DaoUtils.andAttributeIn("Q", "topiaId", args, topiaIds);
        hqlBuilder.append(topiaIdsCondition);
        List questions = page != null ? this.forHql(hqlBuilder.toString(), args).find(page) : this.forHql(hqlBuilder.toString(), args).findAll();
        return questions;
    }

    public List<Question> findForClient(CoselmarUser client, QuestionSearchBean searchBean, PaginationParameter page) {
        StringBuilder hqlBuilder = new StringBuilder("SELECT Q FROM " + Question.class.getName() + " Q ");
        HashMap<String, Object> args = new HashMap<String, Object>();
        String clientCondition = DaoUtils.andAttributeContains("Q", "clients", args, client);
        hqlBuilder.append(" WHERE 1=1 AND (" + clientCondition + " ) ");
        if (searchBean != null) {
            String finerHql = this.refineSearch(searchBean, "Q", args);
            hqlBuilder.append(" AND (" + finerHql + ")");
        }
        List questions = page != null ? this.forHql(hqlBuilder.toString(), args).find(page) : this.forHql(hqlBuilder.toString(), args).findAll();
        return questions;
    }

    public List<Question> findForClient(CoselmarUser client, List<String> topiaIds, PaginationParameter page) {
        TopiaQueryBuilderAddCriteriaOrRunQueryStep queryBuilder = this.forTopiaIdIn(topiaIds);
        queryBuilder.addContains("clients", (Object)client);
        List questions = page != null ? queryBuilder.find(page) : queryBuilder.findAll();
        return questions;
    }

    public List<Question> findWithSearchBean(QuestionSearchBean searchBean, PaginationParameter page) {
        StringBuilder hqlBuilder = new StringBuilder("SELECT Q FROM " + Question.class.getName() + " Q ");
        HashMap args = new HashMap();
        if (searchBean != null) {
            String finerHql = this.refineSearch(searchBean, "Q", args);
            hqlBuilder.append(" WHERE (" + finerHql + ")");
        }
        List questions = page != null ? this.forHql(hqlBuilder.toString(), args).find(page) : this.forHql(hqlBuilder.toString(), args).findAll();
        return questions;
    }

    public List<String> findAllThemes() {
        StringBuilder hqlBuilder = new StringBuilder("SELECT DISTINCT(themes) FROM " + Question.class.getName() + " Q " + " INNER JOIN Q." + "theme" + " themes ");
        List values = this.findAll(hqlBuilder.toString());
        return values;
    }

    public List<String> findAllTypes() {
        StringBuilder hqlBuilder = new StringBuilder("SELECT DISTINCT(Q. type) FROM " + Question.class.getName() + " Q ");
        List values = this.findAll(hqlBuilder.toString());
        return values;
    }

    public String refineSearch(QuestionSearchBean searchBean, String alias, Map args) {
        List<String> keywords;
        String status;
        StringBuilder finerHqlBuilder = new StringBuilder(" 1=1 ");
        String privacy = searchBean.getPrivacy();
        if (StringUtils.isNotBlank((CharSequence)privacy)) {
            String privacyHql = DaoUtils.andAttributeEquals(alias, "privacy", args, (Object)Privacy.valueOf(privacy.toUpperCase()));
            finerHqlBuilder.append(privacyHql);
        }
        if (StringUtils.isNotBlank((CharSequence)(status = searchBean.getStatus()))) {
            String statusHql = DaoUtils.andAttributeEquals(alias, "status", args, (Object)Status.valueOf(status.toUpperCase()));
            finerHqlBuilder.append(statusHql);
        }
        if ((keywords = searchBean.getKeywords()) != null && !keywords.isEmpty()) {
            StringBuilder keywordsBuilder = new StringBuilder(" ( ( 1 = 1 ) ");
            for (String keyword : keywords) {
                keywordsBuilder.append(" AND ( 1=0 ");
                keywordsBuilder.append(DaoUtils.orAttributeLike(alias, "title", args, keyword));
                keywordsBuilder.append(DaoUtils.orAttributeLike(alias, "submissionDate", args, keyword));
                keywordsBuilder.append(DaoUtils.orAttributeContains(alias, "theme", args, keyword));
                keywordsBuilder.append(" ) ");
            }
            keywordsBuilder.append(" ) ");
            String keywordHql = keywordsBuilder.toString();
            finerHqlBuilder.append(" AND " + keywordHql);
        }
        String finerHql = finerHqlBuilder.toString();
        return finerHql;
    }
}

