/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.services.v1;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import fr.ifremer.coselmar.beans.DocumentBean;
import fr.ifremer.coselmar.beans.DocumentSearchBean;
import fr.ifremer.coselmar.beans.DocumentSearchExample;
import fr.ifremer.coselmar.beans.FileInfos;
import fr.ifremer.coselmar.beans.MassiveDocumentsImportResult;
import fr.ifremer.coselmar.beans.QuestionBean;
import fr.ifremer.coselmar.beans.UserBean;
import fr.ifremer.coselmar.beans.UserWebToken;
import fr.ifremer.coselmar.converter.BeanEntityConverter;
import fr.ifremer.coselmar.exceptions.CoselmarTechnicalException;
import fr.ifremer.coselmar.persistence.entity.CoselmarUser;
import fr.ifremer.coselmar.persistence.entity.CoselmarUserGroup;
import fr.ifremer.coselmar.persistence.entity.CoselmarUserRole;
import fr.ifremer.coselmar.persistence.entity.Document;
import fr.ifremer.coselmar.persistence.entity.Privacy;
import fr.ifremer.coselmar.persistence.entity.Question;
import fr.ifremer.coselmar.services.CoselmarWebServiceSupport;
import fr.ifremer.coselmar.services.errors.InvalidCredentialException;
import fr.ifremer.coselmar.services.errors.NoResultException;
import fr.ifremer.coselmar.services.errors.UnauthorizedException;
import fr.ifremer.coselmar.services.indexation.DocumentsIndexationService;
import fr.ifremer.coselmar.services.indexation.TikaUtils;
import fr.ifremer.coselmar.services.v1.AdminWebService;
import fr.ifremer.coselmar.services.v1.DocumentsWebService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.queryparser.classic.ParseException;
import org.debux.webmotion.server.call.UploadFile;
import org.debux.webmotion.server.render.Render;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaIdFactory;
import org.nuiton.topia.persistence.TopiaNoResultException;
import org.nuiton.util.DateUtil;
import org.nuiton.util.pagination.PaginationParameter;
import org.nuiton.util.pagination.PaginationResult;

public class DocumentsWebService
extends CoselmarWebServiceSupport {
    private static final Log log = LogFactory.getLog(DocumentsWebService.class);
    public static final List<String> DOCUMENT_CREATE_ALLOWED_USER_ROLES = Lists.newArrayList((Object[])new String[]{CoselmarUserRole.ADMIN.name(), CoselmarUserRole.SUPERVISOR.name(), CoselmarUserRole.EXPERT.name()});
    public static final List<String> DOCUMENT_SUPER_USER_ROLES = Lists.newArrayList((Object[])new String[]{CoselmarUserRole.ADMIN.name(), CoselmarUserRole.SUPERVISOR.name()});
    public static final List<String> DOCUMENT_VIEW_ALLOWED_USER_ROLES = Lists.newArrayList((Object[])new String[]{CoselmarUserRole.ADMIN.name(), CoselmarUserRole.SUPERVISOR.name(), CoselmarUserRole.EXPERT.name()});
    protected static final String DESCRIPTION_CSV_FILE_NAME = "description.csv";

    public DocumentBean getDocument(String documentId) throws InvalidCredentialException, UnauthorizedException {
        String authorization = this.getAuthorizationHeader();
        CoselmarUser currentUser = this.checkUserAuthentication(authorization);
        String fullId = this.getDocumentFullId(documentId);
        Document document = (Document)this.getDocumentDao().forTopiaIdEquals(fullId).findUnique();
        if (!this.isAllowedToAccessDocument(currentUser, document)) {
            String message = String.format("User %s %s ('%s') try to access to document '%s'", currentUser.getFirstname(), currentUser.getName(), this.getShortIdFromFull(currentUser.getTopiaId()), documentId);
            if (log.isWarnEnabled()) {
                log.warn((Object)message);
            }
            throw new UnauthorizedException(message);
        }
        DocumentBean documentBean = BeanEntityConverter.toBean((TopiaIdFactory)this.getPersistenceContext().getTopiaIdFactory(), (Document)document);
        List relatedQuestions = this.getQuestionDao().forRelatedDocumentsContains(document).findAll();
        for (Object relatedQuestion : relatedQuestions) {
            QuestionBean questionBean = BeanEntityConverter.toLightBean((TopiaIdFactory)this.getPersistenceContext().getTopiaIdFactory(), (Question)relatedQuestion);
            documentBean.addRelatedQuestion(questionBean);
        }
        List relatedQuestionsAsClosing = this.getQuestionDao().forClosingDocumentsContains(document).findAll();
        for (Question relatedQuestion : relatedQuestionsAsClosing) {
            QuestionBean questionBean = BeanEntityConverter.toLightBean((TopiaIdFactory)this.getPersistenceContext().getTopiaIdFactory(), (Question)relatedQuestion);
            documentBean.addRelatedQuestion(questionBean);
        }
        if (document.getPrivacy() == Privacy.RESTRICTED) {
            Set restrictedList = document.getRestrictedList();
            for (CoselmarUserGroup usersGroup : restrictedList) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)fullId, (CharSequence)usersGroup.getName())) continue;
                Set members = usersGroup.getMembers();
                for (CoselmarUser member : members) {
                    String userLightId = this.getPersistenceContext().getTopiaIdFactory().getRandomPart(member.getTopiaId());
                    UserBean userBean = BeanEntityConverter.toBean((String)userLightId, (CoselmarUser)member);
                    documentBean.addAuthorizedUser(userBean);
                }
            }
        }
        return documentBean;
    }

    public List<DocumentBean> getDocuments(DocumentSearchBean searchBean) throws InvalidCredentialException {
        PaginationResult paginatedDocuments = this.getPaginatedDocuments(searchBean);
        return paginatedDocuments.getElements();
    }

    public PaginationResult<DocumentBean> getPaginatedDocuments(DocumentSearchBean searchBean) throws InvalidCredentialException {
        PaginationResult paginatedDocuments;
        String authorization = this.getAuthorizationHeader();
        CoselmarUser currentUser = this.checkUserAuthentication(authorization);
        CoselmarUserRole currentUserRole = currentUser.getRole();
        DocumentSearchExample searchExample = DocumentSearchExample.newDefaultSearchExample();
        if (searchBean != null) {
            if (searchBean.getPage() != null) {
                searchExample.setPage(searchBean.getPage());
            }
            if (searchBean.getLimit() != null) {
                searchExample.setLimit(searchBean.getLimit());
            }
            searchExample.setFullTextSearch(searchBean.getFullTextSearch());
            Document example = BeanEntityConverter.fromSearchBean((DocumentBean)searchBean);
            searchExample.setExample((TopiaEntity)example);
            searchExample.setOwnerName(searchBean.getOwnerName());
            if (searchBean.getDepositAfterDate() != null) {
                Date depositAfterDate = DateUtil.getEndOfDay((Date)DateUtil.getYesterday((Date)searchBean.getDepositAfterDate()));
                searchExample.setDepositAfterDate(depositAfterDate);
            }
            if (searchBean.getDepositBeforeDate() != null) {
                Date depositBeforeDate = DateUtil.getEndOfDay((Date)searchBean.getDepositBeforeDate());
                searchExample.setDepositBeforeDate(depositBeforeDate);
            }
            if (searchBean.getPublicationAfterDate() != null) {
                Date publicationAfterDate = DateUtil.getEndOfDay((Date)DateUtil.getYesterday((Date)searchBean.getPublicationAfterDate()));
                searchExample.setPublicationAfterDate(publicationAfterDate);
            }
            if (searchBean.getPublicationBeforeDate() != null) {
                Date publicationBeforeDate = DateUtil.getEndOfDay((Date)searchBean.getPublicationBeforeDate());
                searchExample.setPublicationBeforeDate(publicationBeforeDate);
            }
        }
        if (Lists.newArrayList((Object[])new CoselmarUserRole[]{CoselmarUserRole.ADMIN, CoselmarUserRole.SUPERVISOR}).contains(currentUserRole)) {
            List searchKeywords = searchBean.getFullTextSearch();
            if (searchKeywords != null && !searchKeywords.isEmpty()) {
                DocumentsIndexationService documentsIndexationService = (DocumentsIndexationService)this.getServicesContext().newService(DocumentsIndexationService.class);
                try {
                    List documentIds = documentsIndexationService.searchDocuments(searchKeywords);
                    List documentFullIds = this.getDocumentsFullId(documentIds);
                    Long count = this.getDocumentDao().forTopiaIdIn((Collection)documentFullIds).count();
                    List documentList = this.getDocumentDao().forTopiaIdIn((Collection)documentFullIds).find(searchExample.getPaginationParameter());
                    paginatedDocuments = PaginationResult.of((List)documentList, (long)count, (PaginationParameter)searchExample.getPaginationParameter());
                }
                catch (IOException | ParseException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Unable to search by lucene, make search directly in database", e);
                    }
                    paginatedDocuments = this.getDocumentDao().findPaginatedContainingAllKeywords(searchKeywords, searchExample.getPaginationParameter());
                }
            } else {
                paginatedDocuments = this.getDocumentDao().findAllByExample(null, searchExample);
            }
        } else {
            paginatedDocuments = this.getDocumentDao().findAllByExample(currentUser, searchExample);
        }
        ArrayList<DocumentBean> documentBeans = new ArrayList<DocumentBean>(paginatedDocuments.getElements().size());
        for (Document document : paginatedDocuments.getElements()) {
            DocumentBean documentBean = BeanEntityConverter.toBean((TopiaIdFactory)this.getPersistenceContext().getTopiaIdFactory(), (Document)document);
            long relatedQuestions = this.getQuestionDao().forRelatedDocumentsContains(document).count();
            long relatedQuestionsAsClosing = this.getQuestionDao().forClosingDocumentsContains(document).count();
            documentBean.setNbRelatedQuestions((int)(relatedQuestions + relatedQuestionsAsClosing));
            documentBeans.add(documentBean);
        }
        PaginationResult result = PaginationResult.of(documentBeans, (long)paginatedDocuments.getCount(), (PaginationParameter)paginatedDocuments.getCurrentPage());
        return result;
    }

    public List<String> getSearchBibliography(DocumentSearchBean searchBean) throws InvalidCredentialException {
        List citations;
        String authorization = this.getAuthorizationHeader();
        CoselmarUser currentUser = this.checkUserAuthentication(authorization);
        CoselmarUserRole currentUserRole = currentUser.getRole();
        DocumentSearchExample searchExample = DocumentSearchExample.newDefaultSearchExample();
        if (searchBean != null) {
            searchExample.setPage(Integer.valueOf(0));
            searchExample.setLimit(Integer.valueOf(-1));
            searchExample.setFullTextSearch(searchBean.getFullTextSearch());
            Document example = BeanEntityConverter.fromSearchBean((DocumentBean)searchBean);
            searchExample.setExample((TopiaEntity)example);
            searchExample.setOwnerName(searchBean.getOwnerName());
            if (searchBean.getDepositAfterDate() != null) {
                Date depositAfterDate = DateUtil.getEndOfDay((Date)DateUtil.getYesterday((Date)searchBean.getDepositAfterDate()));
                searchExample.setDepositAfterDate(depositAfterDate);
            }
            if (searchBean.getDepositBeforeDate() != null) {
                Date depositBeforeDate = DateUtil.getEndOfDay((Date)searchBean.getDepositBeforeDate());
                searchExample.setDepositBeforeDate(depositBeforeDate);
            }
            if (searchBean.getPublicationAfterDate() != null) {
                Date publicationAfterDate = DateUtil.getEndOfDay((Date)DateUtil.getYesterday((Date)searchBean.getPublicationAfterDate()));
                searchExample.setPublicationAfterDate(publicationAfterDate);
            }
            if (searchBean.getPublicationBeforeDate() != null) {
                Date publicationBeforeDate = DateUtil.getEndOfDay((Date)searchBean.getPublicationBeforeDate());
                searchExample.setPublicationBeforeDate(publicationBeforeDate);
            }
        }
        if (Lists.newArrayList((Object[])new CoselmarUserRole[]{CoselmarUserRole.ADMIN, CoselmarUserRole.SUPERVISOR}).contains(currentUserRole)) {
            List searchKeywords = searchBean.getFullTextSearch();
            if (searchKeywords != null && !searchKeywords.isEmpty()) {
                DocumentsIndexationService documentsIndexationService = (DocumentsIndexationService)this.getServicesContext().newService(DocumentsIndexationService.class);
                try {
                    List documentIds = documentsIndexationService.searchDocuments(searchKeywords);
                    List documentFullIds = this.getDocumentsFullId(documentIds);
                    citations = this.getDocumentDao().findCitationsByDocumentIds(documentFullIds);
                }
                catch (IOException | ParseException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Unable to search by lucene, make search directly in database", e);
                    }
                    citations = this.getDocumentDao().findCitationsByDocumentFromKeywords(searchKeywords);
                }
            } else {
                citations = this.getDocumentDao().findCitationsByDocumentExample(null, searchExample);
            }
        } else {
            citations = this.getDocumentDao().findCitationsByDocumentExample(currentUser, searchExample);
        }
        Iterables.removeIf((Iterable)citations, (Predicate)new /* Unavailable Anonymous Inner Class!! */);
        return citations;
    }

    public DocumentBean addDocument(DocumentBean document, UploadFile uploadFile) throws InvalidCredentialException, UnauthorizedException {
        CoselmarUser owner;
        String authorization = this.getAuthorizationHeader();
        UserWebToken userWebToken = this.checkAuthentication(authorization);
        String userRole = userWebToken.getRole();
        if (!DOCUMENT_CREATE_ALLOWED_USER_ROLES.contains(userRole.toUpperCase())) {
            String message = String.format("User %s %s ('%s') is not allowed to add document", userWebToken.getFirstName(), userWebToken.getLastName(), userWebToken.getUserId());
            if (log.isWarnEnabled()) {
                log.warn((Object)message);
            }
            throw new UnauthorizedException(message);
        }
        Preconditions.checkNotNull((Object)document);
        String fullId = this.getFullUserIdFromShort(userWebToken.getUserId());
        try {
            owner = (CoselmarUser)this.getCoselmarUserDao().forTopiaIdEquals(fullId).findUnique();
        }
        catch (TopiaNoResultException tnre) {
            String message = String.format("Seems that logged user ('%s') does not exist anymore.", fullId);
            if (log.isErrorEnabled()) {
                log.error((Object)message, (Throwable)tnre);
            }
            throw new InvalidCredentialException(message);
        }
        FileInfos fileInfos = null;
        if (uploadFile != null) {
            fileInfos = this.manageDocumentFile(uploadFile, owner);
        }
        DocumentBean result = this.createDocument(document, fileInfos, owner);
        this.commit();
        return result;
    }

    public void addDocumentFile(String documentId, UploadFile uploadFile) throws InvalidCredentialException, UnauthorizedException {
        block6: {
            Preconditions.checkNotNull((Object)documentId);
            Preconditions.checkNotNull((Object)uploadFile);
            String authorization = this.getAuthorizationHeader();
            CoselmarUser currentUser = this.checkUserAuthentication(authorization);
            String documentFullId = this.getFullIdFromShort(Document.class, documentId);
            Document documentEntity = (Document)this.getDocumentDao().forTopiaIdEquals(documentFullId).findAny();
            if (!DOCUMENT_SUPER_USER_ROLES.contains(currentUser.getRole().name()) && documentEntity.getOwner() != currentUser) {
                String message = String.format("User %s %s ('%s') is not allowed to add document file", currentUser.getFirstname(), currentUser.getName(), this.getShortIdFromFull(currentUser.getTopiaId()));
                if (log.isWarnEnabled()) {
                    log.warn((Object)message);
                }
                throw new UnauthorizedException(message);
            }
            CoselmarUser owner = documentEntity.getOwner();
            FileInfos fileInfos = this.manageDocumentFile(uploadFile, owner);
            String filePath = fileInfos.getFinalFilePath();
            String contentType = fileInfos.getMimeType();
            String fileContent = TikaUtils.getFileContent((String)filePath);
            if (StringUtils.isNotBlank((CharSequence)documentEntity.getFilePath())) {
                File documentFile = new File(documentEntity.getFilePath());
                FileUtils.deleteQuietly((File)documentFile);
            }
            documentEntity.setWithFile(true);
            documentEntity.setMimeType(contentType);
            documentEntity.setFilePath(filePath);
            documentEntity.setFileName(uploadFile.getName());
            documentEntity.setFileContent(fileContent);
            DocumentBean documentBean = BeanEntityConverter.toBean((TopiaIdFactory)this.getPersistenceContext().getTopiaIdFactory(), (Document)documentEntity);
            DocumentsIndexationService documentsIndexationService = (DocumentsIndexationService)this.getServicesContext().newService(DocumentsIndexationService.class);
            try {
                documentsIndexationService.updateDocument(documentBean, fileContent);
                if (log.isDebugEnabled()) {
                    String message = String.format("Document '%s' was updated in index", documentEntity.getName());
                    log.debug((Object)message);
                }
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)"Unable to update document index information", (Throwable)e);
            }
        }
        this.commit();
    }

    public Render getDocumentFile(String documentId) throws NoResultException {
        String fullId = this.getDocumentFullId(documentId);
        Document document = (Document)this.getDocumentDao().forTopiaIdEquals(fullId).findUnique();
        String filePath = document.getFilePath();
        if (StringUtils.isBlank((CharSequence)filePath)) {
            throw new NoResultException("No File");
        }
        File documentFile = new File(filePath);
        String fileName = StringUtils.isNotBlank((CharSequence)document.getFileName()) ? document.getFileName() : document.getName();
        String fileMimeType = document.getMimeType();
        try {
            FileInputStream fileStream = new FileInputStream(documentFile);
            return this.renderDownload((InputStream)fileStream, fileName, fileMimeType);
        }
        catch (FileNotFoundException e) {
            if (log.isErrorEnabled()) {
                String message = String.format("Unable to retrieve file %s", fileName);
                log.error((Object)message, (Throwable)e);
            }
            throw new NoResultException("File does not exist");
        }
    }

    public void saveDocument(DocumentBean document) throws InvalidCredentialException, UnauthorizedException {
        block18: {
            Preconditions.checkNotNull((Object)document);
            Preconditions.checkNotNull((Object)document.getId());
            String authorization = this.getAuthorizationHeader();
            CoselmarUser currentUser = this.checkUserAuthentication(authorization);
            String documentId = this.getDocumentFullId(document.getId());
            Document documentEntity = (Document)this.getDocumentDao().forTopiaIdEquals(documentId).findUnique();
            if (!this.isAllowedToAccessDocument(currentUser, documentEntity)) {
                String message = String.format("User %s %s ('%s') try to modify document '%s'", currentUser.getFirstname(), currentUser.getName(), this.getShortIdFromFull(currentUser.getTopiaId()), documentId);
                if (log.isWarnEnabled()) {
                    log.warn((Object)message);
                }
                throw new UnauthorizedException(message);
            }
            boolean isUsedByQuestions = this.getQuestionDao().forRelatedDocumentsContains(documentEntity).exists();
            if (isUsedByQuestions && currentUser.getRole() != CoselmarUserRole.ADMIN) {
                String message = "Document is used by some questions, cannot be modified.";
                if (log.isWarnEnabled()) {
                    log.warn((Object)message);
                }
                throw new UnauthorizedException(message);
            }
            documentEntity.setName(document.getName());
            String oldPrivacy = documentEntity.getPrivacy().name();
            String newPrivacy = document.getPrivacy().toUpperCase();
            documentEntity.setPrivacy(Privacy.valueOf((String)newPrivacy));
            if (StringUtils.equals((CharSequence)Privacy.RESTRICTED.name(), (CharSequence)newPrivacy)) {
                Set authorizedUsers = document.getAuthorizedUsers();
                Set coselmarUsers = this.retrieveUsers((Collection)authorizedUsers);
                Set restrictedList = documentEntity.getRestrictedList();
                CoselmarUserGroup restrictedUsers = null;
                if (restrictedList != null && !restrictedList.isEmpty()) {
                    for (CoselmarUserGroup usersList : restrictedList) {
                        if (!StringUtils.equalsIgnoreCase((CharSequence)documentId, (CharSequence)usersList.getName())) continue;
                        restrictedUsers = usersList;
                        restrictedUsers.clearMembers();
                        break;
                    }
                }
                if (restrictedUsers == null) {
                    restrictedUsers = (CoselmarUserGroup)this.getCoselmarUserGroupDao().create();
                    restrictedUsers.setName(documentEntity.getTopiaId());
                }
                restrictedUsers.addAllMembers((Iterable)coselmarUsers);
                documentEntity.addRestrictedList(restrictedUsers);
            } else if (StringUtils.equals((CharSequence)Privacy.RESTRICTED.name(), (CharSequence)oldPrivacy)) {
                CoselmarUserGroup restrictedUsers = null;
                for (CoselmarUserGroup usersList : documentEntity.getRestrictedList()) {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)documentId, (CharSequence)usersList.getName())) continue;
                    restrictedUsers = usersList;
                    break;
                }
                if (restrictedUsers != null) {
                    documentEntity.removeRestrictedList(restrictedUsers);
                    this.getCoselmarUserGroupDao().delete(restrictedUsers);
                }
            }
            documentEntity.clearKeywords();
            documentEntity.addAllKeywords((Iterable)document.getKeywords());
            documentEntity.setType(document.getType());
            documentEntity.setSummary(document.getSummary());
            documentEntity.setLanguage(document.getLanguage());
            Date publicationDate = document.getPublicationDate();
            if (publicationDate != null) {
                documentEntity.setPublicationDate(new Date(publicationDate.getTime()));
            } else {
                documentEntity.setPublicationDate(null);
            }
            documentEntity.setAuthors(document.getAuthors());
            documentEntity.setCopyright(document.getCopyright());
            documentEntity.setLicense(document.getLicense());
            documentEntity.setExternalUrl(document.getExternalUrl());
            boolean hadFile = documentEntity.isWithFile();
            if (hadFile && StringUtils.isBlank((CharSequence)document.getFileName())) {
                this.deleteAttachedFile(documentEntity);
            }
            documentEntity.setComment(document.getComment());
            documentEntity.setCitation(document.getCitation());
            this.commit();
            DocumentBean result = BeanEntityConverter.toBean((TopiaIdFactory)this.getPersistenceContext().getTopiaIdFactory(), (Document)documentEntity);
            DocumentsIndexationService documentsIndexationService = (DocumentsIndexationService)this.getServicesContext().newService(DocumentsIndexationService.class);
            try {
                documentsIndexationService.indexDocument(result, null);
                if (log.isDebugEnabled()) {
                    String message = String.format("Document '%s' was updated in index", document.getName());
                    log.debug((Object)message);
                }
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block18;
                log.error((Object)"Unable to update document index information", (Throwable)e);
            }
        }
    }

    public void deleteDocument(String documentId) throws InvalidCredentialException, UnauthorizedException {
        block5: {
            String authorization = this.getAuthorizationHeader();
            CoselmarUser currentUser = this.checkUserAuthentication(authorization);
            String fullId = this.getDocumentFullId(documentId);
            Document document = (Document)this.getDocumentDao().forTopiaIdEquals(fullId).findUnique();
            if (!DOCUMENT_SUPER_USER_ROLES.contains(currentUser.getRole().name()) && document.getOwner() != currentUser) {
                String message = String.format("User %s %s ('%s') try to delete document '%s'", currentUser.getFirstname(), currentUser.getName(), this.getShortIdFromFull(currentUser.getTopiaId()), documentId);
                if (log.isWarnEnabled()) {
                    log.warn((Object)message);
                }
                throw new UnauthorizedException(message);
            }
            this.deleteAttachedFile(document);
            this.getDocumentDao().delete(document);
            this.commit();
            DocumentsIndexationService documentsIndexationService = (DocumentsIndexationService)this.getServicesContext().newService(DocumentsIndexationService.class);
            try {
                documentsIndexationService.deleteDocument(documentId);
                if (log.isDebugEnabled()) {
                    String message = String.format("Document '%s' removed from index", documentId);
                    log.debug((Object)message);
                }
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)"Unable to remove document entry from index", (Throwable)e);
            }
        }
    }

    public List<String> getKeywords() throws InvalidCredentialException, UnauthorizedException {
        List themes = this.getDocumentDao().findAllKeywords();
        return themes;
    }

    public List<String> getTypes() throws InvalidCredentialException, UnauthorizedException {
        List types = this.getDocumentDao().findAllTypes();
        return types;
    }

    public MassiveDocumentsImportResult uploadZipDocuments(UploadFile uploadFile) throws InvalidCredentialException, UnauthorizedException {
        Preconditions.checkNotNull((Object)uploadFile);
        String authorization = this.getAuthorizationHeader();
        CoselmarUser currentUser = this.checkUserAuthentication(authorization);
        if (!DOCUMENT_SUPER_USER_ROLES.contains(currentUser.getRole().name())) {
            String message = String.format("User %s %s ('%s') is not allowed to upload mass document files", currentUser.getFirstname(), currentUser.getName(), this.getShortIdFromFull(currentUser.getTopiaId()));
            if (log.isWarnEnabled()) {
                log.warn((Object)message);
            }
            throw new UnauthorizedException(message);
        }
        return this.importFromZip(uploadFile.getFile(), currentUser);
    }

    protected DocumentBean createDocument(DocumentBean documentBean, FileInfos fileInfos, CoselmarUser owner) {
        DocumentBean result;
        block5: {
            Document documentEntity = this.createDocumentMetadataFromBean(documentBean, owner);
            String fileContent = "";
            if (fileInfos != null) {
                String filePath = fileInfos.getFinalFilePath();
                String contentType = fileInfos.getMimeType();
                fileContent = StringUtils.isNotBlank((CharSequence)fileInfos.getActualFilePath()) ? TikaUtils.getFileContent((String)fileInfos.getActualFilePath()) : TikaUtils.getFileContent((String)filePath);
                documentEntity.setWithFile(true);
                documentEntity.setMimeType(contentType);
                documentEntity.setFilePath(filePath);
                documentEntity.setFileContent(fileContent);
            } else {
                documentEntity.setWithFile(false);
            }
            result = BeanEntityConverter.toBean((TopiaIdFactory)this.getPersistenceContext().getTopiaIdFactory(), (Document)documentEntity);
            DocumentsIndexationService documentsIndexationService = (DocumentsIndexationService)this.getServicesContext().newService(DocumentsIndexationService.class);
            try {
                documentsIndexationService.indexDocument(result, fileContent);
                if (log.isDebugEnabled()) {
                    String message = String.format("Document '%s' added to index", documentBean.getName());
                    log.debug((Object)message);
                }
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)"Unable to index new document", (Throwable)e);
            }
        }
        return result;
    }

    public Document createDocumentMetadataFromBean(DocumentBean documentBean, CoselmarUser owner) {
        Preconditions.checkNotNull((Object)documentBean);
        Document document = (Document)this.getDocumentDao().create();
        document.setOwner(owner);
        document.setName(documentBean.getName());
        String privacy = documentBean.getPrivacy().toUpperCase();
        document.setPrivacy(Privacy.valueOf((String)privacy));
        if (StringUtils.equals((CharSequence)Privacy.RESTRICTED.name(), (CharSequence)privacy)) {
            Set authorizedUsers = documentBean.getAuthorizedUsers();
            Set coselmarUsers = this.retrieveUsers((Collection)authorizedUsers);
            CoselmarUserGroup restrictedUsers = (CoselmarUserGroup)this.getCoselmarUserGroupDao().create();
            restrictedUsers.setName(document.getTopiaId());
            restrictedUsers.addAllMembers((Iterable)coselmarUsers);
            document.addRestrictedList(restrictedUsers);
        }
        document.addAllKeywords((Iterable)documentBean.getKeywords());
        Date depositDate = documentBean.getDepositDate();
        if (depositDate != null) {
            document.setDepositDate(new Date(depositDate.getTime()));
        } else {
            document.setDepositDate(new Date());
        }
        document.setType(documentBean.getType());
        document.setSummary(documentBean.getSummary());
        document.setLanguage(documentBean.getLanguage());
        Date publicationDate = documentBean.getPublicationDate();
        if (publicationDate != null) {
            document.setPublicationDate(new Date(publicationDate.getTime()));
        }
        document.setCitation(documentBean.getCitation());
        document.setComment(documentBean.getComment());
        document.setAuthors(documentBean.getAuthors());
        document.setCopyright(documentBean.getCopyright());
        document.setLicense(documentBean.getLicense());
        document.setExternalUrl(documentBean.getExternalUrl());
        return document;
    }

    protected FileInfos manageDocumentFile(UploadFile uploadFile, CoselmarUser owner) {
        Preconditions.checkNotNull((Object)uploadFile);
        String fileName = uploadFile.getName();
        File uploadedFile = uploadFile.getFile();
        String contentType = uploadFile.getContentType();
        if (log.isDebugEnabled()) {
            String message = String.format("File name : %s, content-type : %s", fileName, contentType);
            log.debug((Object)message);
        }
        String filePath = this.getDocumentFileDestPath(owner, fileName);
        File destFile = new File(filePath);
        try {
            FileUtils.moveFile((File)uploadedFile, (File)destFile);
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"error during File transfer", (Throwable)e);
            }
            throw new CoselmarTechnicalException("Internal error during file transfer", (Throwable)e);
        }
        FileInfos fileInfos = new FileInfos();
        fileInfos.setFileName(fileName);
        fileInfos.setMimeType(contentType);
        fileInfos.setFinalFilePath(destFile.getAbsolutePath());
        return fileInfos;
    }

    protected String getDocumentFileDestPath(CoselmarUser owner, String fileName) {
        String userPath = this.getUserDocumentPath(owner);
        String storageFileName = this.getFileStorageName(fileName);
        return userPath + File.separator + storageFileName;
    }

    protected String getFileStorageName(String fileName) {
        Date now = this.getNow();
        String formattedDay = DateUtil.formatDate((Date)now, (String)"yyyyMMddHHmm");
        String prefix = formattedDay + "-";
        return prefix + fileName;
    }

    protected String getUserDocumentPath(CoselmarUser user) {
        File dataDirectory = this.getCoselmarServicesConfig().getDataDirectory();
        String absolutePath = dataDirectory.getAbsolutePath();
        String userFolder = StringUtils.replaceChars((String)(user.getFirstname() + "-" + user.getName()), (String)" ", (String)"_");
        String userPath = absolutePath + File.separator + userFolder;
        return userPath;
    }

    protected boolean isAllowedToAccessDocument(CoselmarUser user, Document document) {
        boolean isAuthorized = false;
        String viewerRole = user.getRole().name().toUpperCase();
        if (DOCUMENT_SUPER_USER_ROLES.contains(viewerRole) || document.getOwner() == user) {
            return true;
        }
        if (document.getPrivacy() == Privacy.PUBLIC) {
            isAuthorized = DOCUMENT_VIEW_ALLOWED_USER_ROLES.contains(viewerRole);
        } else if (document.getPrivacy() == Privacy.PRIVATE) {
            CoselmarUser documentOwner = document.getOwner();
            boolean isOwner = StringUtils.equals((CharSequence)documentOwner.getTopiaId(), (CharSequence)user.getTopiaId());
            isAuthorized = isOwner || Lists.newArrayList((Object[])new String[]{CoselmarUserRole.ADMIN.name(), CoselmarUserRole.SUPERVISOR.name()}).contains(viewerRole);
        } else if (document.getPrivacy() == Privacy.RESTRICTED) {
            Set restrictedLists = document.getRestrictedList();
            for (CoselmarUserGroup restrictedList : restrictedLists) {
                if (!restrictedList.containsMembers(user)) continue;
                isAuthorized = true;
                break;
            }
        }
        return isAuthorized;
    }

    protected String getDocumentFullId(String documentId) {
        return Document.class.getCanonicalName() + this.getPersistenceContext().getTopiaIdFactory().getSeparator() + documentId;
    }

    protected List<String> getDocumentsFullId(List<String> documentShortIds) {
        2 getFullIds = new /* Unavailable Anonymous Inner Class!! */;
        List fullIds = Lists.transform(documentShortIds, (Function)getFullIds);
        return fullIds;
    }

    protected void deleteAttachedFile(Document document) {
        if (StringUtils.isNotBlank((CharSequence)document.getFilePath())) {
            File documentFile = new File(document.getFilePath());
            FileUtils.deleteQuietly((File)documentFile);
            document.setFilePath(null);
            document.setFileName(null);
            document.setWithFile(false);
        }
    }

    protected Set<CoselmarUser> retrieveUsers(Collection<UserBean> userBeans) {
        3 getIds = new /* Unavailable Anonymous Inner Class!! */;
        Collection userIds = Collections2.transform(userBeans, (Function)getIds);
        List coselmarUsers = this.getCoselmarUserDao().forTopiaIdIn(userIds).findAll();
        return new HashSet<CoselmarUser>(coselmarUsers);
    }

    /*
     * Exception decompiling
     */
    protected MassiveDocumentsImportResult importFromZip(File file, CoselmarUser currentUser) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK], 17[CATCHBLOCK], 18[CATCHBLOCK]], but top level block is 10[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void refreshDocumentsIndex() {
        block2: {
            AdminWebService adminWebService = (AdminWebService)this.getServicesContext().newService(AdminWebService.class);
            try {
                adminWebService.refreshDocumentsIndex();
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Unable to refresh Lucene Documents index. Data should be corrupted", (Throwable)e);
            }
        }
    }

    static /* synthetic */ String access$000(DocumentsWebService x0, Class x1, String x2) {
        return x0.getFullIdFromShort(x1, x2);
    }
}

