/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.services.indexation;

import fr.ifremer.coselmar.beans.QuestionBean;
import fr.ifremer.coselmar.beans.QuestionSearchBean;
import fr.ifremer.coselmar.services.CoselmarSimpleServiceSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.misc.HighFreqTerms;
import org.apache.lucene.misc.HighFreqTermsMultiFields;
import org.apache.lucene.misc.TermStats;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.WildcardQuery;

public class QuestionsIndexationService
extends CoselmarSimpleServiceSupport {
    protected static final String QUESTION_ID_INDEX_PROPERTY = "questionId";
    protected static final String QUESTION_TITLE_INDEX_PROPERTY = "questionTitle";
    protected static final String QUESTION_SUMMARY_INDEX_PROPERTY = "questionSummary";
    protected static final String QUESTION_THEME_INDEX_PROPERTY = "questionTheme";
    protected static final String QUESTION_STATUS_INDEX_PROPERTY = "questionStatus";
    protected static final String QUESTION_PRIVACY_INDEX_PROPERTY = "questionPrivacy";
    protected static final String QUESTION_TITLE_CLOUD_TAG_PROPERTY = "questionCloudTagTitle";
    protected static final String QUESTION_SUMMARY_CLOUD_TAG_PROPERTY = "questionCloudTagSummary";
    protected static final String QUESTION_THEME_CLOUD_TAG_PROPERTY = "questionCloudTagTheme";
    protected static final String DOCUMENT_TYPE = "questionindextype";

    public void indexQuestion(QuestionBean question) throws IOException {
        DirectoryReader ireader = DirectoryReader.open((IndexWriter)this.getLuceneUtils().getIndexWriter(), (boolean)false);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BooleanQuery query = new BooleanQuery.Builder().add((Query)new TermQuery(new Term(QUESTION_ID_INDEX_PROPERTY, question.getId())), BooleanClause.Occur.MUST).add((Query)new TermQuery(new Term("type", DOCUMENT_TYPE)), BooleanClause.Occur.MUST).build();
        ScoreDoc[] hits = isearcher.search((Query)query, (int)1000).scoreDocs;
        String questionTitle = question.getTitle();
        String questionSummary = question.getSummary();
        if (hits.length > 0) {
            Set themes;
            Document doc = new Document();
            doc.add((IndexableField)new StringField(QUESTION_ID_INDEX_PROPERTY, question.getId(), Field.Store.YES));
            doc.add((IndexableField)new TextField(QUESTION_TITLE_INDEX_PROPERTY, questionTitle, Field.Store.YES));
            doc.add((IndexableField)new TextField(QUESTION_SUMMARY_INDEX_PROPERTY, questionSummary, Field.Store.YES));
            if (questionTitle.length() >= 3) {
                doc.add((IndexableField)new TextField(QUESTION_TITLE_CLOUD_TAG_PROPERTY, questionTitle, Field.Store.YES));
            }
            if ((themes = question.getThemes()) != null) {
                for (String theme : themes) {
                    doc.add((IndexableField)new TextField(QUESTION_THEME_INDEX_PROPERTY, theme, Field.Store.YES));
                    if (theme.length() < 3) continue;
                    doc.add((IndexableField)new Field(QUESTION_THEME_CLOUD_TAG_PROPERTY, theme, TextField.TYPE_STORED));
                }
            }
            doc.add((IndexableField)new TextField(QUESTION_STATUS_INDEX_PROPERTY, question.getStatus(), Field.Store.YES));
            doc.add((IndexableField)new TextField(QUESTION_PRIVACY_INDEX_PROPERTY, question.getPrivacy(), Field.Store.YES));
            doc.add((IndexableField)new Field("type", DOCUMENT_TYPE, TextField.TYPE_STORED));
            this.getLuceneUtils().getIndexWriter().updateDocument(new Term(QUESTION_ID_INDEX_PROPERTY, question.getId()), (Iterable)doc);
        } else {
            Set themes;
            Document doc = new Document();
            doc.add((IndexableField)new StringField(QUESTION_ID_INDEX_PROPERTY, question.getId(), Field.Store.YES));
            doc.add((IndexableField)new TextField(QUESTION_TITLE_INDEX_PROPERTY, questionTitle, Field.Store.YES));
            doc.add((IndexableField)new TextField(QUESTION_SUMMARY_INDEX_PROPERTY, questionSummary, Field.Store.YES));
            doc.add((IndexableField)new TextField(QUESTION_STATUS_INDEX_PROPERTY, question.getStatus(), Field.Store.YES));
            doc.add((IndexableField)new TextField(QUESTION_PRIVACY_INDEX_PROPERTY, question.getPrivacy(), Field.Store.YES));
            if (questionTitle.length() >= 3) {
                doc.add((IndexableField)new TextField(QUESTION_TITLE_CLOUD_TAG_PROPERTY, questionTitle, Field.Store.YES));
            }
            if ((themes = question.getThemes()) != null) {
                for (String theme : themes) {
                    doc.add((IndexableField)new Field(QUESTION_THEME_INDEX_PROPERTY, theme, TextField.TYPE_STORED));
                    if (theme.length() < 3) continue;
                    doc.add((IndexableField)new Field(QUESTION_THEME_CLOUD_TAG_PROPERTY, theme, TextField.TYPE_STORED));
                }
            }
            doc.add((IndexableField)new Field("type", DOCUMENT_TYPE, TextField.TYPE_STORED));
            this.getLuceneUtils().getIndexWriter().addDocument((Iterable)doc);
        }
        this.getLuceneUtils().getIndexWriter().commit();
        ireader.close();
    }

    public List<String> searchQuestion(QuestionSearchBean searchBean) throws IOException, ParseException {
        List keywords;
        String searchStatus;
        DirectoryReader ireader = DirectoryReader.open((IndexWriter)this.getLuceneUtils().getIndexWriter(), (boolean)false);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        queryBuilder.add((Query)new TermQuery(new Term("type", DOCUMENT_TYPE)), BooleanClause.Occur.MUST);
        String searchPrivacy = searchBean.getPrivacy();
        if (StringUtils.isNotBlank((CharSequence)searchPrivacy)) {
            queryBuilder.add((Query)new TermQuery(new Term(QUESTION_PRIVACY_INDEX_PROPERTY, searchPrivacy.toLowerCase())), BooleanClause.Occur.MUST);
        }
        if (StringUtils.isNotBlank((CharSequence)(searchStatus = searchBean.getStatus()))) {
            queryBuilder.add((Query)new TermQuery(new Term(QUESTION_STATUS_INDEX_PROPERTY, searchStatus.toLowerCase())), BooleanClause.Occur.MUST);
        }
        if ((keywords = searchBean.getFullTextSearch()) != null && !keywords.isEmpty()) {
            BooleanQuery.Builder keywordsQueryBuilder = new BooleanQuery.Builder();
            for (String text : keywords) {
                String[] words = text.replaceAll("[^a-zA-Z ]", "").toLowerCase().split(" ");
                BooleanQuery.Builder nameQueryBuilder = new BooleanQuery.Builder();
                BooleanQuery.Builder summaryQueryBuilder = new BooleanQuery.Builder();
                for (String word : words) {
                    String wildWord = String.format("*%s*", word.toLowerCase());
                    nameQueryBuilder.add((Query)new WildcardQuery(new Term(QUESTION_TITLE_INDEX_PROPERTY, wildWord)), BooleanClause.Occur.MUST);
                    summaryQueryBuilder.add((Query)new WildcardQuery(new Term(QUESTION_SUMMARY_INDEX_PROPERTY, wildWord)), BooleanClause.Occur.MUST);
                }
                BooleanQuery nameQuery = nameQueryBuilder.build();
                BooleanQuery summaryQuery = summaryQueryBuilder.build();
                BooleanQuery query = new BooleanQuery.Builder().add((Query)nameQuery, BooleanClause.Occur.SHOULD).add((Query)summaryQuery, BooleanClause.Occur.SHOULD).add((Query)new TermQuery(new Term(QUESTION_THEME_INDEX_PROPERTY, text.toLowerCase())), BooleanClause.Occur.SHOULD).build();
                keywordsQueryBuilder.add((Query)query, BooleanClause.Occur.MUST);
            }
            BooleanQuery keywordsQuery = keywordsQueryBuilder.build();
            queryBuilder.add((Query)keywordsQuery, BooleanClause.Occur.MUST);
        }
        BooleanQuery fullQuery = queryBuilder.build();
        ScoreDoc[] hits = isearcher.search((Query)fullQuery, (int)1000).scoreDocs;
        ArrayList<String> documentIds = new ArrayList<String>(hits.length);
        for (ScoreDoc hit : hits) {
            Document doc = isearcher.doc(hit.doc);
            String documentId = doc.get(QUESTION_ID_INDEX_PROPERTY);
            documentIds.add(documentId);
        }
        ireader.close();
        return documentIds;
    }

    public void deleteQuestion(String documentId) throws IOException {
        BooleanQuery query = new BooleanQuery.Builder().add((Query)new TermQuery(new Term(QUESTION_ID_INDEX_PROPERTY, documentId)), BooleanClause.Occur.MUST).add((Query)new TermQuery(new Term("type", DOCUMENT_TYPE)), BooleanClause.Occur.MUST).build();
        this.getLuceneUtils().getIndexWriter().deleteDocuments(new Query[]{query});
        this.getLuceneUtils().getIndexWriter().commit();
    }

    protected void cleanIndex() throws IOException {
        BooleanQuery query = new BooleanQuery.Builder().add((Query)new TermQuery(new Term("type", DOCUMENT_TYPE)), BooleanClause.Occur.SHOULD).add((Query)new TermQuery(new Term("type", "question")), BooleanClause.Occur.SHOULD).build();
        this.getLuceneUtils().getIndexWriter().deleteDocuments(new Query[]{query});
        this.getLuceneUtils().getIndexWriter().commit();
    }

    public Map<String, Long> getTopTerms() throws IOException, ParseException {
        DirectoryReader indexReader = DirectoryReader.open((IndexWriter)this.getLuceneUtils().getIndexWriter(), (boolean)false);
        LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
        try {
            TermStats[] highFreqTerms;
            String[] searchedFields = new String[]{QUESTION_TITLE_INDEX_PROPERTY, QUESTION_SUMMARY_INDEX_PROPERTY, QUESTION_THEME_INDEX_PROPERTY};
            for (TermStats termStats : highFreqTerms = HighFreqTermsMultiFields.getHighFreqTermsMultiFields((IndexReader)indexReader, (int)20, (String[])searchedFields, (Comparator)new HighFreqTerms.TotalTermFreqComparator())) {
                long totalTermFreq = termStats.totalTermFreq;
                String value = termStats.termtext.utf8ToString();
                if (result.containsKey(value)) {
                    result.put(value, (Long)result.get(value) + totalTermFreq);
                    continue;
                }
                result.put(value, totalTermFreq);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        indexReader.close();
        return result;
    }

    public Map<String, Long> getTopDocumentsTerms(List<String> questionIds) throws IOException, ParseException {
        DirectoryReader ireader = DirectoryReader.open((IndexWriter)this.getLuceneUtils().getIndexWriter(), (boolean)false);
        IndexSearcher isearcher = new IndexSearcher((IndexReader)ireader);
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        queryBuilder.add((Query)new TermQuery(new Term("type", DOCUMENT_TYPE)), BooleanClause.Occur.MUST);
        for (String questionId : questionIds) {
            if (!StringUtils.isNotBlank((CharSequence)questionId)) continue;
            queryBuilder.add((Query)new TermQuery(new Term(QUESTION_ID_INDEX_PROPERTY, questionId.toLowerCase())), BooleanClause.Occur.SHOULD);
        }
        TopDocs hits = isearcher.search((Query)queryBuilder.build(), 100);
        ScoreDoc[] scoreDocs = hits.scoreDocs;
        System.out.println("hits=" + scoreDocs.length);
        System.out.println("Hits (rank,score,docId)");
        for (int n = 0; n < scoreDocs.length; ++n) {
            ScoreDoc sd = scoreDocs[n];
            float score = sd.score;
            int n2 = sd.doc;
        }
        LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
        ireader.close();
        return result;
    }
}

