/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.services.v1;

import com.auth0.jwt.Algorithm;
import com.auth0.jwt.JWTSigner;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.google.common.base.Preconditions;
import fr.ifremer.coselmar.beans.AbstractMail;
import fr.ifremer.coselmar.beans.LostPasswordMail;
import fr.ifremer.coselmar.beans.UserAccountCreatedMail;
import fr.ifremer.coselmar.beans.UserBean;
import fr.ifremer.coselmar.beans.UserExportModel;
import fr.ifremer.coselmar.beans.UserPasswordChangedMail;
import fr.ifremer.coselmar.beans.UserSearchBean;
import fr.ifremer.coselmar.beans.UserWebToken;
import fr.ifremer.coselmar.config.CoselmarServicesConfig;
import fr.ifremer.coselmar.converter.BeanEntityConverter;
import fr.ifremer.coselmar.exceptions.CoselmarTechnicalException;
import fr.ifremer.coselmar.persistence.SearchRequestBean;
import fr.ifremer.coselmar.persistence.entity.CoselmarUser;
import fr.ifremer.coselmar.persistence.entity.CoselmarUserRole;
import fr.ifremer.coselmar.services.CoselmarWebServiceSupport;
import fr.ifremer.coselmar.services.errors.InvalidCredentialException;
import fr.ifremer.coselmar.services.errors.MailAlreadyExistingException;
import fr.ifremer.coselmar.services.errors.UnauthorizedException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;
import org.debux.webmotion.server.render.Render;
import org.nuiton.csv.Export;
import org.nuiton.csv.ExportModel;
import org.nuiton.topia.persistence.TopiaNoResultException;
import org.nuiton.util.StringUtil;

public class UsersWebService
extends CoselmarWebServiceSupport {
    private static final Log log = LogFactory.getLog(UsersWebService.class);

    public UserBean getUser(String userId) throws InvalidCredentialException, UnauthorizedException, TopiaNoResultException {
        String authorization = this.getContext().getHeader("Authorization");
        UserWebToken userWebToken = this.checkAuthentication(authorization);
        boolean isAdmin = StringUtils.equals((CharSequence)userWebToken.getRole(), (CharSequence)CoselmarUserRole.ADMIN.name());
        boolean isSupervisor = StringUtils.equals((CharSequence)userWebToken.getRole(), (CharSequence)CoselmarUserRole.SUPERVISOR.name());
        boolean isHimself = StringUtils.equals((CharSequence)userWebToken.getUserId(), (CharSequence)userId);
        if (!(isAdmin || isSupervisor || isHimself)) {
            if (log.isDebugEnabled()) {
                String message = String.format("A non admin user try to see account details with shortId '%s'", userId);
                log.debug((Object)message);
            }
            throw new UnauthorizedException("Not allowed to see user details");
        }
        String fullId = CoselmarUser.class.getCanonicalName() + this.getPersistenceContext().getTopiaIdFactory().getSeparator() + userId;
        CoselmarUser user = (CoselmarUser)this.getCoselmarUserDao().forTopiaIdEquals(fullId).findUnique();
        if (isSupervisor && user.getRole() != CoselmarUserRole.CLIENT && !isHimself) {
            if (log.isDebugEnabled()) {
                String message = String.format("A supervisor user try to see non client account details with shortId '%s'", userId);
                log.debug((Object)message);
            }
            throw new UnauthorizedException("Not allowed to see user details");
        }
        UserBean userBean = BeanEntityConverter.toBean((String)userId, (CoselmarUser)user);
        return userBean;
    }

    public List<UserBean> getUsers(UserSearchBean search) throws InvalidCredentialException, UnauthorizedException {
        List userList;
        String authorization = this.getContext().getHeader("Authorization");
        UserWebToken userWebToken = this.checkAuthentication(authorization);
        if (!StringUtils.equals((CharSequence)userWebToken.getRole(), (CharSequence)CoselmarUserRole.ADMIN.name()) && !StringUtils.equals((CharSequence)userWebToken.getRole(), (CharSequence)CoselmarUserRole.SUPERVISOR.name())) {
            if (log.isDebugEnabled()) {
                String message = String.format("A non admin, non supervisor user is trying to access users list", new Object[0]);
                log.debug((Object)message);
            }
            throw new UnauthorizedException("Not allowed to see users");
        }
        if (search != null) {
            SearchRequestBean requestBean = new SearchRequestBean();
            requestBean.setLimit(search.getLimit());
            requestBean.setPage(search.getPage());
            requestBean.setFullTextSearch(search.getFullTextSearch());
            CoselmarUser example = BeanEntityConverter.fromBean((UserBean)search);
            userList = this.getCoselmarUserDao().findAllByExample(example, search.isActiveAndInactive(), requestBean);
        } else {
            userList = this.getCoselmarUserDao().findAll();
        }
        ArrayList<UserBean> result = new ArrayList<UserBean>(userList.size());
        for (CoselmarUser user : userList) {
            String userLightId = this.getPersistenceContext().getTopiaIdFactory().getRandomPart(user.getTopiaId());
            UserBean userBean = BeanEntityConverter.toBean((String)userLightId, (CoselmarUser)user);
            result.add(userBean);
        }
        return result;
    }

    public List<UserBean> getExperts(UserSearchBean search) throws InvalidCredentialException, UnauthorizedException {
        List userList;
        String authorization = this.getContext().getHeader("Authorization");
        CoselmarUser currentUser = this.checkUserAuthentication(authorization);
        if (currentUser.getRole() != CoselmarUserRole.ADMIN && currentUser.getRole() != CoselmarUserRole.SUPERVISOR && currentUser.getRole() != CoselmarUserRole.EXPERT) {
            if (log.isDebugEnabled()) {
                String message = String.format("A non admin, non supervisor, non expert user is trying to access experts list", new Object[0]);
                log.debug((Object)message);
            }
            throw new UnauthorizedException("Not allowed to see experts");
        }
        if (search != null) {
            SearchRequestBean requestBean = new SearchRequestBean();
            requestBean.setLimit(search.getLimit());
            requestBean.setPage(search.getPage());
            requestBean.setFullTextSearch(search.getFullTextSearch());
            CoselmarUser example = BeanEntityConverter.fromBean((UserBean)search);
            example.setRole(CoselmarUserRole.EXPERT);
            userList = this.getCoselmarUserDao().findAllByExample(example, search.isActiveAndInactive(), requestBean);
        } else {
            userList = this.getCoselmarUserDao().forRoleEquals(CoselmarUserRole.EXPERT).findAll();
        }
        ArrayList<UserBean> result = new ArrayList<UserBean>(userList.size());
        for (CoselmarUser user : userList) {
            String userLightId = this.getPersistenceContext().getTopiaIdFactory().getRandomPart(user.getTopiaId());
            UserBean userBean = BeanEntityConverter.toBean((String)userLightId, (CoselmarUser)user);
            result.add(userBean);
        }
        return result;
    }

    public void addUser(UserBean user) throws MailAlreadyExistingException, InvalidCredentialException, UnauthorizedException {
        Preconditions.checkNotNull((Object)user);
        String authorization = this.getContext().getHeader("Authorization");
        UserWebToken userWebToken = this.checkAuthentication(authorization);
        if (!StringUtils.equals((CharSequence)userWebToken.getRole(), (CharSequence)CoselmarUserRole.ADMIN.name()) && StringUtils.equals((CharSequence)userWebToken.getRole(), (CharSequence)CoselmarUserRole.SUPERVISOR.name()) && !StringUtils.equals((CharSequence)user.getRole(), (CharSequence)CoselmarUserRole.CLIENT.name())) {
            if (log.isDebugEnabled()) {
                String message = String.format("A non admin, non supervisor user is trying to create user", new Object[0]);
                log.debug((Object)message);
            }
            throw new UnauthorizedException("Not allowed to add user");
        }
        CoselmarUser userEntity = (CoselmarUser)this.getCoselmarUserDao().create();
        userEntity.setFirstname(user.getFirstName());
        userEntity.setName(user.getName());
        String mail = this.getCleanMail(user.getMail());
        if (StringUtils.isNotBlank((CharSequence)mail)) {
            this.checkMailUniqueness(mail, null);
            userEntity.setMail(mail);
        }
        userEntity.setRole(CoselmarUserRole.valueOf((String)user.getRole().toUpperCase()));
        userEntity.setQualification(user.getQualification());
        userEntity.setOrganization(user.getOrganization());
        userEntity.setActive(true);
        String password = user.getPassword();
        if (StringUtils.isBlank((CharSequence)password)) {
            password = this.getServicesContext().generatePassword();
        }
        String salt = this.getServicesContext().generateSalt();
        String encodedPassword = this.getServicesContext().encodePassword(salt, password);
        userEntity.setPassword(encodedPassword);
        userEntity.setSalt(salt);
        this.commit();
        if (StringUtils.isNotBlank((CharSequence)mail) && StringUtil.isEmail((String)mail)) {
            UserAccountCreatedMail userAccountCreatedMail = new UserAccountCreatedMail(this.getServicesContext().getLocale());
            userAccountCreatedMail.setUser(user);
            userAccountCreatedMail.setPassword(password);
            userAccountCreatedMail.setTo(user.getMail());
            this.sendMail((AbstractMail)userAccountCreatedMail);
        }
    }

    public void modifyUser(UserBean user) throws InvalidCredentialException, UnauthorizedException, InvalidParameterException, TopiaNoResultException, MailAlreadyExistingException {
        String newPassword;
        String phoneNumber;
        String qualification;
        String organization;
        String mail;
        String authorization = this.getContext().getHeader("Authorization");
        UserWebToken userWebToken = this.checkAuthentication(authorization);
        boolean isAdmin = StringUtils.equals((CharSequence)userWebToken.getRole(), (CharSequence)CoselmarUserRole.ADMIN.name());
        boolean isSupervisor4Client = StringUtils.equals((CharSequence)userWebToken.getRole(), (CharSequence)CoselmarUserRole.SUPERVISOR.name()) && StringUtils.equals((CharSequence)user.getRole(), (CharSequence)CoselmarUserRole.CLIENT.name());
        String userId = user.getId();
        if (StringUtils.isBlank((CharSequence)userId)) {
            throw new InvalidParameterException("User.id is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)user.getPassword()) && !isAdmin && !isSupervisor4Client) {
            throw new InvalidParameterException("User.password is mandatory");
        }
        if (!(isAdmin || StringUtils.equals((CharSequence)userWebToken.getUserId(), (CharSequence)userId) || isSupervisor4Client)) {
            if (log.isDebugEnabled()) {
                String message = String.format("A non admin user try to modify account details with shortId '%s'", userId);
                log.debug((Object)message);
            }
            throw new UnauthorizedException("Not allowed to modify user details");
        }
        String fullId = CoselmarUser.class.getCanonicalName() + this.getPersistenceContext().getTopiaIdFactory().getSeparator() + userId;
        CoselmarUser coselmarUser = (CoselmarUser)this.getCoselmarUserDao().forTopiaIdEquals(fullId).findAny();
        if (!isAdmin && !isSupervisor4Client) {
            this.checkPassword(coselmarUser.getPassword(), coselmarUser.getSalt(), user.getPassword());
        }
        if (StringUtils.isNotBlank((CharSequence)(mail = user.getMail()))) {
            this.checkMailUniqueness(mail, fullId);
            coselmarUser.setMail(mail);
        } else {
            coselmarUser.setMail(null);
        }
        String firstName = user.getFirstName();
        if (StringUtils.isNotBlank((CharSequence)firstName)) {
            coselmarUser.setFirstname(firstName);
        } else {
            user.setFirstName(coselmarUser.getFirstname());
        }
        String userName = user.getName();
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            coselmarUser.setName(userName);
        } else {
            user.setName(coselmarUser.getName());
        }
        String userRole = user.getRole();
        if (StringUtils.isNotBlank((CharSequence)userRole) && isAdmin) {
            coselmarUser.setRole(CoselmarUserRole.valueOf((String)userRole.toUpperCase()));
        }
        if (StringUtils.isNotBlank((CharSequence)(organization = user.getOrganization()))) {
            coselmarUser.setOrganization(organization);
        }
        if (StringUtils.isNotBlank((CharSequence)(qualification = user.getQualification()))) {
            coselmarUser.setQualification(qualification);
        }
        if (StringUtils.isNotBlank((CharSequence)(phoneNumber = user.getPhoneNumber()))) {
            coselmarUser.setPhoneNumber(phoneNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)(newPassword = user.getNewPassword()))) {
            String salt = this.getServicesContext().generateSalt();
            String encodedPassword = this.getServicesContext().encodePassword(salt, newPassword);
            coselmarUser.setSalt(salt);
            coselmarUser.setPassword(encodedPassword);
            if ((isAdmin || isSupervisor4Client) && StringUtil.isEmail((String)coselmarUser.getMail())) {
                UserPasswordChangedMail userPasswordChangedMail = new UserPasswordChangedMail(this.getServicesContext().getLocale());
                userPasswordChangedMail.setUser(user);
                userPasswordChangedMail.setPassword(newPassword);
                userPasswordChangedMail.setTo(coselmarUser.getMail());
                this.sendMail((AbstractMail)userPasswordChangedMail);
            }
        }
        boolean active = user.isActive();
        coselmarUser.setActive(active);
        this.commit();
    }

    public Render login(String mail, String password) throws InvalidCredentialException {
        Preconditions.checkNotNull((Object)mail);
        Preconditions.checkNotNull((Object)password);
        CoselmarUser user = (CoselmarUser)this.getCoselmarUserDao().forMailEquals(this.getCleanMail(mail)).addEquals("active", (Object)true).findAnyOrNull();
        if (user == null) {
            throw new InvalidCredentialException("Invalid mail");
        }
        String salt = user.getSalt();
        this.checkPassword(user.getPassword(), salt, password);
        JWTSigner jwtSigner = new JWTSigner(this.getCoselmarServicesConfig().getWebSecurityKey());
        JWTSigner.Options signerOption = new JWTSigner.Options();
        signerOption.setAlgorithm(Algorithm.HS384);
        String userTopiaId = user.getTopiaId();
        String shortId = this.getPersistenceContext().getTopiaIdFactory().getRandomPart(userTopiaId);
        Map claims = UserWebToken.toJwtClaims((String)shortId, (String)user.getFirstname(), (String)user.getName(), (String)user.getRole().name());
        String webToken = jwtSigner.sign(claims, signerOption);
        return this.renderJSON(new Object[]{"jwt", webToken});
    }

    public void deleteUser(String userId) throws InvalidCredentialException, UnauthorizedException {
        String authorization = this.getContext().getHeader("Authorization");
        UserWebToken userWebToken = this.checkAuthentication(authorization);
        boolean isAdmin = StringUtils.equals((CharSequence)userWebToken.getRole(), (CharSequence)CoselmarUserRole.ADMIN.name());
        if (!isAdmin) {
            if (log.isDebugEnabled()) {
                String message = String.format("A non admin user try to delete account with shortId '%s'", userId);
                log.debug((Object)message);
            }
            throw new UnauthorizedException("Not allowed to delete user");
        }
        String fullId = CoselmarUser.class.getCanonicalName() + "_" + userId;
        CoselmarUser user = (CoselmarUser)this.getCoselmarUserDao().forTopiaIdEquals(fullId).findUnique();
        this.getCoselmarUserDao().delete(user);
        this.commit();
    }

    public void generateNewPassword(String userMail) {
        CoselmarUser user = (CoselmarUser)this.getCoselmarUserDao().forMailEquals(userMail).findUnique();
        String password = this.getServicesContext().generatePassword();
        String salt = this.getServicesContext().generateSalt();
        String encodedPassword = this.getServicesContext().encodePassword(salt, password);
        user.setPassword(encodedPassword);
        user.setSalt(salt);
        this.commit();
        LostPasswordMail lostPasswordMail = new LostPasswordMail(this.getServicesContext().getLocale());
        String shortId = this.getPersistenceContext().getTopiaIdFactory().getRandomPart(user.getTopiaId());
        UserBean userBean = BeanEntityConverter.toBean((String)shortId, (CoselmarUser)user);
        lostPasswordMail.setUser(userBean);
        lostPasswordMail.setPassword(password);
        lostPasswordMail.setTo(user.getMail());
        this.sendMail((AbstractMail)lostPasswordMail);
    }

    public Render exportSearchedUsers(String token, UserSearchBean searchOption) throws InvalidCredentialException, UnauthorizedException {
        String exportData;
        List userList;
        CoselmarUser currentUser = this.checkUserAuthentication(token);
        if (currentUser.getRole() != CoselmarUserRole.ADMIN && currentUser.getRole() != CoselmarUserRole.SUPERVISOR) {
            if (log.isDebugEnabled()) {
                String message = String.format("A non admin, non supervisor user is trying to access users list", new Object[0]);
                log.debug((Object)message);
            }
            throw new UnauthorizedException("Not allowed to see users");
        }
        if (searchOption != null) {
            SearchRequestBean requestBean = new SearchRequestBean();
            requestBean.setLimit(searchOption.getLimit());
            requestBean.setPage(searchOption.getPage());
            requestBean.setFullTextSearch(searchOption.getFullTextSearch());
            CoselmarUser example = BeanEntityConverter.fromBean((UserBean)searchOption);
            userList = this.getCoselmarUserDao().findAllByExample(example, searchOption.isActiveAndInactive(), requestBean);
        } else {
            userList = this.getCoselmarUserDao().findAll();
        }
        ArrayList<UserBean> users = new ArrayList<UserBean>(userList.size());
        for (CoselmarUser user : userList) {
            String userLightId = this.getPersistenceContext().getTopiaIdFactory().getRandomPart(user.getTopiaId());
            UserBean userBean = BeanEntityConverter.toBean((String)userLightId, (CoselmarUser)user);
            users.add(userBean);
        }
        UserExportModel exportModel = new UserExportModel();
        try {
            exportData = Export.exportToString((ExportModel)exportModel, users);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error during export", (Throwable)e);
            }
            throw new CoselmarTechnicalException("Unable to export datas");
        }
        return this.renderDownload(IOUtils.toInputStream((String)exportData), "export-users-result.csv", "text/csv");
    }

    protected void checkMailUniqueness(String mail, String userId) throws MailAlreadyExistingException {
        boolean mailAlreadyUsed = StringUtils.isNotBlank((CharSequence)userId) ? this.getCoselmarUserDao().forMailEquals(mail).addNotEquals("topiaId", (Object)userId).exists() : this.getCoselmarUserDao().forMailEquals(mail).exists();
        if (mailAlreadyUsed) {
            String msg = String.format("mail '%s' is already used", mail);
            throw new MailAlreadyExistingException(msg);
        }
    }

    protected void checkPassword(String currentPassword, String salt, String password) throws InvalidCredentialException {
        String encodedPassword = this.getServicesContext().encodePassword(salt, password);
        if (!encodedPassword.equals(currentPassword)) {
            throw new InvalidCredentialException("Invalid password given");
        }
    }

    protected void sendMail(AbstractMail mail) {
        if (this.getCoselmarServicesConfig().isDevMode()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("an email should have been sent if not in devMode: to = " + mail.getTo() + ". subject = '" + mail.getSubject() + "'. body = \n" + this.getBody(mail)));
            }
            if (!mail.isRecipientProvided() && log.isWarnEnabled()) {
                log.warn((Object)("email has no recipient, would not have been sent " + mail));
            }
        } else {
            CoselmarServicesConfig applicationConfig = this.getCoselmarServicesConfig();
            mail.setCoselmarUrl(applicationConfig.getApplicationUrl());
            String body = this.getBody(mail);
            if (mail.isRecipientProvided()) {
                SimpleEmail newEmail = new SimpleEmail();
                newEmail.setHostName(applicationConfig.getSmtpHost());
                newEmail.setSmtpPort(applicationConfig.getSmtpPort());
                newEmail.setCharset(Charsets.UTF_8.name());
                newEmail.setSubject(mail.getSubject());
                try {
                    newEmail.setFrom(applicationConfig.getSmtpFrom());
                    String to = mail.getTo();
                    newEmail.addTo(to);
                    newEmail.setMsg(body);
                    newEmail.send();
                }
                catch (EmailException e) {
                    throw new CoselmarTechnicalException((Throwable)e);
                }
            } else if (log.isErrorEnabled()) {
                log.error((Object)("email has no recipient, won't be sent " + mail));
            }
        }
    }

    protected String getBody(AbstractMail mail) {
        Mustache mustache = this.getMustache(mail);
        StringWriter stringWriter = new StringWriter();
        mustache.execute((Writer)stringWriter, (Object)mail);
        return stringWriter.toString();
    }

    protected Mustache getMustache(AbstractMail mail) {
        Mustache mustache;
        DefaultMustacheFactory mustacheFactory = new DefaultMustacheFactory("mail/");
        Locale locale = mail.getLocale();
        String templateName = mail.getClass().getSimpleName() + "_" + locale.getLanguage() + ".mustache";
        try {
            mustache = mustacheFactory.compile(templateName);
        }
        catch (MustacheException e) {
            templateName = mail.getClass().getSimpleName() + ".mustache";
            mustache = mustacheFactory.compile(templateName);
        }
        return mustache;
    }
}

