/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.services.indexation;

import fr.ifremer.coselmar.services.CoselmarSimpleServiceSupport;
import java.io.IOException;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.misc.HighFreqTerms;
import org.apache.lucene.misc.HighFreqTermsMultiFields;
import org.apache.lucene.misc.TermStats;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class TransverseIndexationService
extends CoselmarSimpleServiceSupport {
    protected void cleanAllIndex() throws IOException {
        BooleanQuery query = new BooleanQuery.Builder().add((Query)new TermQuery(new Term("type", "questionindextype")), BooleanClause.Occur.SHOULD).add((Query)new TermQuery(new Term("type", "documentindextype")), BooleanClause.Occur.SHOULD).add((Query)new TermQuery(new Term("type", "question")), BooleanClause.Occur.SHOULD).add((Query)new TermQuery(new Term("type", "document")), BooleanClause.Occur.SHOULD).build();
        this.getLuceneUtils().getIndexWriter().deleteDocuments(new Query[]{query});
        this.getLuceneUtils().getIndexWriter().commit();
    }

    public Map<String, Long> getTopTerms() throws IOException, ParseException {
        DirectoryReader indexReader = DirectoryReader.open((IndexWriter)this.getLuceneUtils().getIndexWriter(), (boolean)false);
        LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
        try {
            TermStats[] highFreqTerms;
            String[] searchedFields = new String[]{"questionTitle", "questionSummary", "questionTheme", "documentName", "documentSummary", "documentKeyword"};
            for (TermStats termStats : highFreqTerms = HighFreqTermsMultiFields.getHighFreqTermsMultiFields((IndexReader)indexReader, (int)20, (String[])searchedFields, (Comparator)new HighFreqTerms.TotalTermFreqComparator())) {
                long totalTermFreq = termStats.totalTermFreq;
                String value = termStats.termtext.utf8ToString();
                if (result.containsKey(value)) {
                    result.put(value, (Long)result.get(value) + totalTermFreq);
                    continue;
                }
                result.put(value, totalTermFreq);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        indexReader.close();
        return result;
    }
}

