/*
 * #%L
 * Coselmar :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
var coselmarServices = angular.module('coselmarServices', ['ngResource']);

coselmarServices.factory('documentService', ['$resource', 'coselmar-config', function($resource, coselmarConfig){
	return new Document($resource, coselmarConfig);
}]);

function Document(resource, config){

	this.resource = resource;

	var baseURL = config.BASE_URL + "/documents";

	this.createDocument = function(metadata, file, successFunction, failFunction) {

		var formData = new FormData();
		if (file) {
			formData.append("uploadFile", file);
		}
		formData.append("document", JSON.stringify(metadata));

		// Save the document
		var docResource = resource(baseURL, null, {
			'upload': {
			  method:'POST',
			  transformRequest: angular.identity,
			  headers:{
				'Content-Type':undefined
			  }
			}
		});
		docResource.upload(null, formData, successFunction, failFunction);
	};

	this.getDocument = function(id, scope){
		// Load the document
		var docResource = resource(baseURL + '/:documentId', {documentId:'@documentId'});
		docResource.get({documentId:id}, function(document){
		console.log(document);
			scope.document = document;
		});
	};

	this.deleteDocument = function(id, scope, successFunction){

		// Load the document
		var docResource = resource(baseURL + '/:documentId', {documentId:'@id'});
		docResource.delete({documentId:id}, successFunction);
	};

	this.getDocumentFile = function(id, scope){
		// Load the document
		var docResource = resource(baseURL + '/:documentId/file', {documentId:'@documentId'});
		docResource.get({documentId:id}, function(file){
			// redirect to document page ?
		});
	};

	this.getDocuments = function(searchKeywords, successFunction){
		// Load all documents

		var docResource = resource(baseURL, {searchKeywords : searchKeywords});
		docResource.query(successFunction);
	};

	this.findAllTypes = function(successFunction){
		var docResource = resource(baseURL + '/types');
		docResource.query(successFunction);
	};

	this.findAllKeywords = function(successFunction){
		var docResource = resource(baseURL + '/keywords');
		docResource.query(successFunction);
	};

};