/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.offer.widgets;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.OfferListColumnFactory;
import com.jurismarches.vradi.ui.offer.models.OfferListTableModel;
import com.jurismarches.vradi.ui.offer.widgets.*;
import com.jurismarches.vradi.ui.search.PaginationUI;
import com.jurismarches.vradi.ui.search.SearchHandler;
import com.jurismarches.vradi.ui.search.SearchUI;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class SelectFormUI extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_FORM_ID = "formId";
    public static final String PROPERTY_OFFER_LIST_COLUMN_FACTORY = "offerListColumnFactory";
    public static final String PROPERTY_RESULT_TABLE_MODEL = "resultTableModel";
    public static final String PROPERTY_SELECTED = "selected";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1aTW/byBmmFUu2/BXHju1NnGRtJ1gku2s62S36lUV3bVVy7CqJISltsD54R+RImoTiMMOhLa+Roj+hP6G991Kgt56KHvbcQy9F/0JR9NBr0XdmRPHDlERLGyCKNPO+zzzPw3mHQ07+8C8t6zJt8w3qdHTm2Zy0sX64+/r1y/obbPCfY9dgxOGUaerPREbLHGuzZq/d5dr947JI3+mm7xRo26E2tkPZT8vajMvPLey2MOZcuxvNMFx3p9rrftpxPOaj9kglof7uP//O/Nb8ze8zmtZxgN08SNkYlhUomSxrGWJybQlGOkU7FrKbQIMRuwl850VbwUKu+wK18Tvt19pUWcs5iAEY17bSS5YYMr/jcG3OxRYYW6Ks/eqAaz8waFt/4zHithEzWtjVTxkyie4RnTYamOlnxGxi7urVUJrjSLwc13INaDgACYuCrS4U6EpBEDOtRsQQdSOI2qPUwsgOwlbleGXi8gK1vLZdQgaoOOfaD4dRfJmYGCAvMux6Fq+huoWfUxNbXPvpMMy2iHMD6CA5wJ11sUg+QraAXBLaOrp7BuL1Q9ko4vKBDw9U62Px+3a0b/7BYdVg1LJExGOurUXAgi4Rvh4QCAnj2sepfJLBIv9uD2bOQU1iI06oLabEdn8cJVg/CsVHGU09kPig4INIGSghvbED4fkHh3se59SGlOWIaNUswj66HP1ENHzS7WTaemQwqGY9qOag3CaOtSzzoBnYHV9eACrQpUr/g1jpC0DZ+7/V5b//+Z9/Kvn1/hMYeyUxNLRcQR06jDqYcSKGvq6K3ePE2nmOnKfHWl4ViFzL7iQQq3a7gRyMp2pIpOvPkNsCiOzUP/7y19Vv/nZNy5S0GYsiU5XAgZbnLZgiLWqZHefLrySjubNp+FyEv9fAzwZEczV9sg1kufBvjjronRdqmK9TZmJ2hIgti1i1d8CnOwk+9cjW89/9d7n6x698ryaA+62+4YFf2a+1HLEtYmO5OnYXvsTVcNZxsWfSYIFLWvI0WPSmD2uw3Owh1i3ez+Xnj5IsWTQosLM96rlldE5htmmTnAk/lmCBrVHPaBU7DrJN5Vq3b9YkpwRMqpJv4VfmyWcdT4zwpdQtvu0KGjOHVcciXBTyECKTUA0tysi3QAZZuxZp2m257t+/CBdJVXwWqO1yZMMaXSi+qBUr78V1hbxtV5H5DEprNQCr4Q4/oi4R5Quz8eKwjOrYCnJnZe4ZJs2W0F4XkydJTE4lwrcsJxyqaiQ9m4P0lIul2pXUzPtquplX15KXWsq4wUfTszVIT+Vg/9nVBC34gvzUqyuakYoqImGgpIx/IUGaWvDlL/0MW3BDgNYVEzcQ3G4KFnXxS1jPkOK4bNITm/IWSD2h9okhui9zAtVtWEFKDMrXGTL7J4DKSUuyX7zYgvuOyNTBYG/rfRLypOgaBnpNFCuYC3NeyRNJeoMIwdNtG7epTQyuTZSCwVeig8vgZAbTor8E3elZ3Iqx0Hv7nyiflwGfDxP4BGnJzJZFZLVFz3pbGbF/G0wy2yN5W5GE2wlcah2WxgZpev6FD7MswERTUQdiAdVyKhYmLIeVt0acmsS71x8PppsTSL2fJDUSnyx3xb8QhXBsesGr8atiUQPFp0hcbJ4zZLsW4jiuty+cr/NOkk4VlCxw0RdYhl20h5pDZxxom8K2uFvBvfvJxSYyDOzwshziIWztlVEPH+nwvdv66NONrQY7KVW2Hr2PO9O9dIqi3mAxK6bIkx/b26I5asTt5OzoRU+c373YZD+W4n6UKsMcyY3mCLZP9veGOuK9jc6VV4kGiagUBnlv0xvkvU1p0KtfpDCoK3EtwqrhWRY8XmIsdJwSl8gt0NLFJnFf2SY2KFQbNh8Ki8IWHMUsmAnjRF1Y7zNe1IaNJBuC4CE+lHqB6X24FeFlw0MvSnDixsVgI17EjFiEJ+BTvN3fjrt9h40a8lHivIiBJ9ty07flRQg9/Xp5I8IQd0js7vU6JnlShURlrlwCicq7nSRPhCVLmvMlFSFkxG0BmBEV8nzAtgCCB20LoDs9i6UQC2WIGyWyGxBZixFR8clUZkXErgJMz2YxzMZsE7svl/R7pbxkIsDS87gR4mFYRG61Y3fkUUy53qNSkKCjGdNk1HOifPZH47PQ47MvMNPTWY7N3dq5039bexVG8z1GV5vGN0OEOm2ryhlG7UtLwyiMlnqMXvu4o80jeCjjXqy4quPOo6oEHc0n3sIu8licU21cn2o+7mjTG8N4VpRSceS6Lwqw9DxW4zySVqERiz8otiuSWguRIm2HMl7siM8oq4NRPJK7+4MQZnpW9/qwghvlZXLF0SybkZfw+yKmfvR17crElG/piX3YjxjDBHZxnSizyhj33YoCHG0vosYMU8H9p5ZoHbAXeSbOL0bc3CXyiG7uVMigzZ2IGLy5kxH9Zcz5MsaR4hIeuz26cSkqZJAUEZFCiggbIqUKIemlLEVYoLp8Rx3blUW0ZLsxia8mwjBRNetJamTcgK2CkLMrYlI8W+Ub1PDc6OlDhPi0fJdYQ/U49+jj2DuP8Ge9eXVdnJXRU8yK/iP+4IOMQPC9QHCdmudKsE+hT1H53cPkZriWs7rnCesXNj7b2KMddcDwUEirI/bpxmPxwOizWQ7YdAOSKUx1e1O8VO0xWPjCRBxt1GFVInbzZ5dgJ8TnTJrXtG1qInH4+YU6stlAnDNS9zgeB1S+eIbuzMLoIAt2XexY3SNxwZsSbToZbTUF2owDGDUq3qOOhSSSpwYg3Bob4U4ab5DHaQWLAwhxpD0AbTMF2k1DHrsXoGKh9H6pXoaMiTlvhI/yxwTLNxkxC9SibEygteCYRh3Jd5eYMWGz8j8bjOuYOkSG9fB7uKTTLkz0fUbGVTZJDHmE3w/j4zQY4q43YDEYjiGSKwNYbKdg4b8wHgtGJP9qgBSB8H9Yz0gkESUAAA==";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.offer.widgets.SelectFormUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.lang.String formId;
    protected com.jurismarches.vradi.ui.offer.OfferListColumnFactory offerListColumnFactory;
    protected com.jurismarches.vradi.ui.search.PaginationUI paginationUI;
    protected com.jurismarches.vradi.ui.offer.OfferTable resultTable;
    protected com.jurismarches.vradi.ui.offer.models.OfferListTableModel resultTableModel;
    protected javax.swing.JPanel searchPanel;
    protected SelectFormUI selectFormUI = this;
    protected java.lang.Boolean selected;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JPanel $JPanel0;
    private javax.swing.JScrollPane $JScrollPane0;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    public SearchHandler getSearchHandler() {
        return UIHelper.getHandler(this, SearchHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    public SearchUI getSearchUI() {
        return (SearchUI) searchPanel.getComponent(0);
    }
    
    void $afterCompleteSetup() {
        OfferListTableModel.OfferListTableModelBinding djb = new OfferListTableModel.OfferListTableModelBinding(this,
                "resultTableModel", resultTableModel) {
    
            @Override
            public void processDataBinding() {
                if (resultTableModel != null) {
                    SearchUI searchUI = getSearchUI();
                    getSearchHandler().executeQuery(searchUI);
                }
            }
        };
    
        // Add listener select
        resultTable.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
    
            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel selectionModel = (ListSelectionModel)e.getSource();
                int selectionIndex = selectionModel.getLeadSelectionIndex();
                setSelected(selectionIndex != -1);
            }
        });
    
        registerDataBinding(djb);
        djb.applyDataBinding();
    
        validate();
        this.pack();
    
        // Register for save disposition
        UIHelper.registerComponentToSaveDispositionConfig(this);
    }
    
    protected void selectAndClose() {
        int selectedRow = resultTable.getSelectedRow();
        setFormId(resultTableModel.getFormIdAt(selectedRow));
        close();
    }
    
    protected void close() {
       setVisible(false);
       dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SelectFormUI() {
        $initialize();
    }

    public SelectFormUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        close();
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        selectAndClose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public java.lang.String getFormId() {
        return formId;
    }

    public com.jurismarches.vradi.ui.offer.OfferListColumnFactory getOfferListColumnFactory() {
        return offerListColumnFactory;
    }

    public com.jurismarches.vradi.ui.search.PaginationUI getPaginationUI() {
        return paginationUI;
    }

    public com.jurismarches.vradi.ui.offer.OfferTable getResultTable() {
        return resultTable;
    }

    public com.jurismarches.vradi.ui.offer.models.OfferListTableModel getResultTableModel() {
        return resultTableModel;
    }

    public javax.swing.JPanel getSearchPanel() {
        return searchPanel;
    }

    public java.lang.Boolean getSelected() {
        return selected;
    }

    public java.lang.Boolean isSelected() {
        return selected !=null && selected;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setFormId(java.lang.String newValue) {
        java.lang.String oldValue = this.formId;
        this.formId = newValue;
        firePropertyChange(PROPERTY_FORM_ID, oldValue, newValue);
    }

    public void setOfferListColumnFactory(com.jurismarches.vradi.ui.offer.OfferListColumnFactory newValue) {
        com.jurismarches.vradi.ui.offer.OfferListColumnFactory oldValue = this.offerListColumnFactory;
        this.offerListColumnFactory = newValue;
        firePropertyChange(PROPERTY_OFFER_LIST_COLUMN_FACTORY, oldValue, newValue);
    }

    public void setResultTableModel(com.jurismarches.vradi.ui.offer.models.OfferListTableModel newValue) {
        com.jurismarches.vradi.ui.offer.models.OfferListTableModel oldValue = this.resultTableModel;
        this.resultTableModel = newValue;
        firePropertyChange(PROPERTY_RESULT_TABLE_MODEL, oldValue, newValue);
    }

    public void setSelected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.selected;
        this.selected = newValue;
        firePropertyChange(PROPERTY_SELECTED, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToSelectFormUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(searchPanel, BorderLayout.NORTH);
        add($JPanel0, BorderLayout.CENTER);
        add($Table0, BorderLayout.SOUTH);
    }

    protected void createFormId() {
        $objectMap.put("formId", formId = null);
    }

    protected void createOfferListColumnFactory() {
        $objectMap.put("offerListColumnFactory", offerListColumnFactory = getContextValue(OfferListColumnFactory.class));
    }

    protected void createPaginationUI() {
        $objectMap.put("paginationUI", paginationUI = new com.jurismarches.vradi.ui.search.PaginationUI(this));
        
        paginationUI.setName("paginationUI");
    }

    protected void createResultTable() {
        $objectMap.put("resultTable", resultTable = new com.jurismarches.vradi.ui.offer.OfferTable());
        
        resultTable.setName("resultTable");
    }

    protected void createResultTableModel() {
        $objectMap.put("resultTableModel", resultTableModel = getContextValue(OfferListTableModel.class));
    }

    protected void createSearchPanel() {
        $objectMap.put("searchPanel", searchPanel = new javax.swing.JPanel());
        
        searchPanel.setName("searchPanel");
        searchPanel.setLayout(new BorderLayout());
    }

    protected void createSelected() {
        $objectMap.put("selected", selected = false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToSelectFormUI();
        // inline complete setup of $JPanel0
        $JPanel0.add($JScrollPane0, BorderLayout.CENTER);
        $JPanel0.add(paginationUI, BorderLayout.SOUTH);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(resultTable);
        // inline complete setup of $Table0
        $Table0.add($JButton0, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JButton1, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 15 property setters
        resultTableModel.setNbFormsPerPage(10);
        resultTableModel.setPageToShow(1);
        resultTable.setAutoResizeMode(2);
        resultTable.setColumnControlVisible(true);
        resultTable.setColumnFactory(offerListColumnFactory);
        resultTable.setGridColor(Color.GRAY);
        resultTable.setHorizontalScrollEnabled(true);
        resultTable.setModel(resultTableModel);
        resultTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        resultTable.setShowGrid(true);
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("close"));
        $JButton1.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("accept"));
        // late initializer
        selectFormUI.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("selectFormUI", this);
        createFormId();
        createSelected();
        createOfferListColumnFactory();
        createResultTableModel();
        createSearchPanel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createResultTable();
        createPaginationUI();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.common.close"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(_("vradi.action.select"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of selectFormUI
        setName("selectFormUI");
        selectFormUI.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(_("vradi.selectForm.title"));
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_ENABLED, true ,"selected") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setEnabled(isSelected());
            }
        });
    }

}