/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: RelatedFormHandler.java 1800 2010-11-17 20:58:35Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.4.0/vradi-swing/src/main/java/com/jurismarches/vradi/ui/offer/widgets/RelatedFormHandler.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.offer.widgets;

import com.jurismarches.vradi.entities.FormLink;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.OfferListHandler;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.List;

import static org.nuiton.i18n.I18n._;

/**
 * @author sletellier
 */
public class RelatedFormHandler extends MultipleSelectionHandler {

    /**
     * Logger
     */
    static private final Log log = LogFactory.getLog(RelatedFormHandler.class);

    protected FormLinkCellRenderer linkCellRenderer;
    
    public RelatedFormHandler(MultipleSelectionPane ui) {
        super(ui);
        ui.setLbl(_("vradi.offerEdit.relatedForm"));
        linkCellRenderer = new FormLinkCellRenderer(ui); 
        ui.getList().setCellRenderer(linkCellRenderer);
    }

    @Override
    public void init() {
        List<String> relatedFormsLinkIds = null;
        String wikittyId = getBean().getWikittyId();
        try {
            relatedFormsLinkIds = VradiService.getVradiDataService().getRelatedFormsLinkIds(wikittyId);
        } catch (VradiException eee) {
            log.error("Cant get related form for form id : " + wikittyId, eee);
            ErrorDialogUI.showError(eee);
        }
        fillList(relatedFormsLinkIds);
    }

    @Override
    public void add() {
        FormLink formLink = getHandler().addRelatedForm(ui, getBean());
        if (formLink != null) {
            addToList(formLink, formLink.getWikittyId());
            linkCellRenderer.addAdded(formLink);
        }
    }

    @Override
    public void remove() {
        List<String> formLinkIds = getHandler().removeLinkForm(getSelectedInList());
        removeFromList(formLinkIds);
    }

    @Override
    public void openSelected(String selected) {
        OfferListHandler listHandler = UIHelper.getHandler(ui, OfferListHandler.class);
        if (selected != null) {
            FormLink formLink = VradiService.getWikittyProxy().restore(FormLink.class, selected);
            if (formLink != null) {
                listHandler.addEditPane(ui, formLink.getToForm());
            }
        }
    }
}
