/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: MultipleSelectionHandler.java 1800 2010-11-17 20:58:35Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.4.0/vradi-swing/src/main/java/com/jurismarches/vradi/ui/offer/widgets/MultipleSelectionHandler.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.offer.widgets;

import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.OfferEditHandler;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import jaxx.runtime.SwingUtil;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/**
 * @author sletellier
 */
public abstract class MultipleSelectionHandler<B> {

    protected MultipleSelectionPane ui;
    protected List<B> addedDatas;

    public MultipleSelectionHandler(MultipleSelectionPane ui) {
        this.ui = ui;
        addedDatas = new ArrayList<B>();
    }

    public OfferEditHandler getHandler() {
        return UIHelper.getHandler(ui, OfferEditHandler.class);
    }

    protected JList getList() {
        return ui.getList();
    }

    protected DefaultListModel getListModel() {
        return ui.getListModel();
    }

    protected Form getBean() {
        return ui.getBean();
    }

    public List<B> getAddedDatas() {
        return addedDatas;
    }

    public abstract void init();

    public abstract void add();

    public abstract void remove();

    public abstract void openSelected(String selected);

    protected void addToList(B addedData, String data) {
        if (data != null) {
            getListModel().addElement(data);
        }
        if (addedData != null) {
            addedDatas.add(addedData);
        }
    }

    protected void removeFromList(List<String> datas) {
        for (String data : datas) {
            getListModel().removeElement(data);
        }
    }

    protected void removeFromList(String data) {
        getListModel().removeElement(data);
    }

    protected void fillList(Collection<String> datas) {
        getList().removeAll();
        SwingUtil.fillList(getList(), datas, null);
    }

    protected java.util.List<String> getSelectedInList() {
        Object[] objects = getList().getSelectedValues();
        String[] selected = new String[objects.length];
        int cnt = 0;
        for (Object o : objects) {
            selected[cnt] = (String)o;
            cnt++;
        }
        java.util.List<String> selectedList = Arrays.asList(selected);
        return selectedList;
    }
}
