/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: AdminCellRenderer.java 1768 2010-11-15 09:38:53Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.4.0/vradi-swing/src/main/java/com/jurismarches/vradi/ui/admin/renderers/AdminCellRenderer.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.renderers;

import java.awt.Component;

import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.ui.admin.helpers.AdminNavigationTreeHelper;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.decorator.DecoratorProvider;

import jaxx.runtime.swing.nav.tree.AbstractNavTreeCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.jurismarches.vradi.ui.admin.helpers.AdminBeanConstant;

import static org.nuiton.i18n.I18n._;

/**
 * @author letellier
 * @see AbstractNavTreeCellRenderer
 */
public class AdminCellRenderer extends AbstractNavTreeCellRenderer<DefaultTreeModel, VradiTreeNode> {

    /** serialVersionUID. */
    private static final long serialVersionUID = 7917305304778635796L;

    /** Logger */
    protected static final Log log = LogFactory.getLog(AdminCellRenderer.class);

    protected DecoratorProvider decoratorProvider;

    /**
     * Init renderer.
     * 
     * @param decoratorProvider ???
     * @param dataProvider data provider
     */
    public AdminCellRenderer(DecoratorProvider decoratorProvider,
                             VradiDataProvider dataProvider) {

        setDataProvider(dataProvider);
        this.decoratorProvider = decoratorProvider;
    }

    // Override to decorate User category node
    @Override
    public String getNodeText(VradiTreeNode node) {
        if (node == null) {
            return null;
        }
        String text;

        if (node.isDirty() || !renderCache.containsKey(node)) {

            // calculer le rendu du noeud
            if (node.isStringNode()) {
                String id = node.getId();
                if (id.matches(".+" + AdminBeanConstant.USER.getCategoryName())) {
                    text = _(AdminBeanConstant.USER.getCategoryName());
                } else {
                    text = _(id);
                }

            } else {

                text = computeNodeText(node);
            }

            if (log.isDebugEnabled()) {
                log.debug("text for node [" + node + "] = <" + text + ">");
            }

            // sauvegarde dans le cache
            renderCache.put(node, text);

            // le noeud est de nouveau propre
            node.setDirty(false);

        } else {

            // recupération directement du rendu dans le cache
            text = renderCache.get(node);
        }

        return text;
    }

    @Override
    protected String computeNodeText(VradiTreeNode node) {

        // Get node type
        Class<?> editType = node.getInternalClass();
        String id = node.getId();

        // get decorator
        Decorator<?> decorator = decoratorProvider.getDecorator(editType);

        // for user
        if (editType.equals(User.class)) {

            // And if its client ui
            VradiTreeNode clientCategoryNode = AdminNavigationTreeHelper.getParentCategoryNode(node, AdminBeanConstant.CLIENT.getCategoryName());
            if (clientCategoryNode != null) {

                // Decorate with user name only
                decorator = decoratorProvider.getDecorator(User.class, VradiConstants.USER_ONLY_DECORATOR);
            }
        }

        Object toDecorate = AdminBeanConstant.getConstantByBeanClass(editType).
                getBean(((VradiDataProvider)getDataProvider()).getWikittyProxy(), id);

        // Get decorated value
        String decorated = decorator.toString(toDecorate);

        if (log.isDebugEnabled()) {
            log.debug("Compute text for node " + node + " return " + decorated);
        }

        return decorated;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree,
                                                  Object value,
                                                  boolean sel,
                                                  boolean expanded,
                                                  boolean leaf, int row,
                                                  boolean hasFocus) {

        // get node
        VradiTreeNode node = (VradiTreeNode)value;

        // get text for node
        String text = getNodeText(node);

        // Render node
        return super.getTreeCellRendererComponent(tree, text, sel,
                                                  expanded, leaf,
                                                  row, hasFocus);
    }
}
