/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class RequestSelectUI extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_QUERY_DESCRIPTION_TEXT = "queryDescription.text";
    public static final String BINDING_QUERY_DESCRIPTION_TOOL_TIP_TEXT = "queryDescription.toolTipText";
    public static final String BINDING_QUERY_NAME_TEXT = "queryName.text";
    public static final String BINDING_QUERY_NAME_TOOL_TIP_TEXT = "queryName.toolTipText";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_TOOL_TIP_TEXT = "$JButton0.toolTipText";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.RequestSelectUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.beans.QueryBean bean;
    protected javax.swing.JTextArea queryDescription;
    protected javax.swing.JTextField queryName;
    protected RequestSelectUI requestSelectUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JButton $JButton0;
    private javax.swing.JButton $JButton1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    public void confirmDeletion() {
        com.jurismarches.vradi.beans.QueryBean queryBean = getBean();
        if (StringUtils.isBlank(queryBean.getName())
                && StringUtils.isBlank(queryBean.getDescription())
                && StringUtils.isBlank(queryBean.getQuery())) {
            setBean(null);
            
        } else {
            int confirm = JOptionPane.showConfirmDialog(this,
                    _("vradi.admin.confirmDelete", VradiHelper.getEntityName(getBean())),
                    _("vradi.admin.deleteTitle"), JOptionPane.YES_NO_OPTION);
        
            if (confirm == JOptionPane.YES_OPTION) {
                setBean(null);
            }
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public RequestSelectUI() {
        $initialize();
    }

    public RequestSelectUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        getHandler().openRequest(this, getBean());
    }

    public void doActionPerformed__on__$JButton1(java.awt.event.ActionEvent event) {
        confirmDeletion();
    }

    public void doKeyReleased__on__queryDescription(java.awt.event.KeyEvent event) {
        setBean(getBean().setDescription(queryDescription.getText()));
    }

    public void doKeyReleased__on__queryName(java.awt.event.KeyEvent event) {
        setBean(getBean().setName(queryName.getText()));
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.beans.QueryBean getBean() {
        return bean;
    }

    public javax.swing.JTextArea getQueryDescription() {
        return queryDescription;
    }

    public javax.swing.JTextField getQueryName() {
        return queryName;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.beans.QueryBean newValue) {
        com.jurismarches.vradi.beans.QueryBean oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected javax.swing.JButton get$JButton1() {
        return $JButton1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToRequestSelectUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.3, 0.0, 11, 2, new Insets(0, 6, 0, 0), 0, 0));
        add($JLabel1, new GridBagConstraints(1, 0, 3, 1, 0.7, 0.0, 11, 2, new Insets(0, 6, 0, 0), 0, 0));
        add(queryName, new GridBagConstraints(0, 1, 1, 1, 0.3, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane0, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton0, new GridBagConstraints(2, 1, 1, 1, 0.1, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JButton1, new GridBagConstraints(3, 1, 1, 1, 0.1, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = new com.jurismarches.vradi.beans.QueryBean());
    }

    protected void createQueryDescription() {
        $objectMap.put("queryDescription", queryDescription = new javax.swing.JTextArea());
        
        queryDescription.setName("queryDescription");
        queryDescription.setColumns(15);
        queryDescription.setLineWrap(true);
        queryDescription.setWrapStyleWord(true);
        queryDescription.setRows(2);
        queryDescription.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__queryDescription"));
    }

    protected void createQueryName() {
        $objectMap.put("queryName", queryName = new javax.swing.JTextField());
        
        queryName.setName("queryName");
        queryName.setColumns(15);
        queryName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__queryName"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToRequestSelectUI();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(queryDescription);
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        $JButton1.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("delete"));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("requestSelectUI", this);
        createBean();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.requestSelectUI.name"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.requestSelectUI.description"));
        createQueryName();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createQueryDescription();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.adminRequest.edit"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new javax.swing.JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setToolTipText(_("vradi.adminRequest.remove"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of requestSelectUI
        setName("requestSelectUI");
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUERY_NAME_TOOL_TIP_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    queryName.setToolTipText(_(getBean().getQuery()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUERY_NAME_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(queryName, getBean().getName());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUERY_DESCRIPTION_TOOL_TIP_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    queryDescription.setToolTipText(_(getBean().getQuery()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_QUERY_DESCRIPTION_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    jaxx.runtime.SwingUtil.setText(queryDescription, getBean().getDescription());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_TOOL_TIP_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    $JButton0.setToolTipText(_(getBean().getQuery()));
                }
            }
        });
    }

}