/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.SuspectEvent;
import org.jgroups.Transport;
import org.jgroups.View;
import org.jgroups.blocks.GroupRequest;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.RspFilter;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class GroupRequestTest {
    Address a1;
    Address a2;
    Address a3;
    Vector<Address> dests = null;

    @BeforeClass
    void init() throws UnknownHostException {
        this.a1 = Util.createRandomAddress();
        this.a2 = Util.createRandomAddress();
        this.a3 = Util.createRandomAddress();
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.dests = new Vector<Address>(Arrays.asList(this.a1, this.a2));
        this.dests.add(this.a1);
        this.dests.add(this.a2);
    }

    @AfterMethod
    protected void tearDown() throws Exception {
        this.dests.clear();
    }

    @Test(groups={"functional"})
    public void testMessageTimeout() throws Exception {
        this._testMessageTimeout(true);
    }

    @Test(groups={"functional"})
    public void testMessageReception() throws Exception {
        this._testMessageReception(true);
        this._testMessageReception(false);
    }

    @Test(groups={"functional"})
    public void testMessageReceptionWithSuspect() throws Exception {
        this._testMessageReceptionWithSuspect(true);
        this._testMessageReceptionWithSuspect(false);
    }

    @Test(groups={"functional"})
    public void testMessageReceptionWithViewChange() throws Exception {
        this._testMessageReceptionWithViewChange(true);
        this._testMessageReceptionWithViewChange(false);
    }

    @Test(groups={"functional"})
    public void testMessageReceptionWithViewChangeMemberLeft() throws Exception {
        this._testMessageReceptionWithViewChangeMemberLeft(true);
        this._testMessageReceptionWithViewChangeMemberLeft(false);
    }

    @Test(groups={"functional"})
    public void testGetFirstWithResponseFilter() throws Exception {
        Object[] responses = new Message[]{new Message(null, this.a1, new Long(1L)), new Message(null, this.a2, new Long(2L)), new Message(null, this.a3, new Long(3L))};
        MyDelayedTransport transport = new MyDelayedTransport(true, responses, 500L);
        this.dests.add(this.a3);
        GroupRequest req = new GroupRequest(new Message(), transport, this.dests, new RequestOptions(1, 0L));
        req.setResponseFilter(new RspFilter(){
            int num_rsps = 0;

            @Override
            public boolean isAcceptable(Object response, Address sender) {
                boolean retval = response instanceof Long && (Long)response == 2L;
                System.out.println("-- received " + response + " from " + sender + ": " + (retval ? "OK" : "NOTOK"));
                if (retval) {
                    ++this.num_rsps;
                }
                return retval;
            }

            @Override
            public boolean needMoreResponses() {
                return this.num_rsps < 1;
            }
        });
        transport.setGroupRequest(req);
        boolean rc = req.execute();
        System.out.println("group request is " + req);
        assert (rc);
        assert (req.isDone());
        RspList results = req.getResults();
        Assert.assertEquals((int)3, (int)results.size());
        Assert.assertEquals((int)1, (int)results.numReceived());
    }

    @Test(groups={"functional"})
    public void testGetAllWithResponseFilter() throws Exception {
        Object[] responses = new Message[]{new Message(null, this.a1, new Long(1L)), new Message(null, this.a2, new Long(2L)), new Message(null, this.a3, new Long(3L))};
        MyDelayedTransport transport = new MyDelayedTransport(true, responses, 500L);
        this.dests.add(this.a3);
        GroupRequest req = new GroupRequest(new Message(), transport, this.dests, new RequestOptions(2, 0L));
        req.setResponseFilter(new RspFilter(){
            int num_rsps = 0;

            @Override
            public boolean isAcceptable(Object response, Address sender) {
                boolean retval = response instanceof Long && ((Long)response == 1L || (Long)response == 2L);
                System.out.println("-- received " + response + " from " + sender + ": " + (retval ? "OK" : "NOTOK"));
                if (retval) {
                    ++this.num_rsps;
                }
                return retval;
            }

            @Override
            public boolean needMoreResponses() {
                return this.num_rsps < 2;
            }
        });
        transport.setGroupRequest(req);
        boolean rc = req.execute();
        System.out.println("group request is " + req);
        assert (rc);
        assert (req.isDone());
        RspList results = req.getResults();
        Assert.assertEquals((int)3, (int)results.size());
        Assert.assertEquals((int)2, (int)results.numReceived());
    }

    private void _testMessageTimeout(boolean async) throws Exception {
        int destCount = 10;
        long timeout = destCount * 1000;
        long delay = 75L;
        Object[] responses = new Message[destCount];
        this.dests = new Vector();
        for (int i = 0; i < destCount; ++i) {
            Address addr = Util.createRandomAddress();
            this.dests.add(addr);
            responses[i] = new Message(null, addr, new Long(i));
        }
        MyDelayedTransport tp = new MyDelayedTransport(async, responses, 75L);
        GroupRequest req = new GroupRequest(new Message(), tp, this.dests, new RequestOptions(2, timeout));
        tp.setGroupRequest(req);
        boolean rc = req.execute();
        System.out.println("group request is " + req);
        assert (rc);
        assert (req.isDone());
        RspList results = req.getResults();
        Assert.assertEquals((int)this.dests.size(), (int)results.size());
    }

    private void _testMessageReception(boolean async) throws Exception {
        Object[] responses = new Message[]{new Message(null, this.a1, new Long(1L)), new Message(null, this.a2, new Long(2L))};
        MyTransport transport = new MyTransport(async, responses);
        GroupRequest req = new GroupRequest(new Message(), transport, this.dests, new RequestOptions(2, 0L));
        transport.setGroupRequest(req);
        boolean rc = req.execute();
        System.out.println("group request is " + req);
        assert (rc);
        assert (req.isDone());
        RspList results = req.getResults();
        Assert.assertEquals((int)2, (int)results.size());
    }

    private void _testMessageReceptionWithSuspect(boolean async) throws Exception {
        Object[] responses = new Object[]{new Message(null, this.a1, new Long(1L)), new SuspectEvent(this.a2)};
        MyTransport transport = new MyTransport(async, responses);
        GroupRequest req = new GroupRequest(new Message(), transport, this.dests, new RequestOptions(2, 0L));
        transport.setGroupRequest(req);
        boolean rc = req.execute();
        System.out.println("group request is " + req);
        assert (rc);
        assert (req.isDone());
        RspList results = req.getResults();
        assert (results.size() == 2);
    }

    private void _testMessageReceptionWithViewChange(boolean async) throws Exception {
        Vector<Address> new_dests = new Vector<Address>();
        new_dests.add(this.a1);
        new_dests.add(this.a2);
        new_dests.add(this.a1);
        Object[] responses = new Object[]{new Message(null, this.a1, new Long(1L)), new View(Util.createRandomAddress(), 322649L, new_dests), new Message(null, this.a2, new Long(2L))};
        MyTransport transport = new MyTransport(async, responses);
        GroupRequest req = new GroupRequest(new Message(), transport, this.dests, new RequestOptions(2, 0L));
        transport.setGroupRequest(req);
        boolean rc = req.execute();
        System.out.println("group request is " + req);
        assert (rc);
        assert (req.isDone());
        RspList results = req.getResults();
        Assert.assertEquals((int)2, (int)results.size());
    }

    private void _testMessageReceptionWithViewChangeMemberLeft(boolean async) throws Exception {
        Vector<Address> new_dests = new Vector<Address>();
        new_dests.add(this.a2);
        Object[] responses = new Object[]{new Message(null, this.a2, new Long(1L)), new View(Util.createRandomAddress(), 322649L, new_dests)};
        MyTransport transport = new MyTransport(async, responses);
        GroupRequest req = new GroupRequest(new Message(), transport, this.dests, new RequestOptions(2, 0L));
        transport.setGroupRequest(req);
        System.out.println("group request before execution: " + req);
        boolean rc = req.execute();
        System.out.println("group request after execution: " + req);
        assert (rc);
        assert (req.isDone());
        RspList results = req.getResults();
        Assert.assertEquals((int)2, (int)results.size());
    }

    private static final class MyDelayedTransport
    extends MyTransport {
        long delay;

        public MyDelayedTransport(boolean async, Object[] responses) {
            super(async, responses);
        }

        public MyDelayedTransport(boolean async, Object[] responses, long delay) {
            super(async, responses);
            this.delay = delay;
        }

        @Override
        void sendResponses() {
            if (this.responses != null) {
                for (int i = 0; i < this.responses.length; ++i) {
                    try {
                        Thread.sleep(this.delay);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    Object obj = this.responses[i];
                    if (obj == null) {
                        System.err.println("object was null");
                        continue;
                    }
                    if (obj instanceof Message) {
                        Message msg = (Message)obj;
                        Address sender = msg.getSrc();
                        Object retval = null;
                        try {
                            retval = Util.objectFromByteBuffer(msg.getBuffer());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        this.request.receiveResponse(retval, sender);
                        continue;
                    }
                    if (obj instanceof SuspectEvent) {
                        this.request.suspect((Address)((SuspectEvent)obj).getMember());
                        continue;
                    }
                    if (obj instanceof View) {
                        this.request.viewChange((View)obj);
                        continue;
                    }
                    System.err.println("Object needs to be Message, SuspectEvent or View");
                }
            }
        }
    }

    protected static class MyTransport
    implements Transport {
        GroupRequest request;
        boolean async = true;
        Object[] responses = null;

        public MyTransport(boolean async, Object[] responses) {
            this.async = async;
            this.responses = responses;
        }

        public void setGroupRequest(GroupRequest r) {
            this.request = r;
        }

        @Override
        public void send(Message msg) throws Exception {
            if (this.async) {
                new Thread(){

                    @Override
                    public void run() {
                        MyTransport.this.sendResponses();
                    }
                }.start();
            } else {
                this.sendResponses();
            }
        }

        @Override
        public Object receive(long timeout) throws Exception {
            return null;
        }

        void sendResponses() {
            if (this.responses != null) {
                for (int i = 0; i < this.responses.length; ++i) {
                    Object obj = this.responses[i];
                    if (obj == null) {
                        System.err.println("object was null");
                        continue;
                    }
                    if (obj instanceof Message) {
                        Message msg = (Message)obj;
                        Address sender = msg.getSrc();
                        Object retval = null;
                        try {
                            retval = Util.objectFromByteBuffer(msg.getBuffer());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        this.request.receiveResponse(retval, sender);
                        continue;
                    }
                    if (obj instanceof SuspectEvent) {
                        this.request.suspect((Address)((SuspectEvent)obj).getMember());
                        continue;
                    }
                    if (obj instanceof View) {
                        this.request.viewChange((View)obj);
                        continue;
                    }
                    System.err.println("Object needs to be Message, SuspectEvent or View");
                }
            }
        }
    }
}

