/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.propertysheet;

import com.l2fprod.common.beans.ExtendedPropertyDescriptor;
import com.l2fprod.common.propertysheet.AbstractProperty;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;

class PropertyDescriptorAdapter
extends AbstractProperty {
    private PropertyDescriptor descriptor;

    public PropertyDescriptorAdapter() {
    }

    public PropertyDescriptorAdapter(PropertyDescriptor descriptor) {
        this();
        this.setDescriptor(descriptor);
    }

    public void setDescriptor(PropertyDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public PropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public String getDisplayName() {
        return this.descriptor.getDisplayName();
    }

    public String getShortDescription() {
        return this.descriptor.getShortDescription();
    }

    public Class getType() {
        return this.descriptor.getPropertyType();
    }

    public void readFromObject(Object object) {
        try {
            Method method = this.descriptor.getReadMethod();
            if (method != null) {
                this.setValue(method.invoke(object, null));
            }
        }
        catch (Exception e) {
            String message = "Got exception when reading property " + this.getName();
            message = object == null ? message + ", object was 'null'" : message + ", object was " + String.valueOf(object);
            throw new RuntimeException(message, e);
        }
    }

    public void writeToObject(Object object) {
        try {
            Method method = this.descriptor.getWriteMethod();
            if (method != null) {
                method.invoke(object, this.getValue());
            }
        }
        catch (Exception e) {
            String message = "Got exception when writing property " + this.getName();
            message = object == null ? message + ", object was 'null'" : message + ", object was " + String.valueOf(object);
            throw new RuntimeException(message, e);
        }
    }

    public boolean isEditable() {
        return this.descriptor.getWriteMethod() != null;
    }

    public String getCategory() {
        if (this.descriptor instanceof ExtendedPropertyDescriptor) {
            return ((ExtendedPropertyDescriptor)this.descriptor).getCategory();
        }
        return null;
    }
}

