/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.validator;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jaxx.runtime.validator.BeanValidator;
import jaxx.runtime.validator.BeanValidatorScope;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanValidatorDetector {
    private static final Log log = LogFactory.getLog(BeanValidatorDetector.class);

    public SortedSet<BeanValidator<?>> detect(File sourceRoot, Class<?> ... types) {
        SortedSet<BeanValidator<?>> result = this.detect(BeanValidator.class, sourceRoot, null, types);
        return result;
    }

    public SortedSet<BeanValidator<?>> detect(Class<?> validatorClass, File sourceRoot, Pattern contextFilter, Class<?> ... types) {
        SortedSet<BeanValidator<?>> result = this.detect(validatorClass, sourceRoot, contextFilter, (BeanValidatorScope[])null, types);
        return result;
    }

    public SortedSet<BeanValidator<?>> detect(Class<?> validatorClass, File sourceRoot, Pattern contextFilter, BeanValidatorScope[] scopes, Class<?> ... types) {
        TreeSet result = new TreeSet(new BeanValidatorComparator());
        for (Class<?> c : types) {
            File dir = this.getClassDir(sourceRoot, c);
            if (!dir.exists()) {
                log.debug((Object)("skip non existing directory " + dir));
                continue;
            }
            Object[] contexts = this.getContexts(c, dir);
            if (log.isDebugEnabled()) {
                log.debug((Object)("contexts : " + Arrays.toString(contexts)));
            }
            if (contexts.length <= 0) continue;
            Object[] realContexts = this.getContextsWithoutScopes((String[])contexts);
            if (log.isDebugEnabled()) {
                log.debug((Object)("realContexts : " + Arrays.toString(realContexts)));
            }
            if (contextFilter != null) {
                realContexts = this.getFilterContexts(contextFilter, (String[])realContexts);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("filterContexts : " + Arrays.toString(realContexts)));
                }
            }
            for (Object context : realContexts) {
                BeanValidator<?> validator = this.getValidator(validatorClass, c, (String)(((String)context).isEmpty() ? null : context), scopes);
                if (validator == null) continue;
                result.add(validator);
            }
        }
        return result;
    }

    protected <B> BeanValidator<B> getValidator(Class<?> validatorClass, Class<B> klass, String context, BeanValidatorScope ... scopes) {
        BeanValidator<B> valitator = this.createValidator(validatorClass, klass, context, scopes);
        Set<BeanValidatorScope> resultScopes = valitator.getScopes();
        if (resultScopes.isEmpty()) {
            valitator = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)(klass + " : validator skip (no scopes detected)"));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)(klass + " : keep validator " + valitator));
        }
        return valitator;
    }

    protected <B> BeanValidator<B> createValidator(Class<?> validatorClass, Class<B> klass, String context, BeanValidatorScope[] scopes) {
        BeanValidator valitator;
        try {
            Constructor con = ConstructorUtils.getAccessibleConstructor(validatorClass, (Class[])new Class[]{Class.class, String.class, BeanValidatorScope[].class});
            if (con != null) {
                valitator = (BeanValidator)con.newInstance(new Object[]{klass, context, scopes});
            } else {
                con = ConstructorUtils.getAccessibleConstructor(validatorClass, (Class[])new Class[]{Class.class, String.class, BeanValidatorScope[].class});
                if (con == null) {
                    throw new IllegalStateException("could not find a constructor with (Class.class, String) or (Class,String BeanValidatorScope[])");
                }
                valitator = (BeanValidator)con.newInstance(klass, context);
                if (scopes != null && scopes.length > 0) {
                    valitator.setFilterScopes(scopes);
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("could not instanciate validator " + validatorClass + " for reason " + ex.getMessage(), ex);
        }
        return valitator;
    }

    protected File getClassDir(File sourceRoot, Class<?> clazz) {
        String path = clazz.getPackage().getName();
        path = path.replaceAll("\\.", File.separator);
        File dir = new File(sourceRoot, path);
        return dir;
    }

    protected String[] getContexts(Class<?> clazz, File dir) {
        String[] files;
        TreeSet<String> result = new TreeSet<String>();
        ValidatorFilenameFilter filter = new ValidatorFilenameFilter(clazz);
        if (log.isDebugEnabled()) {
            log.debug((Object)("dir : " + dir));
        }
        for (String file : files = dir.list(filter)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("file " + file));
            }
            String context = file.substring(filter.prefix.length(), file.length() - "-validation.xml".length());
            if (log.isDebugEnabled()) {
                log.debug((Object)("detect " + clazz.getSimpleName() + " context [" + context + "]"));
            }
            result.add(context);
        }
        return result.toArray(new String[result.size()]);
    }

    protected String[] getContextsWithoutScopes(String[] contexts) {
        TreeSet<String> result = new TreeSet<String>();
        BeanValidatorScope[] scopes = BeanValidatorScope.values();
        for (String context : contexts) {
            for (BeanValidatorScope scope : scopes) {
                String realContext;
                String scopeName = scope.name().toLowerCase();
                if (!context.endsWith(scopeName)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("detect context : " + context));
                }
                if ((realContext = context.substring(0, context.length() - scopeName.length())).endsWith("-")) {
                    realContext = realContext.substring(0, realContext.length() - 1);
                }
                result.add(realContext);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    protected String[] getFilterContexts(Pattern contextFilter, String[] realContexts) {
        ArrayList<String> result = new ArrayList<String>();
        for (String c : realContexts) {
            Matcher m = contextFilter.matcher(c);
            if (!m.matches()) continue;
            result.add(c);
        }
        return result.toArray(new String[result.size()]);
    }

    protected static class BeanValidatorComparator
    implements Comparator<BeanValidator<?>> {
        protected BeanValidatorComparator() {
        }

        @Override
        public int compare(BeanValidator<?> o1, BeanValidator<?> o2) {
            String contextName1 = o1.getBeanClass().getSimpleName() + "-" + (o1.getContextName() == null ? "" : o1.getContextName());
            String contextName2 = o2.getBeanClass().getSimpleName() + "-" + (o2.getContextName() == null ? "" : o2.getContextName());
            return contextName1.compareTo(contextName2);
        }
    }

    protected static class ValidatorFilenameFilter
    implements FilenameFilter {
        protected static final String SUFFIX = "-validation.xml";
        protected Class<?> clazz;
        protected String prefix;

        public ValidatorFilenameFilter(Class<?> clazz) {
            this.clazz = clazz;
            this.prefix = clazz.getSimpleName() + "-";
        }

        @Override
        public boolean accept(File dir, String name) {
            boolean result = name.endsWith(SUFFIX);
            if (result) {
                result = name.startsWith(this.prefix);
            }
            return result;
        }
    }
}

