/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.offer.editors;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.editors.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class IdEditor extends com.jurismarches.vradi.ui.offer.editors.VradiEditor<String, IdEditorModel> implements jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_TEXT = "editor.text";
    public static final String BINDING_WIKITTY_ID_TEXT = "wikittyId.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Uz2sTQRR+iU3StMYfKcYWK1YrigibgghCS61Wgy2pipFSzMVJdtpMnd0dZ2bbrQfxT/BP0LsXwZsn8eDZgxfxXxDx4FV8M/mxja42ojnshvfe971v3rxvX3yGjJJwcpNEkSNDXzOPOstX1tZuNTZpU1+jqimZ0IGE9i+VhnQdRt1eXGmYrlcNvNyBlxcDTwQ+9XehZ6swovQOp6pFqdZwvB/RVKpc66VnIxHKLmtPVBLrs69f0k/dJ8/TAJFAdVk8ytReqPgkQ1VIM1dDETttkTIn/gbKkMzfQL0FE1vkRKmbxKMP4THkqpAVRCKZhlODH9lyWHwkNBROr0risusuw5oZDTPNwHM2Q8mUR2SzRZWzZfJOyJxgfZ1Kh9pK5Sy5bYwQliyrIeMFLuUaLv4txYrBxTz5LcKZSzCh4Xzf9HoJR23jVJyaea52gzFDod1hMfC1nU7RzC7qgJZvE393u2y7WEOpr+oujXSFUe6asmIsbps9YFrvLNn40U5SwrE+obhATrxA8Q2n6pCRIYY1jNd/3bk7mGpv2/hP22YIbfZ7aezD60+vKt0Vy2PvI4mluxyCVy9kIKjUzLQ+2N6vUDNeXiFito4slKO9rH0mE4TVOmkUh/0OG7hj4M4NolpIkcl9fPO2dP/9PkhXYIQHxK0QU78Eed2SOIWAu5G4vGAV7d8exuchow2nz8lOEOIdHZjDSyRTDea7OP/5CIcwmTCEnpJG/t23sdrLhe4gUihs4rfl8TAy9yDLfM58at3WMVKiu0aFoqEbxIZJslDKvMdEZ59O2Od00klHPRIxL/Rq7JFtcCYKzeus1W7+nRuYKtcMeOj5eFnFufZZpojGD0Uj1HQ+mbY0kELmD6BwEKqCkBStLqn7H8iGNHrxHzmGjctJg1stF5J5JvbkMeFLf1AyGMPVPRh+AO1fZpIFBwAA";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.offer.editors.IdEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JTextField editor;
    protected com.jurismarches.vradi.ui.offer.editors.IdEditorModel model;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.offer.editors.IdEditorModel > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();
    protected javax.swing.JTextField wikittyId;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private IdEditor $VradiEditor0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void registerValidator() {
                validator.setContextName(model.getValidatorContext());
                validator.setBean(model);
                getContextValue(jaxx.runtime.validator.swing.SwingValidatorMessageTableModel.class,"errorEditorTable")
                        .registerValidator(validator);
    
                log.debug("registration : " + validator.getContextName());
            }
    
            public String getModifiablePartOfValue(String value) {
                if(value == null) {
                    return null;
                }
                int modifiablePartLength =
                        VradiConstants.FORM_ID_DATE_FORMAT.toPattern().length();
                return value.substring(0, modifiablePartLength);
            }
    
            public String getUnmodifiablePartOfValue(String value) {
                if(value == null) {
                    return null;
                }
                int unmodifiablePartLength =
                        VradiConstants.FORM_ID_DATE_FORMAT.toPattern().length();
                return value.substring(unmodifiablePartLength);
            }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public IdEditor() {
        super();
        $initialize();
    }

    public IdEditor(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.offer.editors.IdEditorModel > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doKeyReleased__on__editor(java.awt.event.KeyEvent event) {
        setValue(editor.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JTextField getEditor() {
        return editor;
    }

    public com.jurismarches.vradi.ui.offer.editors.IdEditorModel getModel() {
        return model;
    }

    public javax.swing.JTextField getWikittyId() {
        return wikittyId;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerValidatorFields() {
        validator.setFieldRepresentation("value", editor);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditorContent() {
        if (!allComponentsCreated) {
            return;
        }
        editorContent.add(SwingUtil.boxComponentWithJxLayer(editor), BorderLayout.WEST);
        editorContent.add(wikittyId, BorderLayout.CENTER);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new javax.swing.JTextField());
        
        editor.setName("editor");
        editor.setColumns(15);
        editor.setColumns(8);
        editor.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__editor"));
    }

    @Override
    protected void createEditorContent() {
        super.createEditorContent();
        editorContent.setName("editorContent");
        ((javax.swing.JPanel) editorContent).setLayout(new BorderLayout());
    }

    protected void createModel() {
        $objectMap.put("model", model = new com.jurismarches.vradi.ui.offer.editors.IdEditorModel());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.offer.editors.IdEditorModel >(com.jurismarches.vradi.ui.offer.editors.IdEditorModel.class, null));
    }

    protected void createWikittyId() {
        $objectMap.put("wikittyId", wikittyId = new javax.swing.JTextField());
        
        wikittyId.setName("wikittyId");
        wikittyId.setColumns(15);
        wikittyId.setEditable(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToValidator();
        addChildrenToEditorContent();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        ((javax.swing.JPanel) editorContent).setMaximumSize(new Dimension(0, 28));
        editor.setMinimumSize(new Dimension(0,28));
        editor.setPreferredSize(new Dimension(0,28));
        wikittyId.setMinimumSize(new Dimension(0,28));
        // late initializer
        // register 1 validator(s)
        registerValidatorFields();validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$VradiEditor0", this);
        createModel();
        createValidator();
        createEditor();
        createWikittyId();
        // inline creation of $VradiEditor0
        setName("$VradiEditor0");
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("value", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    jaxx.runtime.SwingUtil.setText(editor, getModifiablePartOfValue(model.getValue()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("value", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_WIKITTY_ID_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("value", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    jaxx.runtime.SwingUtil.setText(wikittyId, getUnmodifiablePartOfValue(model.getValue()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("value", this);
                }
            }
        });
    }

}