/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.offer.editors;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.editors.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.editor.*;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class EmailEditor extends com.jurismarches.vradi.ui.offer.editors.VradiEditor<String, EmailEditorModel> implements jaxx.runtime.JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_TEXT = "editor.text";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVTz2sTQRR+iU1qWuuPhpYWK1QtKAoTwYsQ0dbaoiFVMVJKc3GSnTZTZnfGmdl260H8E/wT9O5F8OZJPHj24EX8F0Q8eBXf7CbZRre0aA6z4b33fe+bb957/Q0KRsPZLRpFRIeB5T4jtYW1tfutLda2t5lpa66s1JD8cnnIN2HU68eNhfPNuoNXuvDKovSVDFiwB12tw4ixu4KZDmPWwplBRNuYSqOfrkYq1D3Wvqgs1pc/vudfeM9f5QEiheqKeJXZg1DpTYbqkOeehXHstE0rggabKEPzYBP1jrnYoqDG3KM+ewLPYLgORUU1klk4d/grxxwxPlIWxuZWNfX4ksex5oqFq23pk61Qc+NT3e4wQ7ZdnoScyI0NpgmLKw1Z8ikXCUypmK9ooeBLjwkL1/6BZcVBU6rSNhXco5iwcHnAw36CmB30hjTcudoLpgxjSZNFGdjYo3HnYNQF1R7QYG+7YlJsYWKg6hGL7IJm1FWNp9rmardCa2WAhpUH6pNwt1rD6QHhOFYkHav03XNNKOgQwxammn9P4kNMJTM49ccMOsI4+2uy/Pnd17fLvcFzOzSRWbpnb3AglJaKactd6xPJ1IWWi8oKVdUmlAwTuHTxUs1kCGt00ygO+51ycOLg5A41HaQoDH95/2Hy8acjkF+GESGpt0xd/V0o2Y5GF6TwInVzPlZ0bOconiedNnwNQXclWgnHr+Oj0tkWDzz090aEJsxkmNBX0ip9/FluvJnvGZFDYdP7lqdmFNahyAPBAxbvYHe9MnduVBkWejJdo6zFyrlvWXXnazY+57JuOurzgPuh3+BP4wYXotB9Lsba3b9LMdXkIaiGLA7r/3LwdjK++3BMH4JjmAW0JZh3AM1vJC0tfesFAAA=";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.offer.editors.EmailEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JTextArea editor;
    protected com.jurismarches.vradi.ui.offer.editors.EmailEditorModel model;
    protected jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.offer.editors.EmailEditorModel > validator;
    protected java.util.List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private EmailEditor $VradiEditor0 = this;
    private javax.swing.JButton $JButton0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void registerValidator() {
                validator.setBean(model);
                getContextValue(jaxx.runtime.validator.swing.SwingValidatorMessageTableModel.class,"errorEditorTable")
                        .registerValidator(validator);
            }
    
            protected void createEmail() {
                try {
                    UIHelper.createEmail(editor.getText());
                } catch(java.io.IOException eee) {
                    if (log.isErrorEnabled()) {
                        log.error(eee);
                    }
                    ErrorDialogUI.showError(eee);
                } catch(java.net.URISyntaxException eee) {
                    if (log.isErrorEnabled()) {
                        log.error(eee);
                    }
                    ErrorDialogUI.showError(eee);
                } catch(java.lang.UnsupportedOperationException eee) {
                    if (log.isErrorEnabled()) {
                        log.error(eee);
                    }
                    ErrorDialogUI.showError(eee);
                }
            }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EmailEditor() {
        super();
        $initialize();
    }

    public EmailEditor(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidation implementation --------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.offer.editors.EmailEditorModel > getValidator() {
        return validator;
    }

    @Override
    public jaxx.runtime.validator.swing.SwingValidator<?> getValidator(String validatorId) {
        return (jaxx.runtime.validator.swing.SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public java.util.List<String> getValidatorIds() {
        return validatorIds;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        createEmail();
    }

    public void doKeyReleased__on__editor(java.awt.event.KeyEvent event) {
        setValue(editor.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JTextArea getEditor() {
        return editor;
    }

    public com.jurismarches.vradi.ui.offer.editors.EmailEditorModel getModel() {
        return model;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerValidatorFields() {
        validator.setFieldRepresentation("value", editor);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditorContent() {
        if (!allComponentsCreated) {
            return;
        }
        editorContent.add(SwingUtil.boxComponentWithJxLayer(editor), BorderLayout.CENTER);
        editorContent.add($JButton0, BorderLayout.EAST);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(jaxx.runtime.validator.swing.ui.ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new javax.swing.JTextArea());
        
        editor.setName("editor");
        editor.setColumns(15);
        editor.setLineWrap(true);
        editor.setWrapStyleWord(true);
        editor.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__editor"));
    }

    @Override
    protected void createEditorContent() {
        super.createEditorContent();
        editorContent.setName("editorContent");
        ((javax.swing.JPanel) editorContent).setLayout(new BorderLayout());
    }

    protected void createModel() {
        $objectMap.put("model", model = new com.jurismarches.vradi.ui.offer.editors.EmailEditorModel());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = new jaxx.runtime.validator.swing.SwingValidator< com.jurismarches.vradi.ui.offer.editors.EmailEditorModel >(com.jurismarches.vradi.ui.offer.editors.EmailEditorModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToValidator();
        addChildrenToEditorContent();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        editor.setMinimumSize(new Dimension(0,28));
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("send"));
        // late initializer
        // register 1 validator(s)
        registerValidatorFields();validatorIds.add("validator");
        getValidator("validator").installUIs();
        getValidator("validator").reloadBean();
        validatorIds = java.util.Collections.unmodifiableList(validatorIds);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$VradiEditor0", this);
        createModel();
        createValidator();
        createEditor();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $VradiEditor0
        setName("$VradiEditor0");
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("value", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    jaxx.runtime.SwingUtil.setText(editor, model.getValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("value", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JBUTTON0_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("value", this);
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    $JButton0.setEnabled(getValue() != null && validator.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("value", this);
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}